/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools;

import java.util.List;

public class Queue {
    private final Object[] _buf;
    private boolean _closed = false;
    private int _size = 0;
    private int _head = 0;
    private int _tail = 0;

    public Queue(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size is nonpositive:" + size);
        }
        this._buf = new Object[size];
    }

    public final synchronized int size() {
        return this._size;
    }

    public final synchronized boolean isClosed() {
        return this._closed;
    }

    public synchronized void close() {
        this._closed = true;
        this.notifyAll();
    }

    public final boolean isFull() {
        return this.size() == this._buf.length;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void add(Object obj) throws InterruptedException, IllegalStateException {
        while (this.isFull() && !this.isClosed()) {
            this.wait();
        }
        this._checkIsClosed();
        this._buf[this._head] = obj;
        this._head = this._incIndex(this._head);
        ++this._size;
        this.notifyAll();
    }

    public synchronized Object remove() throws InterruptedException, IllegalStateException {
        while (this.isEmpty()) {
            this._checkIsClosed();
            this.wait();
        }
        Object res = this._buf[this._tail];
        this._buf[this._tail] = null;
        this._tail = this._incIndex(this._tail);
        --this._size;
        this.notifyAll();
        return res;
    }

    public synchronized int remove(List collector, int count) throws InterruptedException, IllegalStateException {
        int read;
        collector.add(this.remove());
        int sz = this.size() + 1;
        if (count == 0 || count > sz) {
            count = sz;
        } else if (count < 0) {
            throw new IllegalArgumentException("count is negative");
        }
        try {
            for (read = 1; read < count; ++read) {
                collector.add(this.remove());
            }
        }
        catch (IllegalStateException e) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return read;
    }

    private int _incIndex(int index) {
        return ++index < this._buf.length ? index : 0;
    }

    private void _checkIsClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Queue has been closed");
        }
    }
}

