/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.cache.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3OutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(S3OutputStream.class);
    private final AmazonS3 s3;
    private final String bucket;
    private final String key;
    private final ProgressListener progressListener;
    private final int partSize;
    private boolean closed;
    private ByteBuffer buffer;
    private MultipartUpload multiPartUpload;

    public S3OutputStream(String bucket, String key, AmazonS3 s3) {
        this.s3 = s3;
        this.bucket = bucket;
        this.key = key;
        this.partSize = 1024;
        this.closed = false;
        this.buffer = ByteBuffer.allocate(this.partSize);
        this.progressListener = new ConnectProgressListener();
        this.multiPartUpload = null;
        log.debug("Create S3OutputStream for bucket '{}' key '{}'", (Object)bucket, (Object)key);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.put((byte)b);
        if (!this.buffer.hasRemaining()) {
            this.uploadPart();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.buffer.remaining() < len) {
            int firstPart = this.buffer.remaining();
            this.buffer.put(b, off, firstPart);
            this.uploadPart();
            this.write(b, off + firstPart, len - firstPart);
        } else {
            this.buffer.put(b, off, len);
        }
    }

    private void uploadPart() throws IOException {
        this.uploadPart(this.partSize);
        this.buffer.clear();
    }

    private void uploadPart(int size) throws IOException {
        if (this.multiPartUpload == null) {
            log.debug("New multi-part upload for bucket '{}' key '{}'", (Object)this.bucket, (Object)this.key);
            this.multiPartUpload = this.newMultipartUpload();
        }
        try {
            this.multiPartUpload.uploadPart(new ByteArrayInputStream(this.buffer.array()), size);
        }
        catch (Exception e) {
            if (this.multiPartUpload != null) {
                this.multiPartUpload.abort();
                log.debug("Multipart upload aborted for bucket '{}' key '{}'.", (Object)this.bucket, (Object)this.key);
            }
            throw new IOException("Part upload failed: ", e.getCause());
        }
    }

    public void commit() throws IOException {
        if (this.closed) {
            log.warn("Tried to commit data for bucket '{}' key '{}' on a closed stream. Ignoring.", (Object)this.bucket, (Object)this.key);
            return;
        }
        try {
            if (this.buffer.hasRemaining()) {
                this.uploadPart(this.buffer.position());
            }
            this.multiPartUpload.complete();
            log.debug("Upload complete for bucket '{}' key '{}'", (Object)this.bucket, (Object)this.key);
        }
        catch (Exception e) {
            log.error("Multipart upload failed to complete for bucket '{}' key '{}'", (Object)this.bucket, (Object)this.key);
            throw new RuntimeException("Multipart upload failed to complete.", e);
        }
        finally {
            this.buffer.clear();
            this.multiPartUpload = null;
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.multiPartUpload != null) {
            this.multiPartUpload.abort();
            log.debug("Multipart upload aborted for bucket '{}' key '{}'.", (Object)this.bucket, (Object)this.key);
        }
        super.close();
    }

    private MultipartUpload newMultipartUpload() throws IOException {
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.bucket, this.key, new ObjectMetadata());
        try {
            return new MultipartUpload(this.s3.initiateMultipartUpload(initRequest).getUploadId());
        }
        catch (AmazonClientException e) {
            throw new IOException("Unable to initiate MultipartUpload: " + String.valueOf((Object)e), e);
        }
    }

    private static class ConnectProgressListener
    implements ProgressListener {
        private ConnectProgressListener() {
        }

        public void progressChanged(ProgressEvent progressEvent) {
            log.debug("Progress event: " + String.valueOf(progressEvent));
        }
    }

    private class MultipartUpload {
        private final String uploadId;
        private final List<PartETag> partETags;

        public MultipartUpload(String uploadId) {
            this.uploadId = uploadId;
            this.partETags = new ArrayList<PartETag>();
            log.debug("Initiated multi-part upload for bucket '{}' key '{}' with id '{}'", new Object[]{S3OutputStream.this.bucket, S3OutputStream.this.key, uploadId});
        }

        public void uploadPart(ByteArrayInputStream inputStream, int partSize) {
            int currentPartNumber = this.partETags.size() + 1;
            UploadPartRequest request = (UploadPartRequest)new UploadPartRequest().withBucketName(S3OutputStream.this.bucket).withKey(S3OutputStream.this.key).withUploadId(this.uploadId).withInputStream((InputStream)inputStream).withPartNumber(currentPartNumber).withPartSize((long)partSize).withGeneralProgressListener(S3OutputStream.this.progressListener);
            log.debug("Uploading part {} for id '{}'", (Object)currentPartNumber, (Object)this.uploadId);
            this.partETags.add(S3OutputStream.this.s3.uploadPart(request).getPartETag());
        }

        public void complete() {
            log.debug("Completing multi-part upload for key '{}', id '{}'", (Object)S3OutputStream.this.key, (Object)this.uploadId);
            CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(S3OutputStream.this.bucket, S3OutputStream.this.key, this.uploadId, this.partETags);
            S3OutputStream.this.s3.completeMultipartUpload(completeRequest);
        }

        public void abort() {
            log.warn("Aborting multi-part upload with id '{}'", (Object)this.uploadId);
            try {
                S3OutputStream.this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(S3OutputStream.this.bucket, S3OutputStream.this.key, this.uploadId));
            }
            catch (Exception e) {
                log.warn("Unable to abort multipart upload, you may need to purge uploaded parts: ", (Throwable)e);
            }
        }
    }
}

