/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.properties;

import java.io.File;
import org.apache.nifi.minifi.commons.utils.SensitivePropertyUtils;
import org.apache.nifi.minifi.properties.BootstrapProperties;
import org.apache.nifi.minifi.properties.PropertiesLoader;
import org.apache.nifi.minifi.properties.ProtectedBootstrapProperties;
import org.apache.nifi.properties.AesGcmSensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProvider;

public class BootstrapPropertiesLoader {
    public static BootstrapProperties load(File file) {
        ProtectedBootstrapProperties protectedProperties = BootstrapPropertiesLoader.loadProtectedProperties(file);
        if (protectedProperties.hasProtectedKeys()) {
            String sensitiveKey = protectedProperties.getApplicationProperties().getProperty("minifi.bootstrap.sensitive.key");
            BootstrapPropertiesLoader.validateSensitiveKeyProperty(sensitiveKey);
            String keyHex = SensitivePropertyUtils.getFormattedKey((String)sensitiveKey);
            protectedProperties.addSensitivePropertyProvider((SensitivePropertyProvider)new AesGcmSensitivePropertyProvider(keyHex));
        }
        return protectedProperties.getUnprotectedProperties();
    }

    public static ProtectedBootstrapProperties loadProtectedProperties(File file) {
        return new ProtectedBootstrapProperties(PropertiesLoader.load(file, "Bootstrap"));
    }

    private static void validateSensitiveKeyProperty(String sensitiveKey) {
        if (sensitiveKey == null || sensitiveKey.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("bootstrap.conf contains protected properties but %s is not found", "minifi.bootstrap.sensitive.key"));
        }
    }
}

