/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.properties;

import java.io.File;
import org.apache.nifi.minifi.properties.MultiSourceMinifiProperties;
import org.apache.nifi.minifi.properties.PropertiesLoader;
import org.apache.nifi.minifi.properties.ProtectedMiNiFiProperties;
import org.apache.nifi.properties.AesGcmSensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.apache.nifi.util.NiFiProperties;

public class MiNiFiPropertiesLoader {
    private static final String DEFAULT_APPLICATION_PROPERTIES_FILE_PATH = NiFiBootstrapUtils.getDefaultApplicationPropertiesFilePath();
    private NiFiProperties instance;
    private String keyHex;

    public MiNiFiPropertiesLoader(String keyHex) {
        this.keyHex = keyHex;
    }

    ProtectedMiNiFiProperties loadProtectedProperties(File file) {
        return new ProtectedMiNiFiProperties(PropertiesLoader.load(file, "Application"));
    }

    public NiFiProperties load(File file) {
        ProtectedMiNiFiProperties protectedProperties = this.loadProtectedProperties(file);
        if (protectedProperties.hasProtectedKeys()) {
            protectedProperties.addSensitivePropertyProvider((SensitivePropertyProvider)new AesGcmSensitivePropertyProvider(this.keyHex));
        }
        return new MultiSourceMinifiProperties(protectedProperties.getUnprotectedPropertiesAsMap());
    }

    public NiFiProperties load(String path) {
        if (path != null && !path.trim().isEmpty()) {
            return this.load(new File(path));
        }
        return this.loadDefault();
    }

    public NiFiProperties get() {
        if (this.instance == null) {
            this.instance = this.loadDefault();
        }
        return this.instance;
    }

    private NiFiProperties loadDefault() {
        return this.load(DEFAULT_APPLICATION_PROPERTIES_FILE_PATH);
    }
}

