/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.minifi.properties.BootstrapProperties;
import org.apache.nifi.minifi.properties.ProtectedMiNiFiProperties;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.ProtectedProperties;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProtector;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedBootstrapProperties
extends BootstrapProperties
implements ProtectedProperties<BootstrapProperties>,
SensitivePropertyProtector<ProtectedBootstrapProperties, BootstrapProperties> {
    private static final Logger logger = LoggerFactory.getLogger(ProtectedBootstrapProperties.class);
    private BootstrapProperties bootstrapProperties;
    private final SensitivePropertyProtector<ProtectedBootstrapProperties, BootstrapProperties> propertyProtectionDelegate;

    public ProtectedBootstrapProperties(BootstrapProperties props) {
        this.bootstrapProperties = props;
        this.propertyProtectionDelegate = new ApplicationPropertiesProtector((ProtectedProperties)this);
        logger.debug("Loaded {} properties (including {} protection schemes) into ProtectedBootstrapProperties", (Object)this.getApplicationProperties().getPropertyKeys().size(), (Object)this.getProtectedPropertyKeys().size());
    }

    public ProtectedBootstrapProperties(Properties rawProps) {
        this(new BootstrapProperties(rawProps));
    }

    public Set<String> getPropertyKeysIncludingProtectionSchemes() {
        return this.propertyProtectionDelegate.getPropertyKeysIncludingProtectionSchemes();
    }

    public List<String> getSensitivePropertyKeys() {
        return this.propertyProtectionDelegate.getSensitivePropertyKeys();
    }

    public List<String> getPopulatedSensitivePropertyKeys() {
        return this.propertyProtectionDelegate.getPopulatedSensitivePropertyKeys();
    }

    public boolean hasProtectedKeys() {
        return this.propertyProtectionDelegate.hasProtectedKeys();
    }

    public Map<String, String> getProtectedPropertyKeys() {
        return this.propertyProtectionDelegate.getProtectedPropertyKeys();
    }

    public boolean isPropertySensitive(String key) {
        return this.propertyProtectionDelegate.isPropertySensitive(key);
    }

    public boolean isPropertyProtected(String key) {
        return this.propertyProtectionDelegate.isPropertyProtected(key);
    }

    public BootstrapProperties getUnprotectedProperties() throws SensitivePropertyProtectionException {
        return (BootstrapProperties)this.propertyProtectionDelegate.getUnprotectedProperties();
    }

    public void addSensitivePropertyProvider(SensitivePropertyProvider sensitivePropertyProvider) {
        this.propertyProtectionDelegate.addSensitivePropertyProvider(sensitivePropertyProvider);
    }

    public String getAdditionalSensitivePropertiesKeys() {
        return this.getProperty(this.getAdditionalSensitivePropertiesKeysName());
    }

    public String getAdditionalSensitivePropertiesKeysName() {
        return "nifi.minifi.sensitive.props.additional.keys";
    }

    public List<String> getDefaultSensitiveProperties() {
        return Stream.of(ProtectedMiNiFiProperties.DEFAULT_SENSITIVE_PROPERTIES, Arrays.stream(MiNiFiProperties.values()).filter(MiNiFiProperties::isSensitive).map(MiNiFiProperties::getKey).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public BootstrapProperties getApplicationProperties() {
        if (this.bootstrapProperties == null) {
            this.bootstrapProperties = new BootstrapProperties();
        }
        return this.bootstrapProperties;
    }

    public BootstrapProperties createApplicationProperties(Properties rawProperties) {
        return new BootstrapProperties(rawProperties);
    }
}

