/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.ProtectedProperties;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProtector;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedMiNiFiProperties
extends NiFiProperties
implements ProtectedProperties<NiFiProperties>,
SensitivePropertyProtector<ProtectedMiNiFiProperties, NiFiProperties> {
    private static final Logger logger = LoggerFactory.getLogger(ProtectedMiNiFiProperties.class);
    public static final List<String> DEFAULT_SENSITIVE_PROPERTIES = new ArrayList<String>(Arrays.asList("nifi.security.keyPasswd", "nifi.security.keystorePasswd", "nifi.security.truststorePasswd", "nifi.sensitive.props.key"));
    private final SensitivePropertyProtector<ProtectedMiNiFiProperties, NiFiProperties> propertyProtectionDelegate;
    private NiFiProperties applicationProperties;

    public ProtectedMiNiFiProperties() {
        this(new NiFiProperties());
    }

    public ProtectedMiNiFiProperties(NiFiProperties props) {
        this.applicationProperties = props;
        this.propertyProtectionDelegate = new ApplicationPropertiesProtector((ProtectedProperties)this);
        logger.debug("Loaded {} properties (including {} protection schemes) into ProtectedNiFiProperties", (Object)this.getApplicationProperties().getPropertyKeys().size(), (Object)this.getProtectedPropertyKeys().size());
    }

    public ProtectedMiNiFiProperties(Properties rawProps) {
        this(new NiFiProperties(rawProps));
    }

    public String getAdditionalSensitivePropertiesKeys() {
        return this.getProperty(this.getAdditionalSensitivePropertiesKeysName());
    }

    public String getAdditionalSensitivePropertiesKeysName() {
        return "nifi.minifi.sensitive.props.additional.keys";
    }

    public List<String> getDefaultSensitiveProperties() {
        return Stream.of(DEFAULT_SENSITIVE_PROPERTIES, Arrays.stream(MiNiFiProperties.values()).filter(MiNiFiProperties::isSensitive).map(MiNiFiProperties::getKey).toList()).flatMap(Collection::stream).distinct().toList();
    }

    public NiFiProperties getApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = new NiFiProperties();
        }
        return this.applicationProperties;
    }

    public NiFiProperties createApplicationProperties(Properties rawProperties) {
        return new NiFiProperties(rawProperties);
    }

    public String getProperty(String key) {
        return this.getApplicationProperties().getProperty(key);
    }

    public Set<String> getPropertyKeys() {
        return this.propertyProtectionDelegate.getPropertyKeys();
    }

    public int size() {
        return this.propertyProtectionDelegate.size();
    }

    public Set<String> getPropertyKeysIncludingProtectionSchemes() {
        return this.propertyProtectionDelegate.getPropertyKeysIncludingProtectionSchemes();
    }

    public List<String> getSensitivePropertyKeys() {
        return this.propertyProtectionDelegate.getSensitivePropertyKeys();
    }

    public List<String> getPopulatedSensitivePropertyKeys() {
        return this.propertyProtectionDelegate.getPopulatedSensitivePropertyKeys();
    }

    public boolean hasProtectedKeys() {
        return this.propertyProtectionDelegate.hasProtectedKeys();
    }

    public Map<String, String> getProtectedPropertyKeys() {
        return this.propertyProtectionDelegate.getProtectedPropertyKeys();
    }

    public boolean isPropertySensitive(String key) {
        return this.propertyProtectionDelegate.isPropertySensitive(key);
    }

    public boolean isPropertyProtected(String key) {
        return this.propertyProtectionDelegate.isPropertyProtected(key);
    }

    public NiFiProperties getUnprotectedProperties() throws SensitivePropertyProtectionException {
        return (NiFiProperties)this.propertyProtectionDelegate.getUnprotectedProperties();
    }

    public void addSensitivePropertyProvider(SensitivePropertyProvider sensitivePropertyProvider) {
        this.propertyProtectionDelegate.addSensitivePropertyProvider(sensitivePropertyProvider);
    }

    public Map<String, String> getUnprotectedPropertiesAsMap() {
        NiFiProperties niFiProperties = (NiFiProperties)this.propertyProtectionDelegate.getUnprotectedProperties();
        return niFiProperties.getPropertyKeys().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((NiFiProperties)niFiProperties).getProperty(arg_0)));
    }

    public static int countProtectedProperties(NiFiProperties plainProperties) {
        return new ProtectedMiNiFiProperties(plainProperties).getProtectedPropertyKeys().size();
    }

    public static int countSensitiveProperties(NiFiProperties plainProperties) {
        return new ProtectedMiNiFiProperties(plainProperties).getSensitivePropertyKeys().size();
    }

    public String toString() {
        return String.format("%s Size [%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.size());
    }
}

