/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema.v2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.toolkit.schema.ComponentStatusRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ConfigSchema;
import org.apache.nifi.minifi.toolkit.schema.ConnectionSchema;
import org.apache.nifi.minifi.toolkit.schema.ContentRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.FlowControllerSchema;
import org.apache.nifi.minifi.toolkit.schema.FlowFileRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ProvenanceReportingSchema;
import org.apache.nifi.minifi.toolkit.schema.ProvenanceRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.SecurityPropertiesSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithId;
import org.apache.nifi.minifi.toolkit.schema.common.CollectionOverlap;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.schema.v2.CorePropertiesSchemaV2;
import org.apache.nifi.minifi.toolkit.schema.v2.ProcessGroupSchemaV2;
import org.apache.nifi.minifi.toolkit.schema.v2.RemoteProcessGroupSchemaV2;

public class ConfigSchemaV2
extends BaseSchema
implements ConvertableSchema<ConfigSchema> {
    public static final int CONFIG_VERSION = 2;
    public static final String VERSION = "MiNiFi Config Version";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_INPUT_PORT_IDS = "Found the following duplicate input port ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_OUTPUT_PORT_IDS = "Found the following duplicate output port ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_IDS = "Found the following ids that occur both in more than one Processor(s), Input Port(s), Output Port(s) and/or Remote Input Port(s): ";
    public static final String CONNECTION_WITH_ID = "Connection with id ";
    public static final String HAS_INVALID_SOURCE_ID = " has invalid source id ";
    public static final String HAS_INVALID_DESTINATION_ID = " has invalid destination id ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_PROCESSOR_IDS = "Found the following duplicate processor ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_CONNECTION_IDS = "Found the following duplicate connection ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_FUNNEL_IDS = "Found the following duplicate funnel ids: ";
    public static String TOP_LEVEL_NAME = "top level";
    private FlowControllerSchema flowControllerProperties;
    private CorePropertiesSchemaV2 coreProperties;
    private FlowFileRepositorySchema flowfileRepositoryProperties;
    private ContentRepositorySchema contentRepositoryProperties;
    private ComponentStatusRepositorySchema componentStatusRepositoryProperties;
    private SecurityPropertiesSchema securityProperties;
    private ProcessGroupSchemaV2 processGroupSchema;
    private ProvenanceReportingSchema provenanceReportingProperties;
    private ProvenanceRepositorySchema provenanceRepositorySchema;

    public ConfigSchemaV2(Map map) {
        this(map, Collections.emptyList());
    }

    public ConfigSchemaV2(Map map, List<String> validationIssues) {
        validationIssues.stream().forEach(this::addValidationIssue);
        this.flowControllerProperties = this.getMapAsType(map, "Flow Controller", FlowControllerSchema.class, TOP_LEVEL_NAME, true);
        this.coreProperties = this.getMapAsType(map, "Core Properties", CorePropertiesSchemaV2.class, TOP_LEVEL_NAME, false);
        this.flowfileRepositoryProperties = this.getMapAsType(map, "FlowFile Repository", FlowFileRepositorySchema.class, TOP_LEVEL_NAME, false);
        this.contentRepositoryProperties = this.getMapAsType(map, "Content Repository", ContentRepositorySchema.class, TOP_LEVEL_NAME, false);
        this.provenanceRepositorySchema = this.getMapAsType(map, "Provenance Repository", ProvenanceRepositorySchema.class, TOP_LEVEL_NAME, false);
        this.componentStatusRepositoryProperties = this.getMapAsType(map, "Component Status Repository", ComponentStatusRepositorySchema.class, TOP_LEVEL_NAME, false);
        this.securityProperties = this.getMapAsType(map, "Security Properties", SecurityPropertiesSchema.class, TOP_LEVEL_NAME, false);
        this.processGroupSchema = new ProcessGroupSchemaV2(map, TOP_LEVEL_NAME);
        this.provenanceReportingProperties = (ProvenanceReportingSchema)this.getMapAsType(map, "Provenance Reporting", ProvenanceReportingSchema.class, TOP_LEVEL_NAME, false, false);
        this.addIssuesIfNotNull(this.flowControllerProperties);
        this.addIssuesIfNotNull(this.coreProperties);
        this.addIssuesIfNotNull(this.flowfileRepositoryProperties);
        this.addIssuesIfNotNull(this.contentRepositoryProperties);
        this.addIssuesIfNotNull(this.componentStatusRepositoryProperties);
        this.addIssuesIfNotNull(this.securityProperties);
        this.addIssuesIfNotNull(this.processGroupSchema);
        this.addIssuesIfNotNull(this.provenanceReportingProperties);
        this.addIssuesIfNotNull(this.provenanceRepositorySchema);
        List<ProcessGroupSchemaV2> allProcessGroups = ConfigSchemaV2.getAllProcessGroups(this.processGroupSchema);
        List<ConnectionSchema> allConnectionSchemas = allProcessGroups.stream().flatMap(p -> p.getConnections().stream()).collect(Collectors.toList());
        List allRemoteProcessGroups = allProcessGroups.stream().flatMap(p -> p.getRemoteProcessGroups().stream()).collect(Collectors.toList());
        List<String> allProcessorIds = allProcessGroups.stream().flatMap(p -> p.getProcessors().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allFunnelIds = allProcessGroups.stream().flatMap(p -> p.getFunnels().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allConnectionIds = allConnectionSchemas.stream().map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List allRemoteProcessGroupNames = allRemoteProcessGroups.stream().map(RemoteProcessGroupSchemaV2::getName).collect(Collectors.toList());
        List allRemoteInputPortIds = allRemoteProcessGroups.stream().filter(r -> r.getInputPorts() != null).flatMap(r -> r.getInputPorts().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allInputPortIds = allProcessGroups.stream().flatMap(p -> p.getInputPortSchemas().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allOutputPortIds = allProcessGroups.stream().flatMap(p -> p.getOutputPortSchemas().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        ConfigSchemaV2.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_PROCESSOR_IDS, allProcessorIds);
        ConfigSchemaV2.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_FUNNEL_IDS, allFunnelIds);
        ConfigSchemaV2.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_CONNECTION_IDS, allConnectionIds);
        ConfigSchemaV2.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_INPUT_PORT_IDS, allInputPortIds);
        ConfigSchemaV2.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_OUTPUT_PORT_IDS, allOutputPortIds);
        CollectionOverlap overlapResults = new CollectionOverlap(new HashSet<String>(allProcessorIds), new HashSet(allRemoteInputPortIds), new HashSet<String>(allInputPortIds), new HashSet<String>(allOutputPortIds), new HashSet<String>(allFunnelIds));
        if (overlapResults.getDuplicates().size() > 0) {
            this.addValidationIssue(FOUND_THE_FOLLOWING_DUPLICATE_IDS + overlapResults.getDuplicates().stream().sorted().collect(Collectors.joining(", ")));
        }
        allConnectionSchemas.forEach(c -> {
            String sourceId;
            String destinationId = c.getDestinationId();
            if (!StringUtil.isNullOrEmpty(destinationId) && !overlapResults.getElements().contains(destinationId)) {
                this.addValidationIssue(CONNECTION_WITH_ID + c.getId() + HAS_INVALID_DESTINATION_ID + destinationId);
            }
            if (!StringUtil.isNullOrEmpty(sourceId = c.getSourceId()) && !overlapResults.getElements().contains(sourceId)) {
                this.addValidationIssue(CONNECTION_WITH_ID + c.getId() + HAS_INVALID_SOURCE_ID + sourceId);
            }
        });
    }

    public static List<ProcessGroupSchemaV2> getAllProcessGroups(ProcessGroupSchemaV2 processGroupSchema) {
        ArrayList<ProcessGroupSchemaV2> result = new ArrayList<ProcessGroupSchemaV2>();
        ConfigSchemaV2.addProcessGroups(processGroupSchema, result);
        return result;
    }

    private static void addProcessGroups(ProcessGroupSchemaV2 processGroupSchema, List<ProcessGroupSchemaV2> result) {
        result.add(processGroupSchema);
        processGroupSchema.getProcessGroupSchemas().forEach(p -> ConfigSchemaV2.addProcessGroups(p, result));
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public ConfigSchema convert() {
        Map result = (Map)this.mapSupplier.get();
        result.put(VERSION, this.getVersion());
        ConfigSchemaV2.putIfNotNull(result, "Flow Controller", this.flowControllerProperties);
        ConfigSchemaV2.putIfNotNull(result, "Core Properties", this.coreProperties.convert());
        ConfigSchemaV2.putIfNotNull(result, "FlowFile Repository", this.flowfileRepositoryProperties);
        ConfigSchemaV2.putIfNotNull(result, "Content Repository", this.contentRepositoryProperties);
        ConfigSchemaV2.putIfNotNull(result, "Provenance Repository", this.provenanceRepositorySchema);
        ConfigSchemaV2.putIfNotNull(result, "Component Status Repository", this.componentStatusRepositoryProperties);
        ConfigSchemaV2.putIfNotNull(result, "Security Properties", this.securityProperties);
        result.putAll(this.processGroupSchema.toMap());
        ConfigSchemaV2.putIfNotNull(result, "Provenance Reporting", this.provenanceReportingProperties);
        return new ConfigSchema(result, this.getValidationIssues());
    }
}

