/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.eventhub.utils;

import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;

public final class AzureEventHubUtils {
    public static final String MANAGED_IDENTITY_POLICY = "Managed Identity";
    public static final PropertyDescriptor POLICY_PRIMARY_KEY = new PropertyDescriptor.Builder().name("Shared Access Policy Primary Key").description("The primary key of the shared access policy").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).sensitive(true).required(false).build();
    public static final PropertyDescriptor USE_MANAGED_IDENTITY = new PropertyDescriptor.Builder().name("use-managed-identity").displayName("Use Azure Managed Identity").description("Choose whether or not to use the managed identity of Azure VM/VMSS").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();

    public static List<ValidationResult> customValidate(PropertyDescriptor accessPolicyDescriptor, PropertyDescriptor policyKeyDescriptor, ValidationContext context) {
        ArrayList<ValidationResult> retVal = new ArrayList<ValidationResult>();
        boolean accessPolicyIsSet = context.getProperty(accessPolicyDescriptor).isSet();
        boolean policyKeyIsSet = context.getProperty(policyKeyDescriptor).isSet();
        boolean useManagedIdentity = context.getProperty(USE_MANAGED_IDENTITY).asBoolean();
        if (useManagedIdentity && (accessPolicyIsSet || policyKeyIsSet)) {
            String msg = String.format("('%s') and ('%s' with '%s') fields cannot be set at the same time.", USE_MANAGED_IDENTITY.getDisplayName(), accessPolicyDescriptor.getDisplayName(), POLICY_PRIMARY_KEY.getDisplayName());
            retVal.add(new ValidationResult.Builder().subject("Credentials config").valid(false).explanation(msg).build());
        } else if (!(useManagedIdentity || accessPolicyIsSet && policyKeyIsSet)) {
            String msg = String.format("either('%s') or (%s with '%s') must be set", USE_MANAGED_IDENTITY.getDisplayName(), accessPolicyDescriptor.getDisplayName(), POLICY_PRIMARY_KEY.getDisplayName());
            retVal.add(new ValidationResult.Builder().subject("Credentials config").valid(false).explanation(msg).build());
        }
        return retVal;
    }

    public static String getManagedIdentityConnectionString(String namespace, String eventHubName) {
        return new ConnectionStringBuilder().setNamespaceName(namespace).setEventHubName(eventHubName).setAuthentication(MANAGED_IDENTITY_POLICY).toString();
    }

    public static String getSharedAccessSignatureConnectionString(String namespace, String eventHubName, String sasName, String sasKey) {
        return new ConnectionStringBuilder().setNamespaceName(namespace).setEventHubName(eventHubName).setSasKeyName(sasName).setSasKey(sasKey).toString();
    }
}

