/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.azure.AbstractAzureDataLakeStorageProcessor;
import org.apache.nifi.processors.azure.storage.FetchAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.ListAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.PutAzureDataLakeStorage;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adlsgen2", "datalake"})
@SeeAlso(value={PutAzureDataLakeStorage.class, FetchAzureDataLakeStorage.class, ListAzureDataLakeStorage.class})
@CapabilityDescription(value="Deletes the provided file from Azure Data Lake Storage")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class DeleteAzureDataLakeStorage
extends AbstractAzureDataLakeStorageProcessor {
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        try {
            String fileSystem = DeleteAzureDataLakeStorage.evaluateFileSystemProperty(context, flowFile);
            String directory = DeleteAzureDataLakeStorage.evaluateDirectoryProperty(context, flowFile);
            String fileName = DeleteAzureDataLakeStorage.evaluateFileNameProperty(context, flowFile);
            DataLakeServiceClient storageClient = DeleteAzureDataLakeStorage.getStorageClient((PropertyContext)context, flowFile);
            DataLakeFileSystemClient fileSystemClient = storageClient.getFileSystemClient(fileSystem);
            DataLakeDirectoryClient directoryClient = fileSystemClient.getDirectoryClient(directory);
            DataLakeFileClient fileClient = directoryClient.getFileClient(fileName);
            fileClient.delete();
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().invokeRemoteProcess(flowFile, fileClient.getFileUrl(), "File deleted");
        }
        catch (Exception e) {
            this.getLogger().error("Failed to delete the specified file from Azure Data Lake Storage", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

