/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor;
import org.apache.nifi.processors.azure.storage.DeleteAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.ListAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.PutAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@CapabilityDescription(value="Retrieves contents of an Azure Storage Blob, writing the contents to the content of the FlowFile")
@SeeAlso(value={ListAzureBlobStorage.class, PutAzureBlobStorage.class, DeleteAzureBlobStorage.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="azure.length", description="The length of the blob fetched")})
public class FetchAzureBlobStorage
extends AbstractAzureBlobProcessor {
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String containerName = context.getProperty(AzureStorageUtils.CONTAINER).evaluateAttributeExpressions(flowFile).getValue();
        String blobPath = context.getProperty(BLOB).evaluateAttributeExpressions(flowFile).getValue();
        AtomicReference storedException = new AtomicReference();
        try {
            CloudBlobClient blobClient = AzureStorageUtils.createCloudBlobClient(context, this.getLogger(), flowFile);
            CloudBlobContainer container = blobClient.getContainerReference(containerName);
            OperationContext operationContext = new OperationContext();
            AzureStorageUtils.setProxy(operationContext, context);
            HashMap<String, String> attributes = new HashMap<String, String>();
            CloudBlockBlob blob = container.getBlockBlobReference(blobPath);
            flowFile = session.write(flowFile, arg_0 -> FetchAzureBlobStorage.lambda$onTrigger$0((CloudBlob)blob, operationContext, storedException, arg_0));
            long length = blob.getProperties().getLength();
            attributes.put("azure.length", String.valueOf(length));
            if (!attributes.isEmpty()) {
                flowFile = session.putAllAttributes(flowFile, attributes);
            }
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().fetch(flowFile, blob.getSnapshotQualifiedUri().toString(), transferMillis);
        }
        catch (StorageException | IllegalArgumentException | URISyntaxException | ProcessException e) {
            if (e instanceof ProcessException && storedException.get() == null) {
                throw (ProcessException)e;
            }
            Exception failureException = (Exception)Optional.ofNullable(storedException.get()).orElse(e);
            this.getLogger().error("Failure to fetch Azure blob {}", new Object[]{blobPath}, (Throwable)failureException);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private static /* synthetic */ void lambda$onTrigger$0(CloudBlob blob, OperationContext operationContext, AtomicReference storedException, OutputStream os) throws IOException {
        try {
            blob.download(os, null, null, operationContext);
        }
        catch (StorageException e) {
            storedException.set(e);
            throw new IOException(e);
        }
    }
}

