/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.azure.AbstractAzureDataLakeStorageProcessor;
import org.apache.nifi.processors.azure.storage.DeleteAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.FetchAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.PutAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.utils.ADLSFileInfo;
import org.apache.nifi.serialization.record.RecordSchema;

@PrimaryNodeOnly
@TriggerSerially
@Tags(value={"azure", "microsoft", "cloud", "storage", "adlsgen2", "datalake"})
@SeeAlso(value={PutAzureDataLakeStorage.class, DeleteAzureDataLakeStorage.class, FetchAzureDataLakeStorage.class})
@CapabilityDescription(value="Lists directory in an Azure Data Lake Storage Gen 2 filesystem")
@WritesAttributes(value={@WritesAttribute(attribute="azure.filesystem", description="The name of the Azure File System"), @WritesAttribute(attribute="azure.filePath", description="The full path of the Azure File"), @WritesAttribute(attribute="azure.directory", description="The name of the Azure Directory"), @WritesAttribute(attribute="azure.filename", description="The name of the Azure File"), @WritesAttribute(attribute="azure.length", description="The length of the Azure File"), @WritesAttribute(attribute="azure.lastModified", description="The last modification time of the Azure File"), @WritesAttribute(attribute="azure.etag", description="The ETag of the Azure File")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Stateful(scopes={Scope.CLUSTER}, description="After performing a listing of files, the timestamp of the newest file is stored. This allows the Processor to list only files that have been added or modified after this date the next time that the Processor is run. State is stored across the cluster so that this Processor can be run on Primary Node only and if a new Primary Node is selected, the new node can pick up where the previous node left off, without duplicating the data.")
public class ListAzureDataLakeStorage
extends AbstractListProcessor<ADLSFileInfo> {
    public static final PropertyDescriptor RECURSE_SUBDIRECTORIES = new PropertyDescriptor.Builder().name("recurse-subdirectories").displayName("Recurse Subdirectories").description("Indicates whether to list files from subdirectories of the directory").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor FILE_FILTER = new PropertyDescriptor.Builder().name("file-filter").displayName("File Filter").description("Only files whose names match the given regular expression will be listed").required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_WITH_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor PATH_FILTER = new PropertyDescriptor.Builder().name("path-filter").displayName("Path Filter").description(String.format("When '%s' is true, then only subdirectories whose paths match the given regular expression will be scanned", RECURSE_SUBDIRECTORIES.getDisplayName())).required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_WITH_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(AbstractAzureDataLakeStorageProcessor.ADLS_CREDENTIALS_SERVICE, AbstractAzureDataLakeStorageProcessor.FILESYSTEM, AbstractAzureDataLakeStorageProcessor.DIRECTORY, RECURSE_SUBDIRECTORIES, FILE_FILTER, PATH_FILTER, RECORD_WRITER, LISTING_STRATEGY, ListedEntityTracker.TRACKING_STATE_CACHE, ListedEntityTracker.TRACKING_TIME_WINDOW, ListedEntityTracker.INITIAL_LISTING_TARGET));
    private static final Set<PropertyDescriptor> LISTING_RESET_PROPERTIES = Collections.unmodifiableSet(new HashSet<PropertyDescriptor>(Arrays.asList(AbstractAzureDataLakeStorageProcessor.ADLS_CREDENTIALS_SERVICE, AbstractAzureDataLakeStorageProcessor.FILESYSTEM, AbstractAzureDataLakeStorageProcessor.DIRECTORY, RECURSE_SUBDIRECTORIES, FILE_FILTER, PATH_FILTER, LISTING_STRATEGY)));
    private volatile Pattern filePattern;
    private volatile Pattern pathPattern;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        String fileFilter = context.getProperty(FILE_FILTER).evaluateAttributeExpressions().getValue();
        this.filePattern = fileFilter != null ? Pattern.compile(fileFilter) : null;
        String pathFilter = context.getProperty(PATH_FILTER).evaluateAttributeExpressions().getValue();
        this.pathPattern = pathFilter != null ? Pattern.compile(pathFilter) : null;
    }

    @OnStopped
    public void onStopped() {
        this.filePattern = null;
        this.pathPattern = null;
    }

    protected void customValidate(ValidationContext context, Collection<ValidationResult> results) {
        if (context.getProperty(PATH_FILTER).isSet() && !context.getProperty(RECURSE_SUBDIRECTORIES).asBoolean().booleanValue()) {
            results.add(new ValidationResult.Builder().subject(PATH_FILTER.getDisplayName()).valid(false).explanation(String.format("'%s' cannot be set when '%s' is false", PATH_FILTER.getDisplayName(), RECURSE_SUBDIRECTORIES.getDisplayName())).build());
        }
    }

    protected RecordSchema getRecordSchema() {
        return ADLSFileInfo.getRecordSchema();
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected String getDefaultTimePrecision() {
        return PRECISION_MILLIS.getValue();
    }

    protected boolean isListingResetNecessary(PropertyDescriptor property) {
        return LISTING_RESET_PROPERTIES.contains(property);
    }

    protected String getPath(ProcessContext context) {
        String directory = context.getProperty(AbstractAzureDataLakeStorageProcessor.DIRECTORY).evaluateAttributeExpressions().getValue();
        return directory != null ? directory : ".";
    }

    protected List<ADLSFileInfo> performListing(ProcessContext context, Long minTimestamp) throws IOException {
        try {
            String fileSystem = AbstractAzureDataLakeStorageProcessor.evaluateFileSystemProperty(context, null);
            String baseDirectory = AbstractAzureDataLakeStorageProcessor.evaluateDirectoryProperty(context, null);
            boolean recurseSubdirectories = context.getProperty(RECURSE_SUBDIRECTORIES).asBoolean();
            DataLakeServiceClient storageClient = AbstractAzureDataLakeStorageProcessor.getStorageClient((PropertyContext)context, null);
            DataLakeFileSystemClient fileSystemClient = storageClient.getFileSystemClient(fileSystem);
            ListPathsOptions options = new ListPathsOptions();
            options.setPath(baseDirectory);
            options.setRecursive(recurseSubdirectories);
            Pattern baseDirectoryPattern = Pattern.compile("^" + baseDirectory + "/?");
            List<ADLSFileInfo> listing = fileSystemClient.listPaths(options, null).stream().filter(pathItem -> !pathItem.isDirectory()).map(pathItem -> new ADLSFileInfo.Builder().fileSystem(fileSystem).filePath(pathItem.getName()).length(pathItem.getContentLength()).lastModified(pathItem.getLastModified().toInstant().toEpochMilli()).etag(pathItem.getETag()).build()).filter(fileInfo -> this.filePattern == null || this.filePattern.matcher(fileInfo.getFilename()).matches()).filter(fileInfo -> this.pathPattern == null || this.pathPattern.matcher(RegExUtils.removeFirst((String)fileInfo.getDirectory(), (Pattern)baseDirectoryPattern)).matches()).collect(Collectors.toList());
            return listing;
        }
        catch (Exception e) {
            this.getLogger().error("Failed to list directory on Azure Data Lake Storage", (Throwable)e);
            throw new IOException(ExceptionUtils.getRootCause((Throwable)e));
        }
    }

    protected Map<String, String> createAttributes(ADLSFileInfo fileInfo, ProcessContext context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azure.filesystem", fileInfo.getFileSystem());
        attributes.put("azure.filePath", fileInfo.getFilePath());
        attributes.put("azure.directory", fileInfo.getDirectory());
        attributes.put("azure.filename", fileInfo.getFilename());
        attributes.put("azure.length", String.valueOf(fileInfo.getLength()));
        attributes.put("azure.lastModified", String.valueOf(fileInfo.getLastModified()));
        attributes.put("azure.etag", fileInfo.getEtag());
        return attributes;
    }
}

