/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor;
import org.apache.nifi.processors.azure.storage.DeleteAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.FetchAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.ListAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@SeeAlso(value={ListAzureBlobStorage.class, FetchAzureBlobStorage.class, DeleteAzureBlobStorage.class})
@CapabilityDescription(value="Puts content into an Azure Storage Blob")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="azure.container", description="The name of the Azure container"), @WritesAttribute(attribute="azure.blobname", description="The name of the Azure blob"), @WritesAttribute(attribute="azure.primaryUri", description="Primary location for blob content"), @WritesAttribute(attribute="azure.etag", description="Etag for the Azure blob"), @WritesAttribute(attribute="azure.length", description="Length of the blob"), @WritesAttribute(attribute="azure.timestamp", description="The timestamp in Azure for the blob")})
public class PutAzureBlobStorage
extends AbstractAzureBlobProcessor {
    public static final PropertyDescriptor BLOB_NAME = new PropertyDescriptor.Builder().name("blob").displayName("Blob").description("The filename of the blob").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.remove(BLOB);
        properties.add(BLOB_NAME);
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String containerName = context.getProperty(AzureStorageUtils.CONTAINER).evaluateAttributeExpressions(flowFile).getValue();
        String blobPath = context.getProperty(BLOB_NAME).evaluateAttributeExpressions(flowFile).getValue();
        AtomicReference storedException = new AtomicReference();
        try {
            CloudBlobClient blobClient = AzureStorageUtils.createCloudBlobClient(context, this.getLogger(), flowFile);
            CloudBlobContainer container = blobClient.getContainerReference(containerName);
            container.createIfNotExists();
            CloudBlockBlob blob = container.getBlockBlobReference(blobPath);
            OperationContext operationContext = new OperationContext();
            AzureStorageUtils.setProxy(operationContext, context);
            HashMap attributes = new HashMap();
            long length = flowFile.getSize();
            session.read(flowFile, arg_0 -> PutAzureBlobStorage.lambda$onTrigger$0((CloudBlob)blob, length, operationContext, attributes, containerName, storedException, arg_0));
            if (!attributes.isEmpty()) {
                flowFile = session.putAllAttributes(flowFile, attributes);
            }
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().send(flowFile, blob.getSnapshotQualifiedUri().toString(), transferMillis);
        }
        catch (StorageException | IllegalArgumentException | URISyntaxException | ProcessException e) {
            if (e instanceof ProcessException && storedException.get() == null) {
                throw (ProcessException)e;
            }
            Exception failureException = (Exception)Optional.ofNullable(storedException.get()).orElse(e);
            this.getLogger().error("Failed to put Azure blob {}", new Object[]{blobPath}, (Throwable)failureException);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private static /* synthetic */ void lambda$onTrigger$0(CloudBlob blob, long length, OperationContext operationContext, Map attributes, String containerName, AtomicReference storedException, InputStream rawIn) throws IOException {
        InputStream in = rawIn;
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(rawIn);
        }
        try {
            blob.upload(in, length, null, null, operationContext);
            BlobProperties properties = blob.getProperties();
            attributes.put("azure.container", containerName);
            attributes.put("azure.primaryUri", blob.getSnapshotQualifiedUri().toString());
            attributes.put("azure.etag", properties.getEtag());
            attributes.put("azure.length", String.valueOf(length));
            attributes.put("azure.timestamp", String.valueOf(properties.getLastModified()));
        }
        catch (StorageException | URISyntaxException e) {
            storedException.set(e);
            throw new IOException(e);
        }
    }
}

