/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.azure.AbstractAzureDataLakeStorageProcessor;
import org.apache.nifi.processors.azure.storage.DeleteAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.FetchAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.ListAzureDataLakeStorage;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adlsgen2", "datalake"})
@SeeAlso(value={DeleteAzureDataLakeStorage.class, FetchAzureDataLakeStorage.class, ListAzureDataLakeStorage.class})
@CapabilityDescription(value="Puts content into an Azure Data Lake Storage Gen 2")
@WritesAttributes(value={@WritesAttribute(attribute="azure.filesystem", description="The name of the Azure File System"), @WritesAttribute(attribute="azure.directory", description="The name of the Azure Directory"), @WritesAttribute(attribute="azure.filename", description="The name of the Azure File"), @WritesAttribute(attribute="azure.primaryUri", description="Primary location for file content"), @WritesAttribute(attribute="azure.length", description="The length of the Azure File")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class PutAzureDataLakeStorage
extends AbstractAzureDataLakeStorageProcessor {
    public static final String FAIL_RESOLUTION = "fail";
    public static final String REPLACE_RESOLUTION = "replace";
    public static final String IGNORE_RESOLUTION = "ignore";
    public static final PropertyDescriptor CONFLICT_RESOLUTION = new PropertyDescriptor.Builder().name("conflict-resolution-strategy").displayName("Conflict Resolution Strategy").description("Indicates what should happen when a file with the same name already exists in the output directory").required(true).defaultValue("fail").allowableValues(new String[]{"fail", "replace", "ignore"}).build();
    private List<PropertyDescriptor> properties;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        props.add(CONFLICT_RESOLUTION);
        this.properties = Collections.unmodifiableList(props);
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        block33: {
            FlowFile flowFile = session.get();
            if (flowFile == null) {
                return;
            }
            long startNanos = System.nanoTime();
            try {
                String fileSystem = PutAzureDataLakeStorage.evaluateFileSystemProperty(context, flowFile);
                String directory = PutAzureDataLakeStorage.evaluateDirectoryProperty(context, flowFile);
                String fileName = PutAzureDataLakeStorage.evaluateFileNameProperty(context, flowFile);
                DataLakeServiceClient storageClient = PutAzureDataLakeStorage.getStorageClient((PropertyContext)context, flowFile);
                DataLakeFileSystemClient fileSystemClient = storageClient.getFileSystemClient(fileSystem);
                DataLakeDirectoryClient directoryClient = fileSystemClient.getDirectoryClient(directory);
                String conflictResolution = context.getProperty(CONFLICT_RESOLUTION).getValue();
                boolean overwrite = conflictResolution.equals(REPLACE_RESOLUTION);
                try {
                    DataLakeFileClient fileClient = directoryClient.createFile(fileName, overwrite);
                    long length = flowFile.getSize();
                    if (length > 0L) {
                        try (InputStream rawIn = session.read(flowFile);
                             BufferedInputStream in = new BufferedInputStream(rawIn);){
                            fileClient.append((InputStream)in, 0L, length);
                        }
                    }
                    fileClient.flush(length);
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("azure.filesystem", fileSystem);
                    attributes.put("azure.directory", directory);
                    attributes.put("azure.filename", fileName);
                    attributes.put("azure.primaryUri", fileClient.getFileUrl());
                    attributes.put("azure.length", String.valueOf(length));
                    flowFile = session.putAllAttributes(flowFile, attributes);
                    session.transfer(flowFile, REL_SUCCESS);
                    long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                    session.getProvenanceReporter().send(flowFile, fileClient.getFileUrl(), transferMillis);
                }
                catch (DataLakeStorageException dlsException) {
                    if (dlsException.getStatusCode() == 409) {
                        if (conflictResolution.equals(IGNORE_RESOLUTION)) {
                            session.transfer(flowFile, REL_SUCCESS);
                            String warningMessage = String.format("File with the same name already exists. Remote file not modified. Transferring {} to success due to %s being set to '%s'.", CONFLICT_RESOLUTION.getDisplayName(), conflictResolution);
                            this.getLogger().warn(warningMessage, new Object[]{flowFile});
                            break block33;
                        }
                        throw dlsException;
                    }
                    throw dlsException;
                }
            }
            catch (Exception e) {
                this.getLogger().error("Failed to create file on Azure Data Lake Storage", (Throwable)e);
                flowFile = session.penalize(flowFile);
                session.transfer(flowFile, REL_FAILURE);
            }
        }
    }
}

