/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.queue;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails;

public abstract class AbstractAzureQueueStorage
extends AbstractProcessor {
    public static final PropertyDescriptor QUEUE = new PropertyDescriptor.Builder().name("storage-queue-name").displayName("Queue Name").description("Name of the Azure Storage Queue").required(true).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All successfully processed FlowFiles are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Unsuccessful operations will be transferred to the failure relationship.").build();
    private static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected final CloudQueueClient createCloudQueueClient(ProcessContext context, FlowFile flowFile) throws URISyntaxException {
        AzureStorageCredentialsDetails storageCredentialsDetails = AzureStorageUtils.getStorageCredentialsDetails((PropertyContext)context, flowFile);
        CloudStorageAccount cloudStorageAccount = new CloudStorageAccount(storageCredentialsDetails.getStorageCredentials(), true, storageCredentialsDetails.getStorageSuffix(), storageCredentialsDetails.getStorageAccountName());
        CloudQueueClient cloudQueueClient = cloudStorageAccount.createCloudQueueClient();
        return cloudQueueClient;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        return AzureStorageUtils.validateCredentialProperties(validationContext);
    }
}

