/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService;

public final class AzureStorageUtils {
    public static final String BLOCK = "Block";
    public static final String PAGE = "Page";
    public static final String STORAGE_ACCOUNT_NAME_PROPERTY_DESCRIPTOR_NAME = "storage-account-name";
    public static final String STORAGE_ACCOUNT_KEY_PROPERTY_DESCRIPTOR_NAME = "storage-account-key";
    public static final String STORAGE_SAS_TOKEN_PROPERTY_DESCRIPTOR_NAME = "storage-sas-token";
    public static final String STORAGE_ENDPOINT_SUFFIX_PROPERTY_DESCRIPTOR_NAME = "storage-endpoint-suffix";
    public static final PropertyDescriptor ACCOUNT_KEY = new PropertyDescriptor.Builder().name("storage-account-key").displayName("Storage Account Key").description("The storage account key. This is an admin-like password providing access to every container in this account. It is recommended one uses Shared Access Signature (SAS) token instead for fine-grained control with policies. There are certain risks in allowing the account key to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account key to be fetched dynamically from a flow file attribute, care must be taken to restrict access to the event provenance data (e.g. by strictly controlling the policies governing provenance for this Processor). In addition, the provenance repositories may be put on encrypted disk partitions.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).sensitive(true).build();
    public static final String ACCOUNT_NAME_BASE_DESCRIPTION = "The storage account name.  There are certain risks in allowing the account name to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account name to be fetched dynamically from a flowfile attribute, care must be taken to restrict access to the event provenance data (e.g. by strictly controlling the policies governing provenance for this Processor). In addition, the provenance repositories may be put on encrypted disk partitions.";
    public static final PropertyDescriptor ACCOUNT_NAME = new PropertyDescriptor.Builder().name("storage-account-name").displayName("Storage Account Name").description("The storage account name.  There are certain risks in allowing the account name to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account name to be fetched dynamically from a flowfile attribute, care must be taken to restrict access to the event provenance data (e.g. by strictly controlling the policies governing provenance for this Processor). In addition, the provenance repositories may be put on encrypted disk partitions. Instead of defining the Storage Account Name, Storage Account Key and SAS Token properties directly on the processor, the preferred way is to configure them through a controller service specified in the Storage Credentials property. The controller service can provide a common/shared configuration for multiple/all Azure processors. Furthermore, the credentials can also be looked up dynamically with the 'Lookup' version of the service.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).sensitive(true).build();
    public static final PropertyDescriptor ENDPOINT_SUFFIX = new PropertyDescriptor.Builder().name("storage-endpoint-suffix").displayName("Common Storage Account Endpoint Suffix").description("Storage accounts in public Azure always use a common FQDN suffix. Override this endpoint suffix with a different suffix in certain circumstances (like Azure Stack or non-public Azure regions). The preferred way is to configure them through a controller service specified in the Storage Credentials property. The controller service can provide a common/shared configuration for multiple/all Azure processors. Furthermore, the credentials can also be looked up dynamically with the 'Lookup' version of the service.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).sensitive(false).build();
    public static final PropertyDescriptor CONTAINER = new PropertyDescriptor.Builder().name("container-name").displayName("Container Name").description("Name of the Azure storage container. In case of PutAzureBlobStorage processor, container will be created if it does not exist.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor PROP_SAS_TOKEN = new PropertyDescriptor.Builder().name("storage-sas-token").displayName("SAS Token").description("Shared Access Signature token, including the leading '?'. Specify either SAS Token (recommended) or Account Key. There are certain risks in allowing the SAS token to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account name to be fetched dynamically from a flowfile attribute, care must be taken to restrict access to the event provenance data (e.g. by strictly controlling the policies governing provenance for this Processor). In addition, the provenance repositories may be put on encrypted disk partitions.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor STORAGE_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("storage-credentials-service").displayName("Storage Credentials").description("The Controller Service used to obtain Azure Storage Credentials. Instead of the processor level properties, the credentials can be configured here through a common/shared controller service, which is the preferred way. The 'Lookup' version of the service can also be used to select the credentials dynamically at runtime based on a FlowFile attribute (if the processor has FlowFile input).").identifiesControllerService(AzureStorageCredentialsService.class).required(false).build();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP, ProxySpec.SOCKS};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])PROXY_SPECS);

    private AzureStorageUtils() {
    }

    public static CloudBlobClient createCloudBlobClient(ProcessContext context, ComponentLog logger, FlowFile flowFile) throws URISyntaxException {
        AzureStorageCredentialsDetails storageCredentialsDetails = AzureStorageUtils.getStorageCredentialsDetails((PropertyContext)context, flowFile);
        CloudStorageAccount cloudStorageAccount = new CloudStorageAccount(storageCredentialsDetails.getStorageCredentials(), true, storageCredentialsDetails.getStorageSuffix(), storageCredentialsDetails.getStorageAccountName());
        CloudBlobClient cloudBlobClient = cloudStorageAccount.createCloudBlobClient();
        return cloudBlobClient;
    }

    public static AzureStorageCredentialsDetails getStorageCredentialsDetails(PropertyContext context, FlowFile flowFile) {
        Map attributes = flowFile != null ? flowFile.getAttributes() : Collections.emptyMap();
        AzureStorageCredentialsService storageCredentialsService = (AzureStorageCredentialsService)context.getProperty(STORAGE_CREDENTIALS_SERVICE).asControllerService(AzureStorageCredentialsService.class);
        if (storageCredentialsService != null) {
            return storageCredentialsService.getStorageCredentialsDetails(attributes);
        }
        return AzureStorageUtils.createStorageCredentialsDetails(context, attributes);
    }

    public static AzureStorageCredentialsDetails createStorageCredentialsDetails(PropertyContext context, Map<String, String> attributes) {
        StorageCredentialsAccountAndKey storageCredentials;
        String accountName = context.getProperty(ACCOUNT_NAME).evaluateAttributeExpressions(attributes).getValue();
        String storageSuffix = context.getProperty(ENDPOINT_SUFFIX).evaluateAttributeExpressions(attributes).getValue();
        String accountKey = context.getProperty(ACCOUNT_KEY).evaluateAttributeExpressions(attributes).getValue();
        String sasToken = context.getProperty(PROP_SAS_TOKEN).evaluateAttributeExpressions(attributes).getValue();
        if (StringUtils.isBlank((CharSequence)accountName)) {
            throw new IllegalArgumentException(String.format("'%s' must not be empty.", ACCOUNT_NAME.getDisplayName()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountKey)) {
            storageCredentials = new StorageCredentialsAccountAndKey(accountName, accountKey);
        } else if (StringUtils.isNotBlank((CharSequence)sasToken)) {
            storageCredentials = new StorageCredentialsSharedAccessSignature(sasToken);
        } else {
            throw new IllegalArgumentException(String.format("Either '%s' or '%s' must be defined.", ACCOUNT_KEY.getDisplayName(), PROP_SAS_TOKEN.getDisplayName()));
        }
        return new AzureStorageCredentialsDetails(accountName, storageSuffix, (StorageCredentials)storageCredentials);
    }

    public static Collection<ValidationResult> validateCredentialProperties(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String storageCredentials = validationContext.getProperty(STORAGE_CREDENTIALS_SERVICE).getValue();
        String accountName = validationContext.getProperty(ACCOUNT_NAME).getValue();
        String accountKey = validationContext.getProperty(ACCOUNT_KEY).getValue();
        String sasToken = validationContext.getProperty(PROP_SAS_TOKEN).getValue();
        String endpointSuffix = validationContext.getProperty(ENDPOINT_SUFFIX).getValue();
        if (!(StringUtils.isNotBlank((CharSequence)storageCredentials) && StringUtils.isBlank((CharSequence)accountName) && StringUtils.isBlank((CharSequence)accountKey) && StringUtils.isBlank((CharSequence)sasToken) || StringUtils.isBlank((CharSequence)storageCredentials) && StringUtils.isNotBlank((CharSequence)accountName) && StringUtils.isNotBlank((CharSequence)accountKey) && StringUtils.isBlank((CharSequence)sasToken) || StringUtils.isBlank((CharSequence)storageCredentials) && StringUtils.isNotBlank((CharSequence)accountName) && StringUtils.isBlank((CharSequence)accountKey) && StringUtils.isNotBlank((CharSequence)sasToken))) {
            results.add(new ValidationResult.Builder().subject("AzureStorageUtils Credentials").valid(false).explanation("either " + STORAGE_CREDENTIALS_SERVICE.getDisplayName() + ", or " + ACCOUNT_NAME.getDisplayName() + " with " + ACCOUNT_KEY.getDisplayName() + " or " + ACCOUNT_NAME.getDisplayName() + " with " + PROP_SAS_TOKEN.getDisplayName() + " must be specified").build());
        }
        if (StringUtils.isNotBlank((CharSequence)storageCredentials) && StringUtils.isNotBlank((CharSequence)endpointSuffix)) {
            String errMsg = "Either " + STORAGE_CREDENTIALS_SERVICE.getDisplayName() + " or " + ENDPOINT_SUFFIX.getDisplayName() + " should be specified, not both.";
            results.add(new ValidationResult.Builder().subject("AzureStorageUtils Credentials").explanation(errMsg).build());
        }
        return results;
    }

    public static void validateProxySpec(ValidationContext context, Collection<ValidationResult> results) {
        ProxyConfiguration.validateProxySpec((ValidationContext)context, results, (ProxySpec[])PROXY_SPECS);
    }

    public static void setProxy(OperationContext operationContext, ProcessContext processContext) {
        ProxyConfiguration proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)processContext);
        operationContext.setProxy(proxyConfig.createProxy());
    }
}

