/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.compress;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.decoder.BrotliInputStream;
import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import com.aayushatharva.brotli4j.encoder.Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;
import lzma.streams.LzmaOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.SystemResourceConsiderations;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.compress.property.CompressionStrategy;
import org.apache.nifi.processors.compress.property.FilenameStrategy;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import org.xerial.snappy.SnappyFramedInputStream;
import org.xerial.snappy.SnappyFramedOutputStream;
import org.xerial.snappy.SnappyHadoopCompatibleOutputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"content", "compress", "recompress", "gzip", "bzip2", "lzma", "xz-lzma2", "snappy", "snappy-hadoop", "snappy framed", "lz4-framed", "deflate", "zstd", "brotli"})
@CapabilityDescription(value="Changes the compression algorithm used to compress the contents of a FlowFile by decompressing the contents of FlowFiles using a user-specified compression algorithm and recompressing the contents using the specified compression format properties. This processor operates in a very memory efficient way so very large objects well beyond the heap size are generally fine to process")
@ReadsAttribute(attribute="mime.type", description="If the Decompression Format is set to 'use mime.type attribute', this attribute is used to determine the decompression type. Otherwise, this attribute is ignored.")
@WritesAttribute(attribute="mime.type", description="The appropriate MIME Type is set based on the value of the Compression Format property. If the Compression Format is 'no compression' this attribute is removed as the MIME Type is no longer known.")
@SystemResourceConsiderations(value={@SystemResourceConsideration(resource=SystemResource.CPU), @SystemResourceConsideration(resource=SystemResource.MEMORY)})
public class ModifyCompression
extends AbstractProcessor {
    public static final PropertyDescriptor INPUT_COMPRESSION_STRATEGY = new PropertyDescriptor.Builder().name("Input Compression Strategy").displayName("Input Compression Strategy").description("The strategy to use for decompressing input FlowFiles").allowableValues(EnumSet.complementOf(EnumSet.of(CompressionStrategy.SNAPPY_HADOOP))).defaultValue((DescribedValue)CompressionStrategy.NONE).required(true).build();
    public static final PropertyDescriptor OUTPUT_COMPRESSION_STRATEGY = new PropertyDescriptor.Builder().name("Output Compression Strategy").name("Output Compression Strategy").description("The strategy to use for compressing output FlowFiles").allowableValues(EnumSet.complementOf(EnumSet.of(CompressionStrategy.MIME_TYPE_ATTRIBUTE))).defaultValue((DescribedValue)CompressionStrategy.NONE).required(true).build();
    public static final PropertyDescriptor OUTPUT_COMPRESSION_LEVEL = new PropertyDescriptor.Builder().name("Output Compression Level").displayName("Output Compression Level").description("The compression level for output FlowFiles for supported formats. A lower value results in faster processing but less compression; a value of 0 indicates no (that is, simple archiving) for gzip or minimal for xz-lzma2 compression. Higher levels can mean much larger memory usage such as the case with levels 7-9 for xz-lzma/2 so be careful relative to heap size.").defaultValue("1").required(true).allowableValues(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}).dependsOn(OUTPUT_COMPRESSION_STRATEGY, (DescribedValue)CompressionStrategy.MIME_TYPE_ATTRIBUTE, new DescribedValue[]{CompressionStrategy.GZIP, CompressionStrategy.DEFLATE, CompressionStrategy.XZ_LZMA2, CompressionStrategy.ZSTD, CompressionStrategy.BROTLI}).build();
    public static final PropertyDescriptor OUTPUT_FILENAME_STRATEGY = new PropertyDescriptor.Builder().name("Output Filename Strategy").displayName("Output Filename Strategy").description("Processing strategy for filename attribute on output FlowFiles").required(true).allowableValues(FilenameStrategy.class).defaultValue((DescribedValue)FilenameStrategy.UPDATED).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles will be transferred to the success relationship on compression modification success").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles will be transferred to the failure relationship on compression modification errors").build();
    private static final List<PropertyDescriptor> PROPERTIES = List.of(INPUT_COMPRESSION_STRATEGY, OUTPUT_COMPRESSION_STRATEGY, OUTPUT_COMPRESSION_LEVEL, OUTPUT_FILENAME_STRATEGY);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private static final Map<String, CompressionStrategy> compressionFormatMimeTypeMap;
    private static final int STREAM_BUFFER_SIZE = 65536;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        CompressionStrategy inputCompressionStrategy;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        CompressionStrategy configuredInputCompressionStrategy = (CompressionStrategy)context.getProperty(INPUT_COMPRESSION_STRATEGY).asAllowableValue(CompressionStrategy.class);
        if (CompressionStrategy.MIME_TYPE_ATTRIBUTE == configuredInputCompressionStrategy) {
            String mimeType = flowFile.getAttribute(CoreAttributes.MIME_TYPE.key());
            if (mimeType == null) {
                this.getLogger().error("Required FlowFile Attribute [{}] not found {}", new Object[]{CoreAttributes.MIME_TYPE.key(), flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            inputCompressionStrategy = compressionFormatMimeTypeMap.get(mimeType);
            if (inputCompressionStrategy == null) {
                this.getLogger().info("Compression Strategy not found for MIME Type [{}] {}", new Object[]{mimeType, flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
        } else {
            inputCompressionStrategy = configuredInputCompressionStrategy;
        }
        CompressionStrategy outputCompressionStrategy = (CompressionStrategy)context.getProperty(OUTPUT_COMPRESSION_STRATEGY).asAllowableValue(CompressionStrategy.class);
        AtomicReference<Object> mimeTypeRef = new AtomicReference<Object>(null);
        StopWatch stopWatch = new StopWatch(true);
        long inputFileSize = flowFile.getSize();
        int outputCompressionLevel = context.getProperty(OUTPUT_COMPRESSION_LEVEL).asInteger();
        try {
            flowFile = session.write(flowFile, (flowFileInputStream, flowFileOutputStream) -> {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(flowFileInputStream, 65536);
                     InputStream inputStream = this.getCompressionInputStream(inputCompressionStrategy, bufferedInputStream);
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(flowFileOutputStream, 65536);
                     OutputStream outputStream = this.getCompressionOutputStream(outputCompressionStrategy, outputCompressionLevel, mimeTypeRef, bufferedOutputStream);){
                    StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            });
            stopWatch.stop();
            String outputMimeType = mimeTypeRef.get();
            flowFile = StringUtils.isEmpty((String)outputMimeType) ? session.removeAttribute(flowFile, CoreAttributes.MIME_TYPE.key()) : session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), outputMimeType);
            FilenameStrategy filenameStrategy = FilenameStrategy.valueOf(context.getProperty(OUTPUT_FILENAME_STRATEGY).getValue());
            if (FilenameStrategy.UPDATED == filenameStrategy) {
                String updatedFilename = this.getUpdatedFilename(flowFile, inputCompressionStrategy, outputCompressionStrategy);
                flowFile = session.putAttribute(flowFile, CoreAttributes.FILENAME.key(), updatedFilename);
            }
            this.getLogger().info("Input Compression [{}] Size [{}] Output Compression [{}] Size [{}] Completed {}", new Object[]{inputCompressionStrategy, inputFileSize, outputCompressionStrategy, flowFile.getSize(), flowFile});
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getDuration(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Input Compression [{}] Size [{}] Output Compression [{}] Failed {}", new Object[]{inputCompressionStrategy, inputFileSize, outputCompressionStrategy, flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private InputStream getCompressionInputStream(CompressionStrategy compressionFormat, InputStream parentInputStream) throws IOException {
        InputStream inputStream;
        switch (compressionFormat) {
            case LZMA: {
                LzmaInputStream lzmaInputStream = new LzmaInputStream(parentInputStream, new Decoder());
                inputStream = lzmaInputStream;
                break;
            }
            case XZ_LZMA2: {
                XZInputStream xZInputStream = new XZInputStream(parentInputStream);
                inputStream = xZInputStream;
                break;
            }
            case BZIP2: {
                BZip2CompressorInputStream bZip2CompressorInputStream = new BZip2CompressorInputStream(parentInputStream, true);
                inputStream = bZip2CompressorInputStream;
                break;
            }
            case GZIP: {
                GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream(parentInputStream, true);
                inputStream = gzipCompressorInputStream;
                break;
            }
            case DEFLATE: {
                InflaterInputStream inflaterInputStream = new InflaterInputStream(parentInputStream);
                inputStream = inflaterInputStream;
                break;
            }
            case SNAPPY: {
                SnappyInputStream snappyInputStream = new SnappyInputStream(parentInputStream);
                inputStream = snappyInputStream;
                break;
            }
            case SNAPPY_HADOOP: {
                throw new IOException("Cannot decompress snappy-hadoop");
            }
            case SNAPPY_FRAMED: {
                SnappyFramedInputStream snappyFramedInputStream = new SnappyFramedInputStream(parentInputStream);
                inputStream = snappyFramedInputStream;
                break;
            }
            case LZ4_FRAMED: {
                FramedLZ4CompressorInputStream framedLZ4CompressorInputStream = new FramedLZ4CompressorInputStream(parentInputStream, true);
                inputStream = framedLZ4CompressorInputStream;
                break;
            }
            case ZSTD: {
                ZstdCompressorInputStream zstdCompressorInputStream = new ZstdCompressorInputStream(parentInputStream);
                inputStream = zstdCompressorInputStream;
                break;
            }
            case BROTLI: {
                Brotli4jLoader.ensureAvailability();
                BrotliInputStream brotliInputStream = new BrotliInputStream(parentInputStream);
                inputStream = brotliInputStream;
                break;
            }
            case NONE: {
                InputStream inputStream2;
                inputStream = inputStream2 = parentInputStream;
                break;
            }
            default: {
                String compressorStreamFormat = compressionFormat.getValue().toLowerCase();
                try {
                    CompressorInputStream compressorInputStream = new CompressorStreamFactory().createCompressorInputStream(compressorStreamFormat, parentInputStream);
                    inputStream = compressorInputStream;
                    break;
                }
                catch (CompressorException e) {
                    throw new IOException(String.format("Compressor Stream Format [%s] creation failed", compressorStreamFormat), e);
                }
            }
        }
        return inputStream;
    }

    private OutputStream getCompressionOutputStream(CompressionStrategy compressionFormat, int compressionLevel, AtomicReference<String> mimeTypeRef, OutputStream parentOutputStream) throws IOException {
        OutputStream compressionOut;
        CompressionStrategy compressionStrategy = compressionFormat;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"GZIP", "DEFLATE", "LZMA", "XZ_LZMA2", "SNAPPY", "SNAPPY_HADOOP", "SNAPPY_FRAMED", "LZ4_FRAMED", "ZSTD", "BROTLI", "BZIP2"}, (CompressionStrategy)compressionStrategy, n)) {
            case 0: {
                compressionOut = new GZIPOutputStream(parentOutputStream, compressionLevel);
                mimeTypeRef.set(CompressionStrategy.GZIP.getMimeTypes()[0]);
                break;
            }
            case 1: {
                compressionOut = new DeflaterOutputStream(parentOutputStream, new Deflater(compressionLevel));
                mimeTypeRef.set(CompressionStrategy.GZIP.getMimeTypes()[0]);
                break;
            }
            case 2: {
                compressionOut = new LzmaOutputStream.Builder(parentOutputStream).build();
                mimeTypeRef.set(CompressionStrategy.LZMA.getMimeTypes()[0]);
                break;
            }
            case 3: {
                compressionOut = new XZOutputStream(parentOutputStream, (FilterOptions)new LZMA2Options(compressionLevel));
                mimeTypeRef.set(CompressionStrategy.XZ_LZMA2.getMimeTypes()[0]);
                break;
            }
            case 4: {
                compressionOut = new SnappyOutputStream(parentOutputStream);
                mimeTypeRef.set(CompressionStrategy.SNAPPY.getMimeTypes()[0]);
                break;
            }
            case 5: {
                compressionOut = new SnappyHadoopCompatibleOutputStream(parentOutputStream);
                mimeTypeRef.set(CompressionStrategy.SNAPPY_HADOOP.getMimeTypes()[0]);
                break;
            }
            case 6: {
                compressionOut = new SnappyFramedOutputStream(parentOutputStream);
                mimeTypeRef.set(CompressionStrategy.SNAPPY_FRAMED.getMimeTypes()[0]);
                break;
            }
            case 7: {
                String compressorStreamFormat = compressionFormat.getValue().toLowerCase();
                try {
                    compressionOut = new CompressorStreamFactory().createCompressorOutputStream(compressorStreamFormat, parentOutputStream);
                }
                catch (CompressorException e) {
                    throw new IOException(String.format("Compressor Stream Format [%s] creation failed", compressorStreamFormat), e);
                }
                mimeTypeRef.set(CompressionStrategy.LZ4_FRAMED.getMimeTypes()[0]);
                break;
            }
            case 8: {
                int outputCompressionLevel = compressionLevel * 2;
                compressionOut = new ZstdCompressorOutputStream(parentOutputStream, outputCompressionLevel);
                mimeTypeRef.set(CompressionStrategy.ZSTD.getMimeTypes()[0]);
                break;
            }
            case 9: {
                Brotli4jLoader.ensureAvailability();
                Encoder.Parameters params = new Encoder.Parameters().setQuality(compressionLevel);
                compressionOut = new BrotliOutputStream(parentOutputStream, params);
                mimeTypeRef.set(CompressionStrategy.BROTLI.getMimeTypes()[0]);
                break;
            }
            case 10: {
                String compressorStreamFormat = compressionFormat.getValue().toLowerCase();
                try {
                    compressionOut = new CompressorStreamFactory().createCompressorOutputStream(compressorStreamFormat, parentOutputStream);
                }
                catch (CompressorException e) {
                    throw new IOException(String.format("Compressor Stream Format [%s] creation failed", compressorStreamFormat), e);
                }
                mimeTypeRef.set(CompressionStrategy.BZIP2.getMimeTypes()[0]);
                break;
            }
            default: {
                compressionOut = parentOutputStream;
            }
        }
        return compressionOut;
    }

    private String getUpdatedFilename(FlowFile flowFile, CompressionStrategy inputCompressionStrategy, CompressionStrategy outputCompressionStrategy) {
        String inputFilename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        String inputFileExtension = inputCompressionStrategy.getFileExtension();
        String truncatedFilename = inputFilename.toLowerCase().endsWith(inputFileExtension) ? inputFilename.substring(0, inputFilename.length() - inputFileExtension.length()) : inputFilename;
        return truncatedFilename + outputCompressionStrategy.getFileExtension();
    }

    static {
        HashMap<String, CompressionStrategy> mimeTypeMap = new HashMap<String, CompressionStrategy>();
        for (CompressionStrategy compressionStrategy : CompressionStrategy.values()) {
            String[] mimeTypes = compressionStrategy.getMimeTypes();
            if (mimeTypes == null) continue;
            for (String mimeType : mimeTypes) {
                mimeTypeMap.put(mimeType, compressionStrategy);
            }
        }
        compressionFormatMimeTypeMap = Collections.unmodifiableMap(mimeTypeMap);
    }
}

