/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.NiFiWebContextConfig;
import org.apache.nifi.web.Revision;

@Deprecated
public class HttpServletRequestContextConfig
implements NiFiWebContextConfig {
    public static final String PROCESSOR_ID_PARAM = "processorId";
    public static final String CLIENT_ID_PARAM = "clientId";
    public static final String REVISION_PARAM = "revision";
    private final HttpServletRequest request;

    public HttpServletRequestContextConfig(HttpServletRequest request) {
        this.request = request;
    }

    public String getProxiedEntitiesChain() {
        String xProxiedEntitiesChain = this.request.getHeader("X-ProxiedEntitiesChain");
        X509Certificate cert = this.extractClientCertificate(this.request);
        if (cert != null) {
            String extractedPrincipal = this.extractPrincipal(cert);
            String formattedPrincipal = this.formatProxyDn(extractedPrincipal);
            xProxiedEntitiesChain = xProxiedEntitiesChain == null || xProxiedEntitiesChain.trim().isEmpty() ? formattedPrincipal : xProxiedEntitiesChain + formattedPrincipal;
        }
        return xProxiedEntitiesChain;
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getProcessorId() {
        return this.request.getParameter(PROCESSOR_ID_PARAM);
    }

    public Revision getRevision() {
        Long revision;
        String revisionParamVal = this.request.getParameter(REVISION_PARAM);
        try {
            revision = Long.parseLong(revisionParamVal);
        }
        catch (Exception ex) {
            revision = null;
        }
        String clientId = this.request.getParameter(CLIENT_ID_PARAM);
        return new Revision(revision, clientId);
    }

    private X509Certificate extractClientCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs != null && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    private String extractPrincipal(X509Certificate cert) {
        return cert.getSubjectDN().getName().trim();
    }

    private String formatProxyDn(String dn) {
        return "<" + dn + ">";
    }
}

