/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.db.schemaregistry;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

@Tags(value={"schema", "registry", "database", "table"})
@CapabilityDescription(value="Provides a service for generating a record schema from a database table definition. The service is configured to use a table name and a database connection fetches the table metadata (i.e. table definition) such as column names, data types, nullability, etc.")
public class DatabaseTableSchemaRegistry
extends AbstractControllerService
implements SchemaRegistry {
    private static final Set<SchemaField> schemaFields = EnumSet.of(SchemaField.SCHEMA_NAME);
    static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("Database Connection Pooling Service").displayName("Database Connection Pooling Service").description("The Controller Service that is used to obtain a connection to the database for retrieving table information.").required(true).identifiesControllerService(DBCPService.class).build();
    static final PropertyDescriptor CATALOG_NAME = new PropertyDescriptor.Builder().name("Catalog Name").displayName("Catalog Name").description("The name of the catalog used to locate the desired table. This may not apply for the database that you are querying. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the catalog name must match the database's catalog name exactly.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor SCHEMA_NAME = new PropertyDescriptor.Builder().name("Schema Name").displayName("Schema Name").description("The name of the schema that the table belongs to. This may not apply for the database that you are updating. In this case, leave the field empty. Note that if the property is set and the database is case-sensitive, the schema name must match the database's schema name exactly. Also notice that if the same table name exists in multiple schemas and Schema Name is not specified, the service will find those tables and give an error if the different tables have the same column name(s).").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(DBCP_SERVICE, CATALOG_NAME, SCHEMA_NAME);
    private volatile DBCPService dbcpService;
    private volatile String dbCatalogName;
    private volatile String dbSchemaName;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
        this.dbCatalogName = context.getProperty(CATALOG_NAME).evaluateAttributeExpressions().getValue();
        this.dbSchemaName = context.getProperty(SCHEMA_NAME).evaluateAttributeExpressions().getValue();
    }

    public RecordSchema retrieveSchema(SchemaIdentifier schemaIdentifier) throws IOException, SchemaNotFoundException {
        if (schemaIdentifier.getName().isPresent()) {
            return this.retrieveSchemaByName(schemaIdentifier);
        }
        throw new SchemaNotFoundException("This Schema Registry only supports retrieving a schema by name.");
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return schemaFields;
    }

    RecordSchema retrieveSchemaByName(SchemaIdentifier schemaIdentifier) throws IOException, SchemaNotFoundException {
        RecordSchema recordSchema;
        block9: {
            Optional schemaName = schemaIdentifier.getName();
            if (schemaName.isEmpty()) {
                throw new SchemaNotFoundException("Cannot retrieve schema because Schema Name is not present");
            }
            String tableName = (String)schemaName.get();
            Connection conn = this.dbcpService.getConnection();
            try {
                DatabaseMetaData databaseMetaData = conn.getMetaData();
                recordSchema = this.getRecordSchemaFromMetadata(databaseMetaData, tableName);
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqle) {
                    throw new IOException("Error retrieving schema for table " + (String)schemaName.get(), sqle);
                }
            }
            conn.close();
        }
        return recordSchema;
    }

    private RecordSchema getRecordSchemaFromMetadata(DatabaseMetaData databaseMetaData, String tableName) throws SQLException, SchemaNotFoundException {
        try (ResultSet columnResultSet = databaseMetaData.getColumns(this.dbCatalogName, this.dbSchemaName, tableName, "%");){
            ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
            while (columnResultSet.next()) {
                recordFields.add(this.createRecordFieldFromColumn(columnResultSet));
            }
            if (recordFields.isEmpty()) {
                this.checkTableExists(databaseMetaData, tableName);
            }
            SimpleRecordSchema simpleRecordSchema = new SimpleRecordSchema(recordFields);
            return simpleRecordSchema;
        }
    }

    private RecordField createRecordFieldFromColumn(ResultSet columnResultSet) throws SQLException {
        String defaultValue = columnResultSet.getString("COLUMN_DEF");
        String columnName = columnResultSet.getString("COLUMN_NAME");
        String typeName = columnResultSet.getString("TYPE_NAME");
        int dataType = typeName.equalsIgnoreCase("bool") ? 16 : columnResultSet.getInt("DATA_TYPE");
        String nullableValue = columnResultSet.getString("IS_NULLABLE");
        boolean isNullable = "YES".equalsIgnoreCase(nullableValue) || nullableValue.isEmpty();
        return new RecordField(columnName, DataTypeUtils.getDataTypeFromSQLTypeValue((int)dataType), (Object)defaultValue, isNullable);
    }

    private void checkTableExists(DatabaseMetaData databaseMetaData, String tableName) throws SchemaNotFoundException, SQLException {
        block9: {
            try (ResultSet tablesResultSet = databaseMetaData.getTables(this.dbCatalogName, this.dbSchemaName, tableName, null);){
                ArrayList<String> qualifiedNameSegments = new ArrayList<String>();
                if (this.dbCatalogName != null) {
                    qualifiedNameSegments.add(this.dbCatalogName);
                }
                if (this.dbSchemaName != null) {
                    qualifiedNameSegments.add(this.dbSchemaName);
                }
                qualifiedNameSegments.add(tableName);
                String qualifiedTableName = String.join((CharSequence)".", qualifiedNameSegments);
                if (tablesResultSet.next()) {
                    this.getLogger().warn("No columns found for Table [{}] check permissions for retrieving schema definitions", new Object[]{qualifiedTableName});
                    break block9;
                }
                throw new SchemaNotFoundException(String.format("Table [%s] not found", qualifiedTableName));
            }
        }
    }
}

