/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.map;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.server.AbstractCacheServer;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.map.MapCache;
import org.apache.nifi.distributed.cache.server.map.MapCacheRecord;
import org.apache.nifi.distributed.cache.server.map.MapPutResult;
import org.apache.nifi.distributed.cache.server.map.PersistentMapCache;
import org.apache.nifi.distributed.cache.server.map.SimpleMapCache;
import org.apache.nifi.remote.StandardVersionNegotiator;

public class MapCacheServer
extends AbstractCacheServer {
    private final MapCache cache;

    public MapCacheServer(String identifier, SSLContext sslContext, int port, int maxSize, EvictionPolicy evictionPolicy, File persistencePath, int maxReadSize) throws IOException {
        super(identifier, sslContext, port, maxReadSize);
        SimpleMapCache simpleCache = new SimpleMapCache(identifier, maxSize, evictionPolicy);
        if (persistencePath == null) {
            this.cache = simpleCache;
        } else {
            PersistentMapCache persistentCache = new PersistentMapCache(identifier, persistencePath, simpleCache);
            persistentCache.restore();
            this.cache = persistentCache;
        }
    }

    @Override
    protected StandardVersionNegotiator getVersionNegotiator() {
        return new StandardVersionNegotiator(new int[]{3, 2, 1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean listen(InputStream in, OutputStream out, int version) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        DataOutputStream dos = new DataOutputStream(out);
        String action = dis.readUTF();
        try {
            switch (action) {
                case "close": {
                    boolean bl = false;
                    return bl;
                }
                case "putIfAbsent": {
                    byte[] key = this.readValue(dis);
                    byte[] value = this.readValue(dis);
                    MapPutResult putResult = this.cache.putIfAbsent(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
                    dos.writeBoolean(putResult.isSuccessful());
                    return true;
                }
                case "put": {
                    byte[] key = this.readValue(dis);
                    byte[] value = this.readValue(dis);
                    this.cache.put(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
                    dos.writeBoolean(true);
                    return true;
                }
                case "containsKey": {
                    byte[] key = this.readValue(dis);
                    boolean contains = this.cache.containsKey(ByteBuffer.wrap(key));
                    dos.writeBoolean(contains);
                    return true;
                }
                case "getAndPutIfAbsent": {
                    byte[] key = this.readValue(dis);
                    byte[] value = this.readValue(dis);
                    MapPutResult putResult = this.cache.putIfAbsent(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
                    if (putResult.isSuccessful()) {
                        dos.writeInt(0);
                        return true;
                    } else {
                        byte[] byteArray = putResult.getExisting().getValue().array();
                        dos.writeInt(byteArray.length);
                        dos.write(byteArray);
                        return true;
                    }
                }
                case "get": {
                    byte[] key = this.readValue(dis);
                    ByteBuffer existingValue = this.cache.get(ByteBuffer.wrap(key));
                    if (existingValue == null) {
                        dos.writeInt(0);
                        return true;
                    } else {
                        byte[] byteArray = existingValue.array();
                        dos.writeInt(byteArray.length);
                        dos.write(byteArray);
                        return true;
                    }
                }
                case "subMap": {
                    int numKeys = this.validateSize(dis.readInt());
                    for (int i = 0; i < numKeys; ++i) {
                        byte[] key = this.readValue(dis);
                        ByteBuffer existingValue = this.cache.get(ByteBuffer.wrap(key));
                        if (existingValue == null) {
                            dos.writeInt(0);
                            continue;
                        }
                        byte[] byteArray = existingValue.array();
                        dos.writeInt(byteArray.length);
                        dos.write(byteArray);
                    }
                    return true;
                }
                case "remove": {
                    byte[] key = this.readValue(dis);
                    boolean removed = this.cache.remove(ByteBuffer.wrap(key)) != null;
                    dos.writeBoolean(removed);
                    return true;
                }
                case "removeAndGet": {
                    byte[] key = this.readValue(dis);
                    ByteBuffer removed = this.cache.remove(ByteBuffer.wrap(key));
                    if (removed == null) {
                        dos.writeInt(0);
                        return true;
                    } else {
                        byte[] byteArray = removed.array();
                        dos.writeInt(byteArray.length);
                        dos.write(byteArray);
                        return true;
                    }
                }
                case "removeByPattern": {
                    String pattern = dis.readUTF();
                    Map<ByteBuffer, ByteBuffer> removed = this.cache.removeByPattern(pattern);
                    dos.writeLong(removed == null ? 0L : (long)removed.size());
                    return true;
                }
                case "removeByPatternAndGet": {
                    String pattern = dis.readUTF();
                    Map<ByteBuffer, ByteBuffer> removed = this.cache.removeByPattern(pattern);
                    if (removed == null || removed.size() == 0) {
                        dos.writeLong(0L);
                        return true;
                    } else {
                        dos.writeInt(removed.size());
                        for (Map.Entry<ByteBuffer, ByteBuffer> entry : removed.entrySet()) {
                            byte[] key = entry.getKey().array();
                            dos.writeInt(key.length);
                            dos.write(key);
                            byte[] value = entry.getValue().array();
                            dos.writeInt(value.length);
                            dos.write(value);
                        }
                    }
                    return true;
                }
                case "fetch": {
                    byte[] key = this.readValue(dis);
                    MapCacheRecord existing = this.cache.fetch(ByteBuffer.wrap(key));
                    if (existing == null) {
                        dos.writeLong(-1L);
                        dos.writeInt(0);
                        return true;
                    } else {
                        dos.writeLong(existing.getRevision());
                        byte[] byteArray = existing.getValue().array();
                        dos.writeInt(byteArray.length);
                        dos.write(byteArray);
                        return true;
                    }
                }
                case "replace": {
                    byte[] key = this.readValue(dis);
                    long revision = dis.readLong();
                    byte[] value = this.readValue(dis);
                    MapPutResult result = this.cache.replace(new MapCacheRecord(ByteBuffer.wrap(key), ByteBuffer.wrap(value), revision));
                    dos.writeBoolean(result.isSuccessful());
                    return true;
                }
                case "keySet": {
                    Set<ByteBuffer> result = this.cache.keySet();
                    dos.writeInt(result.size());
                    for (ByteBuffer bb : result) {
                        byte[] byteArray = bb.array();
                        dos.writeInt(byteArray.length);
                        dos.write(byteArray);
                    }
                    return true;
                }
                default: {
                    throw new IOException("Illegal Request");
                }
            }
        }
        finally {
            dos.flush();
        }
    }

    @Override
    public void stop() throws IOException {
        try {
            super.stop();
        }
        finally {
            this.cache.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.stopped) {
            this.stop();
        }
    }
}

