/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.map;

import io.netty.channel.ChannelHandler;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.operations.CacheOperation;
import org.apache.nifi.distributed.cache.operations.MapOperation;
import org.apache.nifi.distributed.cache.protocol.ProtocolVersion;
import org.apache.nifi.distributed.cache.server.EventCacheServer;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.codec.CacheOperationResultEncoder;
import org.apache.nifi.distributed.cache.server.codec.CacheVersionRequestHandler;
import org.apache.nifi.distributed.cache.server.codec.CacheVersionResponseEncoder;
import org.apache.nifi.distributed.cache.server.codec.MapCacheRequestDecoder;
import org.apache.nifi.distributed.cache.server.codec.MapCacheRequestHandler;
import org.apache.nifi.distributed.cache.server.codec.MapRemoveResponseEncoder;
import org.apache.nifi.distributed.cache.server.codec.MapSizeResponseEncoder;
import org.apache.nifi.distributed.cache.server.codec.MapValueResponseEncoder;
import org.apache.nifi.distributed.cache.server.map.MapCache;
import org.apache.nifi.distributed.cache.server.map.PersistentMapCache;
import org.apache.nifi.distributed.cache.server.map.SimpleMapCache;
import org.apache.nifi.event.transport.EventServer;
import org.apache.nifi.event.transport.EventServerFactory;
import org.apache.nifi.event.transport.netty.NettyEventServerFactory;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;

public class StandardMapCacheServer
extends EventCacheServer {
    private final EventServerFactory eventServerFactory;
    private final MapCache cache;

    public StandardMapCacheServer(ComponentLog log, String identifier, SSLContext sslContext, int port, int maxCacheEntries, EvictionPolicy evictionPolicy, File persistencePath, int maxReadLength) throws IOException {
        super(log, port);
        SimpleMapCache simpleCache = new SimpleMapCache(identifier, maxCacheEntries, evictionPolicy);
        if (persistencePath == null) {
            this.cache = simpleCache;
        } else {
            PersistentMapCache persistentCache = new PersistentMapCache(identifier, persistencePath, simpleCache);
            persistentCache.restore();
            this.cache = persistentCache;
        }
        NettyEventServerFactory nettyEventServerFactory = this.createEventServerFactory(identifier, sslContext);
        MapCacheRequestHandler mapCacheRequestHandler = new MapCacheRequestHandler(log, this.cache);
        CacheVersionResponseEncoder cacheVersionResponseEncoder = new CacheVersionResponseEncoder();
        CacheOperationResultEncoder cacheOperationResultEncoder = new CacheOperationResultEncoder();
        MapRemoveResponseEncoder mapRemoveResponseEncoder = new MapRemoveResponseEncoder();
        MapSizeResponseEncoder mapSizeResponseEncoder = new MapSizeResponseEncoder();
        MapValueResponseEncoder mapValueResponseEncoder = new MapValueResponseEncoder();
        VersionNegotiator versionNegotiator = this.createVersionNegotiator();
        nettyEventServerFactory.setHandlerSupplier(() -> Arrays.asList(new ChannelHandler[]{cacheVersionResponseEncoder, cacheOperationResultEncoder, mapRemoveResponseEncoder, mapSizeResponseEncoder, mapValueResponseEncoder, new MapCacheRequestDecoder(log, maxReadLength, (CacheOperation[])MapOperation.values()), mapCacheRequestHandler, new CacheVersionRequestHandler(log, versionNegotiator)}));
        this.eventServerFactory = nettyEventServerFactory;
    }

    @Override
    public void stop() {
        try {
            this.cache.shutdown();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cache Shutdown Failed", e);
        }
        finally {
            super.stop();
        }
    }

    @Override
    protected EventServer createEventServer() {
        return this.eventServerFactory.getEventServer();
    }

    protected VersionNegotiator createVersionNegotiator() {
        return new StandardVersionNegotiator(new int[]{ProtocolVersion.V3.value(), ProtocolVersion.V2.value(), ProtocolVersion.V1.value()});
    }
}

