/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.AbstractElasticsearchProcessor;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class AbstractElasticsearchTransportClientProcessor
extends AbstractElasticsearchProcessor {
    protected static final PropertyDescriptor CLUSTER_NAME = new PropertyDescriptor.Builder().name("Cluster Name").description("Name of the ES cluster (for example, elasticsearch_brew). Defaults to 'elasticsearch'").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("elasticsearch").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected static final PropertyDescriptor HOSTS = new PropertyDescriptor.Builder().name("ElasticSearch Hosts").description("ElasticSearch Hosts, which should be comma separated and colon for hostname/port host1:port,host2:port,....  For example testcluster:9300. This processor uses the Transport Client to connect to hosts. The default transport client port is 9300.").required(true).addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor PROP_SHIELD_LOCATION = new PropertyDescriptor.Builder().name("Shield Plugin Filename").description("Specifies the path to the JAR for the Elasticsearch Shield plugin. If the Elasticsearch cluster has been secured with the Shield plugin, then the Shield plugin JAR must also be available to this processor. Note: Do NOT place the Shield JAR into NiFi's lib/ directory, doing so will prevent the Shield plugin from being loaded.").required(false).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected static final PropertyDescriptor PING_TIMEOUT = new PropertyDescriptor.Builder().name("ElasticSearch Ping Timeout").description("The ping timeout used to determine when a node is unreachable. For example, 5s (5 seconds). If non-local recommended is 30s").required(true).defaultValue("5s").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected static final PropertyDescriptor SAMPLER_INTERVAL = new PropertyDescriptor.Builder().name("Sampler Interval").description("How often to sample / ping the nodes listed and connected. For example, 5s (5 seconds). If non-local recommended is 30s.").required(true).defaultValue("5s").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected AtomicReference<Client> esClient = new AtomicReference();
    protected List<InetSocketAddress> esHosts;
    protected String authToken;

    @Override
    protected void createElasticsearchClient(ProcessContext context) throws ProcessException {
        ComponentLog log = this.getLogger();
        if (this.esClient.get() != null) {
            return;
        }
        log.debug("Creating ElasticSearch Client");
        try {
            String clusterName = context.getProperty(CLUSTER_NAME).evaluateAttributeExpressions().getValue();
            String pingTimeout = context.getProperty(PING_TIMEOUT).evaluateAttributeExpressions().getValue();
            String samplerInterval = context.getProperty(SAMPLER_INTERVAL).evaluateAttributeExpressions().getValue();
            String username = context.getProperty(USERNAME).evaluateAttributeExpressions().getValue();
            String password = context.getProperty(PASSWORD).evaluateAttributeExpressions().getValue();
            SSLContextService sslService = (SSLContextService)context.getProperty(PROP_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
            Settings.Builder settingsBuilder = Settings.settingsBuilder().put("cluster.name", clusterName).put("client.transport.ping_timeout", pingTimeout).put("client.transport.nodes_sampler_interval", samplerInterval);
            String shieldUrl = context.getProperty(PROP_SHIELD_LOCATION).evaluateAttributeExpressions().getValue();
            if (sslService != null) {
                settingsBuilder.put("shield.transport.ssl", "true").put("shield.ssl.keystore.path", sslService.getKeyStoreFile()).put("shield.ssl.keystore.password", sslService.getKeyStorePassword()).put("shield.ssl.truststore.path", sslService.getTrustStoreFile()).put("shield.ssl.truststore.password", sslService.getTrustStorePassword());
            }
            if (!StringUtils.isEmpty((String)username)) {
                StringBuffer shieldUser = new StringBuffer(username);
                if (!StringUtils.isEmpty((String)password)) {
                    shieldUser.append(":");
                    shieldUser.append(password);
                }
                settingsBuilder.put(new Object[]{"shield.user", shieldUser});
            }
            TransportClient transportClient = this.getTransportClient(settingsBuilder, shieldUrl, username, password);
            String hosts = context.getProperty(HOSTS).evaluateAttributeExpressions().getValue();
            this.esHosts = this.getEsHosts(hosts);
            if (this.esHosts != null) {
                for (InetSocketAddress host : this.esHosts) {
                    try {
                        transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(host));
                    }
                    catch (IllegalArgumentException iae) {
                        log.error("Could not add transport address {}", new Object[]{host});
                    }
                }
            }
            this.esClient.set((Client)transportClient);
        }
        catch (Exception e) {
            log.error("Failed to create Elasticsearch client due to {}", new Object[]{e}, (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
    }

    protected TransportClient getTransportClient(Settings.Builder settingsBuilder, String shieldUrl, String username, String password) throws MalformedURLException {
        TransportClient.Builder builder = TransportClient.builder();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (!StringUtils.isBlank((String)shieldUrl)) {
            URLClassLoader shieldClassLoader = new URLClassLoader(new URL[]{new File(shieldUrl).toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(shieldClassLoader);
            try {
                Class<?> shieldPluginClass = Class.forName("org.elasticsearch.shield.ShieldPlugin", true, shieldClassLoader);
                builder = builder.addPlugin(shieldPluginClass);
                if (!StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)password)) {
                    Class<?> usernamePasswordTokenClass = Class.forName("org.elasticsearch.shield.authc.support.UsernamePasswordToken", true, shieldClassLoader);
                    Class<?> securedStringClass = Class.forName("org.elasticsearch.shield.authc.support.SecuredString", true, shieldClassLoader);
                    Constructor<?> securedStringCtor = securedStringClass.getConstructor(char[].class);
                    Object securePasswordString = securedStringCtor.newInstance(new Object[]{password.toCharArray()});
                    Method basicAuthHeaderValue = usernamePasswordTokenClass.getMethod("basicAuthHeaderValue", String.class, securedStringClass);
                    this.authToken = (String)basicAuthHeaderValue.invoke(null, username, securePasswordString);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException shieldLoadException) {
                this.getLogger().debug("Did not detect Elasticsearch Shield plugin, secure connections and/or authorization will not be available");
            }
        } else {
            this.getLogger().debug("No Shield plugin location specified, secure connections and/or authorization will not be available");
        }
        TransportClient transportClient = builder.settings(settingsBuilder.build()).build();
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        return transportClient;
    }

    public void closeClient() {
        if (this.esClient.get() != null) {
            this.getLogger().info("Closing ElasticSearch Client");
            this.esClient.get().close();
            this.esClient.set(null);
        }
    }

    private List<InetSocketAddress> getEsHosts(String hosts) {
        if (hosts == null) {
            return null;
        }
        List<String> esList = Arrays.asList(hosts.split(","));
        ArrayList<InetSocketAddress> esHosts = new ArrayList<InetSocketAddress>();
        for (String item : esList) {
            String[] addresses = item.split(":");
            if (addresses.length != 2) {
                throw new ArrayIndexOutOfBoundsException("Not in host:port format");
            }
            String hostName = addresses[0].trim();
            int port = Integer.parseInt(addresses[1].trim());
            esHosts.add(new InetSocketAddress(hostName, port));
        }
        return esHosts;
    }
}

