/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.h2.database.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Statement;
import org.apache.nifi.h2.database.migration.H2DatabaseMigrator;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.mvstore.MVStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DatabaseUpdater {
    private static final Logger logger = LoggerFactory.getLogger(H2DatabaseUpdater.class);
    public static final String EXPORT_FILE_PREFIX = "export_";
    public static final String EXPORT_FILE_POSTFIX = ".sql";
    public static final String H2_URL_PREFIX = "jdbc:h2:";

    public static void checkAndPerformMigration(String dbPathNoExtension, String dbUrl, String user, String pass) throws Exception {
        JdbcDataSource migrationDataSource = new JdbcDataSource();
        migrationDataSource.setURL(dbUrl);
        migrationDataSource.setUser(user);
        migrationDataSource.setPassword(pass);
        try {
            Connection connection = migrationDataSource.getConnection();
            Throwable throwable = null;
            if (connection != null) {
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    connection.close();
                }
            }
            return;
        }
        catch (SQLNonTransientException e) {
            Throwable exceptionCause = e.getCause();
            if (exceptionCause instanceof MVStoreException) {
                String errorMessage = exceptionCause.getMessage();
                if (!errorMessage.contains("The write format") && !errorMessage.contains("is smaller than the supported format")) {
                    throw e;
                }
            }
            throw e;
        }
        catch (SQLException sqle) {
            throw new RuntimeException(String.format("H2 connection failed URL [%s] File [%s]", dbUrl, dbPathNoExtension), sqle);
        }
        logger.info("H2 1.4 database detected [{}]: starting migration to H2 2.1", (Object)dbPathNoExtension);
        H2DatabaseMigrator.exportAndBackup(dbUrl, dbPathNoExtension, user, pass);
        try (Connection migrationConnection = migrationDataSource.getConnection();
             Statement s = migrationConnection.createStatement();){
            Path dbFilePath = Paths.get(dbPathNoExtension, new String[0]);
            String dbDirectory = dbFilePath.getParent().toFile().getAbsolutePath();
            String exportSqlLocation = dbDirectory + File.separator + EXPORT_FILE_PREFIX + dbFilePath.toFile().getName() + EXPORT_FILE_POSTFIX;
            s.execute("RUNSCRIPT FROM '" + exportSqlLocation + "'");
        }
        catch (SQLException sqle) {
            throw new IOException(String.format("H2 import database creation failed URL [%s]", dbUrl), sqle);
        }
        logger.info("H2 1.4 to 2.1 migration completed [{}]", (Object)dbPathNoExtension);
    }
}

