/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase.put;

import java.util.Collection;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.hbase.put.PutColumn;

public class PutFlowFile {
    private final String tableName;
    private final byte[] row;
    private final Collection<PutColumn> columns;
    private final FlowFile flowFile;

    public PutFlowFile(String tableName, byte[] row, Collection<PutColumn> columns, FlowFile flowFile) {
        this.tableName = tableName;
        this.row = row;
        this.columns = columns;
        this.flowFile = flowFile;
    }

    public String getTableName() {
        return this.tableName;
    }

    public byte[] getRow() {
        return this.row;
    }

    public Collection<PutColumn> getColumns() {
        return this.columns;
    }

    public FlowFile getFlowFile() {
        return this.flowFile;
    }

    public boolean isValid() {
        if (this.tableName == null || this.tableName.trim().isEmpty() || null == this.row || this.flowFile == null || this.columns == null || this.columns.isEmpty()) {
            return false;
        }
        for (PutColumn column : this.columns) {
            if (null != column.getColumnQualifier() && null != column.getColumnFamily() && column.getBuffer() != null) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PutFlowFile) {
            PutFlowFile pff = (PutFlowFile)obj;
            return this.tableName.equals(pff.tableName) && this.row.equals(pff.row) && this.columns.equals(pff.columns) && this.flowFile.equals((Object)pff.flowFile);
        }
        return false;
    }
}

