/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.AbstractHTMLProcessor;
import org.apache.nifi.GetHTMLElement;
import org.apache.nifi.PutHTMLElement;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Tags(value={"modify", "html", "dom", "css", "element"})
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Modifies the value of an existing HTML element. The desired element to be modified is located by using CSS selector syntax. The incoming HTML is first converted into a HTML Document Object Model so that HTML elements may be selected in the similar manner that CSS selectors are used to apply styles to HTML. The resulting HTML DOM is then \"queried\" using the user defined CSS selector string to find the element the user desires to modify. If the HTML element is found the element's value is updated in the DOM using the value specified \"Modified Value\" property. All DOM elements that match the CSS selector will be updated. Once all of the DOM elements have been updated the DOM is rendered to HTML and the result replaces the flowfile content with the updated HTML. A more thorough reference for the CSS selector syntax can be found at \"http://jsoup.org/apidocs/org/jsoup/select/Selector.html\"")
@SeeAlso(value={GetHTMLElement.class, PutHTMLElement.class})
@WritesAttributes(value={@WritesAttribute(attribute="NumElementsModified", description="Total number of HTML element modifications made")})
public class ModifyHTMLElement
extends AbstractHTMLProcessor {
    public static final String NUM_ELEMENTS_MODIFIED_ATTR = "NumElementsModified";
    public static final PropertyDescriptor OUTPUT_TYPE = new PropertyDescriptor.Builder().name("Output Type").description("Controls whether the HTML element is output as HTML,Text or Data").required(true).allowableValues(new String[]{"HTML", "Text", "Attribute"}).defaultValue("HTML").build();
    public static final PropertyDescriptor MODIFIED_VALUE = new PropertyDescriptor.Builder().name("Modified Value").description("Value to update the found HTML elements with").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor ATTRIBUTE_KEY = new PropertyDescriptor.Builder().name("Attribute Name").description("When modifying the value of an element attribute this value is used as the key to determine which attribute on the selected element will be modified with the new value.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(CSS_SELECTOR);
        descriptors.add(HTML_CHARSET);
        descriptors.add(OUTPUT_TYPE);
        descriptors.add(MODIFIED_VALUE);
        descriptors.add(ATTRIBUTE_KEY);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_SUCCESS);
        relationships.add(REL_INVALID_HTML);
        relationships.add(REL_NOT_FOUND);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return URL;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Elements eles;
        Document doc;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            doc = this.parseHTMLDocumentFromFlowfile(flowFile, context, session);
            eles = doc.select(context.getProperty(CSS_SELECTOR).evaluateAttributeExpressions(flowFile).getValue());
        }
        catch (Exception ex) {
            this.getLogger().error("Failed to extract HTML from {} due to {}; routing to {}", new Object[]{flowFile, ex.toString(), REL_INVALID_HTML.getName()}, (Throwable)ex);
            session.transfer(flowFile, REL_INVALID_HTML);
            return;
        }
        String modifiedValue = context.getProperty(MODIFIED_VALUE).evaluateAttributeExpressions(flowFile).getValue();
        if (eles == null || eles.size() == 0) {
            session.transfer(flowFile, REL_NOT_FOUND);
        } else {
            for (Element ele : eles) {
                switch (context.getProperty(OUTPUT_TYPE).getValue()) {
                    case "HTML": {
                        ele.html(modifiedValue);
                        break;
                    }
                    case "Attribute": {
                        ele.attr(context.getProperty(ATTRIBUTE_KEY).evaluateAttributeExpressions(flowFile).getValue(), modifiedValue);
                        break;
                    }
                    case "Text": {
                        ele.text(modifiedValue);
                    }
                }
            }
            FlowFile ff = session.write(session.create(flowFile), new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    out.write(doc.html().getBytes(StandardCharsets.UTF_8));
                }
            });
            ff = session.putAttribute(ff, NUM_ELEMENTS_MODIFIED_ATTR, new Integer(eles.size()).toString());
            session.transfer(ff, REL_SUCCESS);
            session.transfer(flowFile, REL_ORIGINAL);
        }
    }
}

