/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.standard.api.transformjson;

import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.JsonUtils;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.processors.standard.util.jolt.TransformFactory;
import org.apache.nifi.processors.standard.util.jolt.TransformUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.apache.nifi.web.standard.api.AbstractStandardResource;
import org.apache.nifi.web.standard.api.transformjson.dto.JoltSpecificationDTO;
import org.apache.nifi.web.standard.api.transformjson.dto.ValidationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/standard/transformjson")
public class TransformJSONResource
extends AbstractStandardResource {
    private static final Logger logger = LoggerFactory.getLogger(TransformJSONResource.class);
    private static final String DEFAULT_CHARSET = "UTF-8";

    protected Object getSpecificationJsonObject(JoltSpecificationDTO specificationDTO, boolean evaluateAttributes) {
        if (!StringUtils.isEmpty((CharSequence)specificationDTO.getSpecification())) {
            String specification;
            if (evaluateAttributes) {
                PreparedQuery preparedQuery = Query.prepare((String)specificationDTO.getSpecification());
                Map attributes = specificationDTO.getExpressionLanguageAttributes() == null ? Collections.emptyMap() : specificationDTO.getExpressionLanguageAttributes();
                specification = preparedQuery.evaluateExpressions((EvaluationContext)new StandardEvaluationContext(attributes), null);
            } else {
                specification = specificationDTO.getSpecification().replaceAll("\\$\\{", "\\\\\\\\\\$\\{");
            }
            return JsonUtils.jsonToObject((String)specification, (String)DEFAULT_CHARSET);
        }
        return null;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/validate")
    public Response validateSpec(JoltSpecificationDTO specificationDTO) {
        try {
            this.getTransformation(specificationDTO, false);
        }
        catch (Exception e) {
            logger.error("Validation Failed - " + e.toString());
            return Response.ok((Object)new ValidationDTO(Boolean.valueOf(false), "Validation Failed - Please verify the provided specification.")).build();
        }
        return Response.ok((Object)new ValidationDTO(Boolean.valueOf(true), null)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/execute")
    public Response executeSpec(JoltSpecificationDTO specificationDTO) {
        try {
            JoltTransform transform = this.getTransformation(specificationDTO, true);
            Object inputJson = JsonUtils.jsonToObject((String)specificationDTO.getInput());
            return Response.ok((Object)JsonUtils.toJsonString((Object)TransformUtils.transform((JoltTransform)transform, (Object)inputJson))).build();
        }
        catch (Exception e) {
            logger.error("Execute Specification Failed - " + e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    protected JoltTransform getTransformation(JoltSpecificationDTO specificationDTO, boolean evaluateAttributes) throws Exception {
        Object specJson = this.getSpecificationJsonObject(specificationDTO, evaluateAttributes);
        String transformName = specificationDTO.getTransform();
        String modules = specificationDTO.getModules();
        ClassLoader classLoader = null;
        classLoader = modules != null && !modules.isEmpty() ? ClassLoaderUtils.getCustomClassLoader((String)specificationDTO.getModules(), (ClassLoader)this.getClass().getClassLoader(), (FilenameFilter)this.getJarFilenameFilter()) : this.getClass().getClassLoader();
        JoltTransform transform = transformName.equals("jolt-transform-custom") ? TransformFactory.getCustomTransform((ClassLoader)classLoader, (String)specificationDTO.getCustomClass(), (Object)specJson) : TransformFactory.getTransform((ClassLoader)classLoader, (String)specificationDTO.getTransform(), (Object)specJson);
        return transform;
    }

    protected FilenameFilter getJarFilenameFilter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

