/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kite;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.hadoop.HadoopValidators;
import org.apache.nifi.util.StringUtils;
import org.kitesdk.data.SchemaNotFoundException;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.spi.DefaultConfiguration;

abstract class AbstractKiteProcessor
extends AbstractProcessor {
    private static final Splitter COMMA = Splitter.on((char)',').trimResults();
    protected static final PropertyDescriptor CONF_XML_FILES = new PropertyDescriptor.Builder().name("Hadoop configuration files").displayName("Hadoop configuration Resources").description("A file or comma separated list of files which contains the Hadoop file system configuration. Without this, Hadoop will search the classpath for a 'core-site.xml' and 'hdfs-site.xml' file or will revert to a default configuration.").required(false).addValidator(HadoopValidators.ONE_OR_MORE_FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected static final Validator RECOGNIZED_URI = new Validator(){

        public ValidationResult validate(String subject, String uri, ValidationContext context) {
            String message = "not set";
            boolean isValid = true;
            if (uri.trim().isEmpty()) {
                isValid = false;
            } else {
                boolean elPresent;
                boolean bl = elPresent = context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(uri);
                if (!elPresent) {
                    try {
                        new URIBuilder(URI.create(uri)).build();
                    }
                    catch (RuntimeException e) {
                        message = e.getMessage();
                        isValid = false;
                    }
                }
            }
            return new ValidationResult.Builder().subject(subject).input(uri).explanation("Dataset URI is invalid: " + message).valid(isValid).build();
        }
    };
    protected static final Validator SCHEMA_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String uri, ValidationContext context) {
            boolean elPresent;
            Configuration conf = AbstractKiteProcessor.getConfiguration(context.getProperty(CONF_XML_FILES).evaluateAttributeExpressions().getValue());
            String error = null;
            if (StringUtils.isBlank((String)uri)) {
                return new ValidationResult.Builder().subject(subject).input(uri).explanation("Schema cannot be null.").valid(false).build();
            }
            boolean bl = elPresent = context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(uri);
            if (!elPresent) {
                try {
                    AbstractKiteProcessor.getSchema(uri, conf);
                }
                catch (SchemaNotFoundException e) {
                    error = e.getMessage();
                }
            }
            return new ValidationResult.Builder().subject(subject).input(uri).explanation(error).valid(error == null).build();
        }
    };
    protected static final List<PropertyDescriptor> ABSTRACT_KITE_PROPS = ImmutableList.builder().add((Object)CONF_XML_FILES).build();

    AbstractKiteProcessor() {
    }

    /*
     * Exception decompiling
     */
    protected static Schema getSchema(String uriOrLiteral, Configuration conf) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Schema parseSchema(String literal) {
        try {
            return new Schema.Parser().parse(literal);
        }
        catch (RuntimeException e) {
            throw new SchemaNotFoundException("Failed to parse schema: " + literal, (Throwable)e);
        }
    }

    private static Schema parseSchema(URI uri, InputStream in) throws IOException {
        try {
            return new Schema.Parser().parse(in);
        }
        catch (RuntimeException e) {
            throw new SchemaNotFoundException("Failed to parse schema at " + uri, (Throwable)e);
        }
    }

    static List<PropertyDescriptor> getProperties() {
        return ABSTRACT_KITE_PROPS;
    }

    @OnScheduled
    protected void setDefaultConfiguration(ProcessContext context) throws IOException {
        DefaultConfiguration.set((Configuration)AbstractKiteProcessor.getConfiguration(context.getProperty(CONF_XML_FILES).evaluateAttributeExpressions().getValue()));
    }

    protected static Configuration getConfiguration(String configFiles) {
        Configuration conf = DefaultConfiguration.get();
        if (configFiles == null || configFiles.isEmpty()) {
            return conf;
        }
        for (String file : COMMA.split((CharSequence)configFiles)) {
            if (conf.getResource(file) != null) continue;
            conf.addResource(new Path(file));
        }
        return conf;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return ABSTRACT_KITE_PROPS;
    }
}

