/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kite;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.kite.AbstractKiteProcessor;
import org.kitesdk.data.spi.JsonUtil;
import org.kitesdk.data.spi.filesystem.CSVProperties;
import org.kitesdk.data.spi.filesystem.CSVUtil;

@Tags(value={"kite", "avro", "infer", "schema", "csv", "json"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Examines the contents of the incoming FlowFile to infer an Avro schema. The processor will use the Kite SDK to make an attempt to automatically generate an Avro schema from the incoming content. When inferring the schema from JSON data the key names will be used in the resulting Avro schema definition. When inferring from CSV data a \"header definition\" must be present either as the first line of the incoming data or the \"header definition\" must be explicitly set in the property \"CSV Header Definition\". A \"header definition\" is simply a single comma separated line defining the names of each column. The \"header definition\" is required in order to determine the names that should be given to each field in the resulting Avro definition. When inferring data types the higher order data type is always used if there is ambiguity. For example when examining numerical values the type may be set to \"long\" instead of \"integer\" since a long can safely hold the value of any \"integer\". Only CSV and JSON content is currently supported for automatically inferring an Avro schema. The type of content present in the incoming FlowFile is set by using the property \"Input Content Type\". The property can either be explicitly set to CSV, JSON, or \"use mime.type value\" which will examine the value of the mime.type attribute on the incoming FlowFile to determine the type of content present.")
@ReadsAttributes(value={@ReadsAttribute(attribute="mime.type", description="If configured by property \"Input Content Type\" will use this value to determine what sort of content should be inferred from the incoming FlowFile content.")})
@WritesAttributes(value={@WritesAttribute(attribute="inferred.avro.schema", description="If configured by \"Schema output destination\" to write to an attribute this will hold the resulting Avro schema from inferring the incoming FlowFile content.")})
public class InferAvroSchema
extends AbstractKiteProcessor {
    private static final Validator CHAR_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            input = InferAvroSchema.unescapeString(input);
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Only non-null single characters are supported").valid(input.length() == 1 && input.charAt(0) != '\u0000' || context.isExpressionLanguagePresent(input)).build();
        }
    };
    public static final String USE_MIME_TYPE = "use mime.type value";
    public static final String JSON_CONTENT = "json";
    public static final String CSV_CONTENT = "csv";
    public static final String AVRO_SCHEMA_ATTRIBUTE_NAME = "inferred.avro.schema";
    public static final String DESTINATION_ATTRIBUTE = "flowfile-attribute";
    public static final String DESTINATION_CONTENT = "flowfile-content";
    public static final String JSON_MIME_TYPE = "application/json";
    public static final String CSV_MIME_TYPE = "text/csv";
    public static final String AVRO_MIME_TYPE = "application/avro-binary";
    public static final String AVRO_FILE_EXTENSION = ".avro";
    public static final Pattern AVRO_RECORD_NAME_PATTERN = Pattern.compile("[A-Za-z_]+[A-Za-z0-9_.]*[^.]");
    public static final PropertyDescriptor SCHEMA_DESTINATION = new PropertyDescriptor.Builder().name("Schema Output Destination").description("Control if Avro schema is written as a new flowfile attribute 'inferred.avro.schema' or written in the flowfile content. Writing to flowfile content will overwrite any existing flowfile content.").required(true).allowableValues(new String[]{"flowfile-attribute", "flowfile-content"}).defaultValue("flowfile-content").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor INPUT_CONTENT_TYPE = new PropertyDescriptor.Builder().name("Input Content Type").description("Content Type of data present in the incoming FlowFile's content. Only \"json\" or \"csv\" are supported. If this value is set to \"use mime.type value\" the incoming Flowfile's attribute \"" + CoreAttributes.MIME_TYPE + "\" will be used to determine the Content Type.").allowableValues(new String[]{"use mime.type value", "json", "csv"}).defaultValue("use mime.type value").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor GET_CSV_HEADER_DEFINITION_FROM_INPUT = new PropertyDescriptor.Builder().name("Get CSV Header Definition From Data").description("This property only applies to CSV content type. If \"true\" the processor will attempt to read the CSV header definition from the first line of the input data.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor CSV_HEADER_DEFINITION = new PropertyDescriptor.Builder().name("CSV Header Definition").description("This property only applies to CSV content type. Comma separated string defining the column names expected in the CSV data. EX: \"fname,lname,zip,address\". The elements present in this string should be in the same order as the underlying data. Setting this property will cause the value of \"" + GET_CSV_HEADER_DEFINITION_FROM_INPUT.getName() + "\" to be ignored instead using this value.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor HEADER_LINE_SKIP_COUNT = new PropertyDescriptor.Builder().name("CSV Header Line Skip Count").description("This property only applies to CSV content type. Specifies the number of lines that should be skipped when reading the CSV data. Setting this value to 0 is equivalent to saying \"the entire contents of the file should be read\". If the property \"" + GET_CSV_HEADER_DEFINITION_FROM_INPUT.getName() + "\" is set then the first line of the CSV  file will be read in and treated as the CSV header definition. Since this will remove the header line from the data care should be taken to make sure the value of \"CSV header Line Skip Count\" is set to 0 to ensure no data is skipped.").required(true).defaultValue("0").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor DELIMITER = new PropertyDescriptor.Builder().name("CSV delimiter").description("Delimiter character for CSV records").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(CHAR_VALIDATOR).defaultValue(",").build();
    public static final PropertyDescriptor ESCAPE_STRING = new PropertyDescriptor.Builder().name("CSV Escape String").description("This property only applies to CSV content type. String that represents an escape sequence in the CSV FlowFile content data.").required(true).defaultValue("\\").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor QUOTE_STRING = new PropertyDescriptor.Builder().name("CSV Quote String").description("This property only applies to CSV content type. String that represents a literal quote character in the CSV FlowFile content data.").required(true).defaultValue("'").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor RECORD_NAME = new PropertyDescriptor.Builder().name("Avro Record Name").description("Value to be placed in the Avro record schema \"name\" field. The value must adhere to the Avro naming rules for fullname. If Expression Language is present then the evaluated value must adhere to the Avro naming rules.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)AVRO_RECORD_NAME_PATTERN)).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("Charset").description("Character encoding of CSV data.").required(true).defaultValue("UTF-8").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();
    public static final PropertyDescriptor PRETTY_AVRO_OUTPUT = new PropertyDescriptor.Builder().name("Pretty Avro Output").description("If true the Avro output will be formatted.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor NUM_RECORDS_TO_ANALYZE = new PropertyDescriptor.Builder().name("Number Of Records To Analyze").description("This property only applies to JSON content type. The number of JSON records that should be examined to determine the Avro schema. The higher the value the better chance kite has of detecting the appropriate type. However the default value of 10 is almost always enough.").required(true).defaultValue("10").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created Avro schema from data.").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("Original incoming FlowFile data").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Failed to create Avro schema from data.").build();
    public static final Relationship REL_UNSUPPORTED_CONTENT = new Relationship.Builder().name("unsupported content").description("The content found in the flowfile content is not of the required format.").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SCHEMA_DESTINATION);
        properties.add(INPUT_CONTENT_TYPE);
        properties.add(CSV_HEADER_DEFINITION);
        properties.add(GET_CSV_HEADER_DEFINITION_FROM_INPUT);
        properties.add(HEADER_LINE_SKIP_COUNT);
        properties.add(DELIMITER);
        properties.add(ESCAPE_STRING);
        properties.add(QUOTE_STRING);
        properties.add(PRETTY_AVRO_OUTPUT);
        properties.add(RECORD_NAME);
        properties.add(NUM_RECORDS_TO_ANALYZE);
        properties.add(CHARSET);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_UNSUPPORTED_CONTENT);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        try {
            final AtomicReference<String> avroSchema = new AtomicReference<String>();
            switch (context.getProperty(INPUT_CONTENT_TYPE).getValue()) {
                case "use mime.type value": {
                    avroSchema.set(this.inferAvroSchemaFromMimeType(original, context, session));
                    break;
                }
                case "json": {
                    avroSchema.set(this.inferAvroSchemaFromJSON(original, context, session));
                    break;
                }
                case "csv": {
                    avroSchema.set(this.inferAvroSchemaFromCSV(original, context, session));
                    break;
                }
                default: {
                    session.transfer(original, REL_UNSUPPORTED_CONTENT);
                }
            }
            if (StringUtils.isNotEmpty((String)((String)avroSchema.get()))) {
                String destination = context.getProperty(SCHEMA_DESTINATION).getValue();
                FlowFile avroSchemaFF = null;
                switch (destination) {
                    case "flowfile-attribute": {
                        avroSchemaFF = session.putAttribute(session.clone(original), AVRO_SCHEMA_ATTRIBUTE_NAME, (String)avroSchema.get());
                        break;
                    }
                    case "flowfile-content": {
                        avroSchemaFF = session.write(session.create(), new OutputStreamCallback(){

                            public void process(OutputStream out) throws IOException {
                                out.write(((String)avroSchema.get()).getBytes());
                            }
                        });
                        avroSchemaFF = session.putAttribute(avroSchemaFF, CoreAttributes.MIME_TYPE.key(), AVRO_MIME_TYPE);
                        break;
                    }
                }
                avroSchemaFF = session.putAttribute(avroSchemaFF, CoreAttributes.FILENAME.key(), original.getAttribute(CoreAttributes.FILENAME.key()) + AVRO_FILE_EXTENSION);
                session.transfer(avroSchemaFF, REL_SUCCESS);
                session.transfer(original, REL_ORIGINAL);
            } else {
                session.transfer(original, REL_UNSUPPORTED_CONTENT);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Failed to infer Avro schema for {} due to {}", new Object[]{original, ex});
            session.transfer(original, REL_FAILURE);
        }
    }

    private String inferAvroSchemaFromCSV(final FlowFile inputFlowFile, final ProcessContext context, ProcessSession session) {
        final AtomicReference<String> header = new AtomicReference<String>();
        final AtomicReference<Boolean> hasHeader = new AtomicReference<Boolean>();
        if (context.getProperty(GET_CSV_HEADER_DEFINITION_FROM_INPUT).asBoolean() == Boolean.TRUE) {
            session.read(inputFlowFile, new InputStreamCallback(){

                public void process(InputStream in) throws IOException {
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    header.set(br.readLine());
                    hasHeader.set(Boolean.TRUE);
                    br.close();
                }
            });
            hasHeader.set(Boolean.TRUE);
        } else {
            header.set(context.getProperty(CSV_HEADER_DEFINITION).evaluateAttributeExpressions(inputFlowFile).getValue());
            hasHeader.set(Boolean.FALSE);
        }
        final CSVProperties props = new CSVProperties.Builder().charset(context.getProperty(CHARSET).evaluateAttributeExpressions(inputFlowFile).getValue()).delimiter(context.getProperty(DELIMITER).evaluateAttributeExpressions(inputFlowFile).getValue()).quote(context.getProperty(QUOTE_STRING).evaluateAttributeExpressions(inputFlowFile).getValue()).escape(context.getProperty(ESCAPE_STRING).evaluateAttributeExpressions(inputFlowFile).getValue()).linesToSkip(context.getProperty(HEADER_LINE_SKIP_COUNT).evaluateAttributeExpressions(inputFlowFile).asInteger().intValue()).header((String)header.get()).hasHeader(((Boolean)hasHeader.get()).booleanValue()).build();
        final AtomicReference avroSchema = new AtomicReference();
        session.read(inputFlowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                avroSchema.set(CSVUtil.inferSchema((String)context.getProperty(RECORD_NAME).evaluateAttributeExpressions(inputFlowFile).getValue(), (InputStream)in, (CSVProperties)props).toString(context.getProperty(PRETTY_AVRO_OUTPUT).asBoolean().booleanValue()));
            }
        });
        return (String)avroSchema.get();
    }

    private String inferAvroSchemaFromJSON(final FlowFile inputFlowFile, final ProcessContext context, ProcessSession session) {
        final AtomicReference avroSchema = new AtomicReference();
        session.read(inputFlowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                Schema as = JsonUtil.inferSchema((InputStream)in, (String)context.getProperty(RECORD_NAME).evaluateAttributeExpressions(inputFlowFile).getValue(), (int)context.getProperty(NUM_RECORDS_TO_ANALYZE).evaluateAttributeExpressions(inputFlowFile).asInteger());
                avroSchema.set(as.toString(context.getProperty(PRETTY_AVRO_OUTPUT).asBoolean().booleanValue()));
            }
        });
        return (String)avroSchema.get();
    }

    private String inferAvroSchemaFromMimeType(FlowFile inputFlowFile, ProcessContext context, ProcessSession session) {
        String mimeType = inputFlowFile.getAttribute(CoreAttributes.MIME_TYPE.key());
        String avroSchema = "";
        if (mimeType != null) {
            switch (mimeType) {
                case "application/json": {
                    this.getLogger().debug("Inferred content type as JSON from \"{}\" value of \"{}\"", new Object[]{CoreAttributes.MIME_TYPE.key(), inputFlowFile.getAttribute(CoreAttributes.MIME_TYPE.key())});
                    avroSchema = this.inferAvroSchemaFromJSON(inputFlowFile, context, session);
                    break;
                }
                case "text/csv": {
                    this.getLogger().debug("Inferred content type as CSV from \"{}\" value of \"{}\"", new Object[]{CoreAttributes.MIME_TYPE.key(), inputFlowFile.getAttribute(CoreAttributes.MIME_TYPE.key())});
                    avroSchema = this.inferAvroSchemaFromCSV(inputFlowFile, context, session);
                    break;
                }
                default: {
                    this.getLogger().warn("Unable to infer Avro Schema from {} because its mime type is {},  which is not supported by this Processor", new Object[]{inputFlowFile, mimeType});
                }
            }
        }
        return avroSchema;
    }

    private static String unescapeString(String input) {
        if (input.length() > 1) {
            input = StringEscapeUtils.unescapeJava((String)input);
        }
        return input;
    }
}

