/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericData;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.kite.AbstractKiteProcessor;
import org.apache.nifi.processors.kite.AvroUtil;
import org.apache.nifi.util.StopWatch;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.SchemaValidationUtil;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"kite", "avro", "parquet", "hadoop", "hive", "hdfs", "hbase"})
@CapabilityDescription(value="Stores Avro records in a Kite dataset")
public class StoreInKiteDataset
extends AbstractKiteProcessor {
    private static final Relationship SUCCESS = new Relationship.Builder().name("success").description("FlowFile content has been successfully saved").build();
    private static final Relationship INCOMPATIBLE = new Relationship.Builder().name("incompatible").description("FlowFile content is not compatible with the target dataset").build();
    private static final Relationship FAILURE = new Relationship.Builder().name("failure").description("FlowFile content could not be processed").build();
    public static final PropertyDescriptor KITE_DATASET_URI = new PropertyDescriptor.Builder().name("Target dataset URI").description("URI that identifies a Kite dataset where data will be stored").addValidator(RECOGNIZED_URI).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor ADDITIONAL_CLASSPATH_RESOURCES = new PropertyDescriptor.Builder().name("additional-classpath-resources").displayName("Additional Classpath Resources").description("A comma-separated list of paths to files and/or directories that will be added to the classpath. When specifying a directory, all files with in the directory will be added to the classpath, but further sub-directories will not be included.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamicallyModifiesClasspath(true).build();
    private static final List<PropertyDescriptor> PROPERTIES = ImmutableList.builder().addAll(AbstractKiteProcessor.getProperties()).add((Object)KITE_DATASET_URI).add((Object)ADDITIONAL_CLASSPATH_RESOURCES).build();
    private static final Set<Relationship> RELATIONSHIPS = ImmutableSet.builder().add((Object)SUCCESS).add((Object)INCOMPATIBLE).add((Object)FAILURE).build();

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, final ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        final View<GenericData.Record> target = this.load(context, flowFile);
        final Schema schema = target.getDataset().getDescriptor().getSchema();
        try {
            StopWatch timer = new StopWatch(true);
            session.read(flowFile, new InputStreamCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(InputStream in) throws IOException {
                    try (DataFileStream stream = new DataFileStream(in, AvroUtil.newDatumReader(schema, GenericData.Record.class));){
                        IncompatibleSchemaException.check((boolean)SchemaValidationUtil.canRead((Schema)stream.getSchema(), (Schema)schema), (String)"Incompatible file schema %s, expected %s", (Object[])new Object[]{stream.getSchema(), schema});
                        long written = 0L;
                        try (DatasetWriter writer = target.newWriter();){
                            for (GenericData.Record record : stream) {
                                writer.write((Object)record);
                                ++written;
                            }
                        }
                        finally {
                            session.adjustCounter("Stored records", written, true);
                        }
                    }
                }
            });
            timer.stop();
            session.getProvenanceReporter().send(flowFile, target.getUri().toString(), timer.getDuration(TimeUnit.MILLISECONDS), true);
            session.transfer(flowFile, SUCCESS);
        }
        catch (ProcessException | DatasetIOException e) {
            this.getLogger().error("Failed to read FlowFile", e);
            session.transfer(flowFile, FAILURE);
        }
        catch (ValidationException e) {
            this.getLogger().error(e.getMessage());
            this.getLogger().debug("Incompatible schema error", (Throwable)e);
            session.transfer(flowFile, INCOMPATIBLE);
        }
    }

    private View<GenericData.Record> load(ProcessContext context, FlowFile file) {
        String uri = context.getProperty(KITE_DATASET_URI).evaluateAttributeExpressions(file).getValue();
        return Datasets.load((String)uri, GenericData.Record.class);
    }
}

