/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.proxy.ProxySpec;

public class ProxyConfiguration {
    public static final ProxyConfiguration DIRECT_CONFIGURATION = new ProxyConfiguration();
    private Proxy.Type proxyType = Proxy.Type.DIRECT;
    private String proxyServerHost;
    private Integer proxyServerPort;
    private String proxyUserName;
    private String proxyUserPassword;

    public static PropertyDescriptor createProxyConfigPropertyDescriptor(boolean hasComponentProxyConfigs, ProxySpec ... _specs) {
        Set<ProxySpec> specs = ProxyConfiguration.getUniqueProxySpecs(_specs);
        StringBuilder description = new StringBuilder("Specifies the Proxy Configuration Controller Service to proxy network requests.");
        if (hasComponentProxyConfigs) {
            description.append(" If set, it supersedes proxy settings configured per component.");
        }
        description.append(" Supported proxies: ");
        description.append(specs.stream().map(ProxySpec::getDisplayName).collect(Collectors.joining(", ")));
        return new PropertyDescriptor.Builder().fromPropertyDescriptor(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).description(description.toString()).build();
    }

    private static Set<ProxySpec> getUniqueProxySpecs(ProxySpec ... _specs) {
        Set<ProxySpec> specs = Arrays.stream(_specs).sorted().collect(Collectors.toSet());
        if (specs.contains((Object)ProxySpec.HTTP_AUTH)) {
            specs.remove((Object)ProxySpec.HTTP);
        }
        if (specs.contains((Object)ProxySpec.SOCKS_AUTH)) {
            specs.remove((Object)ProxySpec.SOCKS);
        }
        return specs;
    }

    public static void validateProxySpec(ValidationContext context, Collection<ValidationResult> results, ProxySpec ... _specs) {
        Set<ProxySpec> specs = ProxyConfiguration.getUniqueProxySpecs(_specs);
        Set supportedProxyTypes = specs.stream().map(ProxySpec::getProxyType).collect(Collectors.toSet());
        if (!context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).isSet()) {
            return;
        }
        ProxyConfigurationService proxyService = (ProxyConfigurationService)context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
        ProxyConfiguration proxyConfiguration = proxyService.getConfiguration();
        Proxy.Type proxyType = proxyConfiguration.getProxyType();
        if (proxyType.equals((Object)Proxy.Type.DIRECT)) {
            return;
        }
        if (!supportedProxyTypes.contains((Object)proxyType)) {
            results.add(new ValidationResult.Builder().explanation(String.format("Proxy type %s is not supported.", new Object[]{proxyType})).valid(false).subject(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE.getDisplayName()).build());
            return;
        }
        if (proxyConfiguration.hasCredential() && !specs.contains((Object)(Proxy.Type.HTTP.equals((Object)proxyType) ? ProxySpec.HTTP_AUTH : ProxySpec.SOCKS_AUTH))) {
            results.add(new ValidationResult.Builder().explanation(String.format("Proxy type %s with Authentication is not supported.", new Object[]{proxyType})).valid(false).subject(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE.getDisplayName()).build());
        }
    }

    public static ProxyConfiguration getConfiguration(PropertyContext context) {
        return ProxyConfiguration.getConfiguration(context, () -> DIRECT_CONFIGURATION);
    }

    public static ProxyConfiguration getConfiguration(PropertyContext context, Supplier<ProxyConfiguration> perComponentSetting) {
        if (context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).isSet()) {
            ProxyConfigurationService proxyService = (ProxyConfigurationService)context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
            return proxyService.getConfiguration();
        }
        return perComponentSetting.get();
    }

    public Proxy.Type getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(Proxy.Type proxyType) {
        this.proxyType = proxyType;
    }

    public String getProxyServerHost() {
        return this.proxyServerHost;
    }

    public void setProxyServerHost(String proxyServerHost) {
        this.proxyServerHost = proxyServerHost;
    }

    public Integer getProxyServerPort() {
        return this.proxyServerPort;
    }

    public void setProxyServerPort(Integer proxyServerPort) {
        this.proxyServerPort = proxyServerPort;
    }

    public boolean hasCredential() {
        return this.proxyUserName != null && !this.proxyUserName.isEmpty();
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public String getProxyUserPassword() {
        return this.proxyUserPassword;
    }

    public void setProxyUserPassword(String proxyUserPassword) {
        this.proxyUserPassword = proxyUserPassword;
    }

    public Proxy createProxy() {
        return Proxy.Type.DIRECT.equals((Object)this.proxyType) ? Proxy.NO_PROXY : new Proxy(this.proxyType, new InetSocketAddress(this.proxyServerHost, (int)this.proxyServerPort));
    }
}

