/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.LiveSerializedRepositoryRecord;
import org.apache.nifi.controller.repository.QueueProvider;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordSerdeFactory;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.RocksDBMetronome;
import org.apache.nifi.controller.repository.SerializedRepositoryRecord;
import org.apache.nifi.controller.repository.StandardRepositoryRecord;
import org.apache.nifi.controller.repository.StandardRepositoryRecordSerdeFactory;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.apache.nifi.deprecation.log.DeprecationLoggerFactory;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wali.SerDe;
import org.wali.UpdateType;

@Deprecated
public class RocksDBFlowFileRepository
implements FlowFileRepository {
    private static final Logger logger = LoggerFactory.getLogger(RocksDBFlowFileRepository.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(RocksDBFlowFileRepository.class);
    private static final String FLOWFILE_PROPERTY_PREFIX = "nifi.flowfile.repository.";
    private static final String FLOWFILE_REPOSITORY_DIRECTORY_PREFIX = "nifi.flowfile.repository.directory";
    private static final byte[] SWAP_LOCATION_SUFFIX_KEY = "swap.location.sufixes".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SERIALIZATION_ENCODING_KEY = "serial.encoding".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SERIALIZATION_HEADER_KEY = "serial.header".getBytes(StandardCharsets.UTF_8);
    static final byte[] REPOSITORY_VERSION_KEY = "repository.version".getBytes(StandardCharsets.UTF_8);
    static final byte[] VERSION_ONE_BYTES = "1.0".getBytes(StandardCharsets.UTF_8);
    private static final IllegalStateException NO_NEW_FLOWFILES = new IllegalStateException("Repository is not currently accepting new FlowFiles");
    private static final Runtime runtime = Runtime.getRuntime();
    private static final NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private final Map<String, FlowFileQueue> queueMap = new HashMap<String, FlowFileQueue>();
    private final AtomicLong flowFileSequenceGenerator = new AtomicLong(0L);
    private final int deserializationThreads;
    private final int deserializationBufferSize;
    private final long claimCleanupMillis;
    private final ScheduledExecutorService housekeepingExecutor;
    private final AtomicReference<Collection<ResourceClaim>> claimsAwaitingDestruction = new AtomicReference(new ArrayList());
    private final RocksDBMetronome db;
    private ResourceClaimManager claimManager;
    private RepositoryRecordSerdeFactory serdeFactory;
    private SerDe<SerializedRepositoryRecord> serializer;
    private String serializationEncodingName;
    private byte[] serializationHeader;
    private final boolean acceptDataLoss;
    private final boolean enableStallStop;
    private final boolean removeOrphanedFlowFiles;
    private final boolean enableRecoveryMode;
    private final long recoveryModeFlowFileLimit;
    private final AtomicReference<SerDe<SerializedRepositoryRecord>> recordDeserializer = new AtomicReference();
    private final List<byte[]> recordsToRestore = Collections.synchronizedList(new LinkedList());
    private final ReentrantLock stallStopLock = new ReentrantLock();
    private final AtomicLong inMemoryFlowFiles = new AtomicLong(0L);
    volatile boolean stallNewFlowFiles = false;
    volatile boolean stopNewFlowFiles = false;
    private final long stallMillis;
    private final long stallCount;
    private final long stopCount;
    private final double stallPercentage;
    private final double stopPercentage;
    private final Set<String> swapLocationSuffixes = new HashSet<String>();

    public RocksDBFlowFileRepository() {
        this.deserializationThreads = 0;
        this.deserializationBufferSize = 0;
        this.claimCleanupMillis = 0L;
        this.housekeepingExecutor = null;
        this.db = null;
        this.acceptDataLoss = false;
        this.enableStallStop = false;
        this.removeOrphanedFlowFiles = false;
        this.stallMillis = 0L;
        this.stallCount = 0L;
        this.stopCount = 0L;
        this.stallPercentage = 0.0;
        this.stopPercentage = 0.0;
        this.enableRecoveryMode = false;
        this.recoveryModeFlowFileLimit = 0L;
    }

    public RocksDBFlowFileRepository(NiFiProperties niFiProperties) {
        deprecationLogger.warn("{} should be replaced with WriteAheadFlowFileRepository for [{}] in nifi.properties", new Object[]{this.getClass().getSimpleName(), "nifi.flowfile.repository.implementation"});
        this.deserializationThreads = RocksDbProperty.DESERIALIZATION_THREADS.getIntValue(niFiProperties);
        this.deserializationBufferSize = RocksDbProperty.DESERIALIZATION_BUFFER_SIZE.getIntValue(niFiProperties);
        this.claimCleanupMillis = RocksDbProperty.CLAIM_CLEANUP_PERIOD.getTimeValue(niFiProperties, TimeUnit.MILLISECONDS);
        this.housekeepingExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.acceptDataLoss = RocksDbProperty.ACCEPT_DATA_LOSS.getBooleanValue(niFiProperties);
        this.enableStallStop = RocksDbProperty.ENABLE_STALL_STOP.getBooleanValue(niFiProperties);
        this.removeOrphanedFlowFiles = RocksDbProperty.REMOVE_ORPHANED_FLOWFILES.getBooleanValue(niFiProperties);
        if (this.removeOrphanedFlowFiles) {
            logger.warn("The property \"{}\" is currently set to \"true\".  This can potentially lead to data loss, and should only be set if you are absolutely certain it is necessary.  Even then, it should be removed as soon as possible.", (Object)RocksDbProperty.REMOVE_ORPHANED_FLOWFILES.propertyName);
        }
        this.stallMillis = RocksDbProperty.STALL_PERIOD.getTimeValue(niFiProperties, TimeUnit.MILLISECONDS);
        this.stallCount = RocksDbProperty.STALL_FLOWFILE_COUNT.getLongValue(niFiProperties);
        this.stopCount = RocksDbProperty.STOP_FLOWFILE_COUNT.getLongValue(niFiProperties);
        this.stallPercentage = RocksDbProperty.STALL_HEAP_USAGE_PERCENT.getPercentValue(niFiProperties);
        this.stopPercentage = RocksDbProperty.STOP_HEAP_USAGE_PERCENT.getPercentValue(niFiProperties);
        this.enableRecoveryMode = RocksDbProperty.ENABLE_RECOVERY_MODE.getBooleanValue(niFiProperties);
        this.recoveryModeFlowFileLimit = RocksDbProperty.RECOVERY_MODE_FLOWFILE_LIMIT.getLongValue(niFiProperties);
        if (this.enableRecoveryMode) {
            logger.warn("The property \"{}\" is currently set to \"true\" and  \"{}\" is set to  \"{}\".  This means that only {} FlowFiles will be loaded in to memory from the FlowFile repo at a time, allowing for recovery of a system encountering OutOfMemory errors (or similar).  This setting should be reset to \"false\" as soon as recovery is complete.", new Object[]{RocksDbProperty.ENABLE_RECOVERY_MODE.propertyName, RocksDbProperty.RECOVERY_MODE_FLOWFILE_LIMIT.propertyName, this.recoveryModeFlowFileLimit, this.recoveryModeFlowFileLimit});
        }
        this.db = new RocksDBMetronome.Builder().setStatDumpSeconds((int)Math.min(RocksDbProperty.STAT_DUMP_PERIOD.getTimeValue(niFiProperties, TimeUnit.SECONDS), Integer.MAX_VALUE)).setParallelThreads(RocksDbProperty.DB_PARALLEL_THREADS.getIntValue(niFiProperties)).setMaxWriteBufferNumber(RocksDbProperty.MAX_WRITE_BUFFER_NUMBER.getIntValue(niFiProperties)).setMinWriteBufferNumberToMerge(RocksDbProperty.MIN_WRITE_BUFFER_NUMBER_TO_MERGE.getIntValue(niFiProperties)).setWriteBufferSize(RocksDbProperty.WRITE_BUFFER_SIZE.getByteCountValue(niFiProperties)).setDelayedWriteRate(RocksDbProperty.DELAYED_WRITE_RATE.getByteCountValue(niFiProperties)).setLevel0SlowdownWritesTrigger(RocksDbProperty.LEVEL_O_SLOWDOWN_WRITES_TRIGGER.getIntValue(niFiProperties)).setLevel0StopWritesTrigger(RocksDbProperty.LEVEL_O_STOP_WRITES_TRIGGER.getIntValue(niFiProperties)).setMaxBackgroundFlushes(RocksDbProperty.MAX_BACKGROUND_FLUSHES.getIntValue(niFiProperties)).setMaxBackgroundCompactions(RocksDbProperty.MAX_BACKGROUND_COMPACTIONS.getIntValue(niFiProperties)).setSyncMillis(RocksDbProperty.SYNC_PERIOD.getTimeValue(niFiProperties, TimeUnit.MILLISECONDS)).setSyncWarningNanos(RocksDbProperty.SYNC_WARNING_PERIOD.getTimeValue(niFiProperties, TimeUnit.NANOSECONDS)).setStoragePath(RocksDBFlowFileRepository.getFlowFileRepoPath(niFiProperties)).setAdviseRandomOnOpen(false).setCreateMissingColumnFamilies(true).setCreateIfMissing(true).setPeriodicSyncEnabled(!this.acceptDataLoss).build();
    }

    static Path getFlowFileRepoPath(NiFiProperties niFiProperties) {
        for (String propertyName : niFiProperties.getPropertyKeys()) {
            if (!propertyName.startsWith(FLOWFILE_REPOSITORY_DIRECTORY_PREFIX)) continue;
            String dirName = niFiProperties.getProperty(propertyName);
            return Paths.get(dirName, new String[0]);
        }
        return null;
    }

    public String getFileStoreName() {
        try {
            return Files.getFileStore(this.db.getStoragePath()).name();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void initialize(ResourceClaimManager claimManager) throws IOException {
        block58: {
            this.db.initialize();
            this.claimManager = claimManager;
            this.serdeFactory = new StandardRepositoryRecordSerdeFactory(claimManager);
            try {
                byte[] swapLocationSuffixBytes;
                byte[] versionBytes = this.db.getConfiguration(REPOSITORY_VERSION_KEY);
                if (versionBytes == null) {
                    this.db.putConfiguration(REPOSITORY_VERSION_KEY, VERSION_ONE_BYTES);
                } else if (!Arrays.equals(versionBytes, VERSION_ONE_BYTES)) {
                    throw new IllegalStateException("Unknown repository version: " + new String(versionBytes, StandardCharsets.UTF_8));
                }
                byte[] serializationEncodingBytes = this.db.getConfiguration(SERIALIZATION_ENCODING_KEY);
                if (serializationEncodingBytes == null) {
                    this.serializer = this.serdeFactory.createSerDe(null);
                    this.serializationEncodingName = this.serializer.getClass().getName();
                    this.db.putConfiguration(SERIALIZATION_ENCODING_KEY, this.serializationEncodingName.getBytes(StandardCharsets.UTF_8));
                } else {
                    this.serializationEncodingName = new String(serializationEncodingBytes, StandardCharsets.UTF_8);
                    this.serializer = this.serdeFactory.createSerDe(this.serializationEncodingName);
                }
                this.serializationHeader = this.db.getConfiguration(SERIALIZATION_HEADER_KEY);
                if (this.serializationHeader == null) {
                    try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                         DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                        this.serializer.writeHeader(dataOutputStream);
                        this.serializationHeader = byteArrayOutputStream.toByteArray();
                        this.db.putConfiguration(SERIALIZATION_HEADER_KEY, this.serializationHeader);
                    }
                }
                if ((swapLocationSuffixBytes = this.db.getConfiguration(SWAP_LOCATION_SUFFIX_KEY)) == null) break block58;
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(swapLocationSuffixBytes);
                     ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                    Object o = objectInputStream.readObject();
                    if (o instanceof Collection) {
                        ((Collection)o).forEach(obj -> this.swapLocationSuffixes.add(obj.toString()));
                    }
                }
            }
            catch (ClassNotFoundException | RocksDBException e) {
                throw new IOException(e);
            }
        }
        this.housekeepingExecutor.scheduleWithFixedDelay(this::doHousekeeping, 0L, this.claimCleanupMillis, TimeUnit.MILLISECONDS);
        logger.info("Initialized FlowFile Repository at {}", (Object)this.db.getStoragePath());
    }

    public void close() throws IOException {
        if (this.housekeepingExecutor != null) {
            this.housekeepingExecutor.shutdownNow();
        }
        if (this.db != null) {
            this.db.close();
        }
    }

    private void doHousekeeping() {
        try {
            this.doClaimCleanup();
            this.updateStallStop();
            this.doRecovery();
        }
        catch (Throwable t) {
            logger.error("Encountered problem during housekeeping", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClaimCleanup() {
        Collection claimsToDestroy;
        AtomicReference<Collection<ResourceClaim>> atomicReference = this.claimsAwaitingDestruction;
        synchronized (atomicReference) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            claimsToDestroy = this.claimsAwaitingDestruction.getAndSet(new ArrayList());
        }
        if (claimsToDestroy != null) {
            HashSet uniqueClaimsToDestroy = new HashSet(claimsToDestroy);
            try {
                if (!this.acceptDataLoss) {
                    this.db.waitForSync();
                } else {
                    this.db.forceSync();
                }
            }
            catch (InterruptedException | RocksDBException e) {
                AtomicReference<Collection<ResourceClaim>> atomicReference2 = this.claimsAwaitingDestruction;
                synchronized (atomicReference2) {
                    this.claimsAwaitingDestruction.get().addAll(uniqueClaimsToDestroy);
                    return;
                }
            }
            for (ResourceClaim claim : uniqueClaimsToDestroy) {
                this.claimManager.markDestructable(claim);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStallStop() {
        if (!this.enableStallStop) {
            return;
        }
        if (this.stallStopLock.tryLock()) {
            try {
                double maxMemory;
                long inMemoryFlowFiles = this.getInMemoryFlowFiles();
                if (inMemoryFlowFiles >= this.stopCount) {
                    this.stopNewFlowFiles = true;
                    this.stallNewFlowFiles = true;
                    logger.warn("Halting new FlowFiles because maximum FlowFile count ({}) has been exceeded.  Current count: {}", (Object)this.stopCount, (Object)inMemoryFlowFiles);
                    return;
                }
                double freeMemory = runtime.freeMemory();
                double usedPercentage = 1.0 - freeMemory / (maxMemory = (double)runtime.maxMemory());
                if (usedPercentage >= this.stopPercentage) {
                    this.stopNewFlowFiles = true;
                    this.stallNewFlowFiles = true;
                    logger.warn("Halting new FlowFiles because maximum heap usage percentage ({}) has been exceeded.  Current usage: {}", (Object)percentFormat.format(this.stopPercentage), (Object)percentFormat.format(usedPercentage));
                    return;
                }
                if (inMemoryFlowFiles >= this.stallCount) {
                    this.stopNewFlowFiles = false;
                    this.stallNewFlowFiles = true;
                    logger.warn("Stalling new FlowFiles because FlowFile count stall threshold ({}) has been exceeded.  Current count: {}", (Object)this.stallCount, (Object)inMemoryFlowFiles);
                    return;
                }
                if (usedPercentage >= this.stallPercentage) {
                    this.stopNewFlowFiles = false;
                    this.stallNewFlowFiles = true;
                    logger.warn("Stalling new FlowFiles because heap usage percentage threshold ({}) has been exceeded.  Current count: {}", (Object)percentFormat.format(this.stallPercentage), (Object)percentFormat.format(usedPercentage));
                    return;
                }
                if (this.stopNewFlowFiles || this.stallNewFlowFiles) {
                    logger.info("Resuming acceptance of new FlowFiles");
                    this.stopNewFlowFiles = false;
                    this.stallNewFlowFiles = false;
                }
            }
            finally {
                this.stallStopLock.unlock();
            }
        }
    }

    synchronized void doRecovery() {
        if (!this.enableRecoveryMode) {
            return;
        }
        SerDe<SerializedRepositoryRecord> deserializer = this.recordDeserializer.get();
        if (deserializer == null) {
            return;
        }
        if (this.recordsToRestore.isEmpty()) {
            logger.warn("Recovery has been completed.  The property \"{}\" is currently set to \"true\", but should be reset to \"false\" as soon as possible.", (Object)RocksDbProperty.ENABLE_RECOVERY_MODE.propertyName);
            return;
        }
        logger.warn("The property \"{}\" is currently set to \"true\" and \"{}\" is set to \"{}\".  This means that only {} FlowFiles will be loaded into memory from the FlowFile repo at a time, allowing for recovery of a system encountering OutOfMemory errors (or similar).  This setting should be reset to \"false\" as soon as recovery is complete.  There are {} records remaining to be recovered.", new Object[]{RocksDbProperty.ENABLE_RECOVERY_MODE.propertyName, RocksDbProperty.RECOVERY_MODE_FLOWFILE_LIMIT.propertyName, this.recoveryModeFlowFileLimit, this.recoveryModeFlowFileLimit, this.getRecordsToRestoreCount()});
        while (!this.recordsToRestore.isEmpty() && this.inMemoryFlowFiles.get() < this.recoveryModeFlowFileLimit) {
            try {
                byte[] key = this.recordsToRestore.get(0);
                byte[] recordBytes = this.db.get(key);
                if (recordBytes != null) {
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordBytes);
                         DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
                        SerializedRepositoryRecord record = (SerializedRepositoryRecord)deserializer.deserializeRecord(dataInputStream, deserializer.getVersion());
                        FlowFileRecord flowFile = record.getFlowFileRecord();
                        FlowFileQueue queue = this.queueMap.get(record.getQueueIdentifier());
                        if (queue != null) {
                            queue.put(flowFile);
                            this.inMemoryFlowFiles.incrementAndGet();
                        }
                    }
                }
                this.recordsToRestore.remove(0);
            }
            catch (IOException | RocksDBException e) {
                logger.warn("Encountered exception during recovery", e);
            }
        }
    }

    long getInMemoryFlowFiles() {
        return this.inMemoryFlowFiles.get();
    }

    long getRecordsToRestoreCount() {
        return this.recordsToRestore.size();
    }

    public void updateRepository(Collection<RepositoryRecord> records) throws IOException {
        boolean causeIncrease;
        int netIncrease = this.countAndValidateRecords(records);
        boolean bl = causeIncrease = netIncrease > 0;
        if (causeIncrease && this.stopNewFlowFiles) {
            this.updateStallStop();
            throw NO_NEW_FLOWFILES;
        }
        int syncCounterValue = this.updateRocksDB(records);
        this.inMemoryFlowFiles.addAndGet(netIncrease);
        try {
            if (causeIncrease && (this.stallNewFlowFiles || this.stopNewFlowFiles)) {
                Thread.sleep(this.stallMillis);
                this.updateStallStop();
            }
            if (!this.acceptDataLoss && syncCounterValue > 0) {
                this.db.waitForSync(syncCounterValue);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        this.determineDestructibleClaims(records);
    }

    private int countAndValidateRecords(Collection<RepositoryRecord> records) {
        int inMemoryDelta = 0;
        for (RepositoryRecord record : records) {
            this.validateRecord(record);
            if (record.getType() == RepositoryRecordType.CREATE || record.getType() == RepositoryRecordType.SWAP_IN) {
                ++inMemoryDelta;
                continue;
            }
            if (record.getType() != RepositoryRecordType.DELETE && record.getType() != RepositoryRecordType.SWAP_OUT) continue;
            --inMemoryDelta;
        }
        return inMemoryDelta;
    }

    private void validateRecord(RepositoryRecord record) {
        if (record.getType() != RepositoryRecordType.DELETE && record.getType() != RepositoryRecordType.CONTENTMISSING && record.getType() != RepositoryRecordType.CLEANUP_TRANSIENT_CLAIMS && record.getType() != RepositoryRecordType.SWAP_OUT && record.getDestination() == null) {
            throw new IllegalArgumentException("Record " + record + " has no destination and Type is " + record.getType());
        }
    }

    private int updateRocksDB(Collection<RepositoryRecord> records) throws IOException {
        int counterValue;
        HashMap<UpdateType, List<RepositoryRecord>> partitionedRecords = new HashMap<UpdateType, List<RepositoryRecord>>();
        for (RepositoryRecord repositoryRecord : records) {
            if (repositoryRecord.getType() == RepositoryRecordType.CLEANUP_TRANSIENT_CLAIMS) continue;
            UpdateType updateType = this.serdeFactory.getUpdateType((Object)new LiveSerializedRepositoryRecord(repositoryRecord));
            partitionedRecords.computeIfAbsent(updateType, ut -> new ArrayList()).add(repositoryRecord);
        }
        try {
            List swapInRecords;
            this.putAll((List)partitionedRecords.get(UpdateType.CREATE));
            List swapOutRecords = (List)partitionedRecords.get(UpdateType.SWAP_OUT);
            if (swapOutRecords != null) {
                for (RepositoryRecord record : swapOutRecords) {
                    LiveSerializedRepositoryRecord serializedRecord = new LiveSerializedRepositoryRecord(record);
                    String newLocation = this.serdeFactory.getLocation((Object)serializedRecord);
                    Long recordIdentifier = this.serdeFactory.getRecordIdentifier((SerializedRepositoryRecord)serializedRecord);
                    if (newLocation == null) {
                        logger.error("Received Record (ID=" + recordIdentifier + ") with UpdateType of SWAP_OUT but no indicator of where the Record is to be Swapped Out to; these records may be lost when the repository is restored!");
                        continue;
                    }
                    this.delete(recordIdentifier);
                }
            }
            if ((swapInRecords = (List)partitionedRecords.get(UpdateType.SWAP_IN)) != null) {
                for (RepositoryRecord record : swapInRecords) {
                    LiveSerializedRepositoryRecord serialized = new LiveSerializedRepositoryRecord(record);
                    String newLocation = this.serdeFactory.getLocation((Object)serialized);
                    if (newLocation == null) {
                        Long recordIdentifier = this.serdeFactory.getRecordIdentifier((SerializedRepositoryRecord)serialized);
                        logger.error("Received Record (ID=" + recordIdentifier + ") with UpdateType of SWAP_IN but no indicator of where the Record is to be Swapped In from; these records may be duplicated when the repository is restored!");
                    }
                    this.put(record);
                }
            }
            counterValue = this.syncRequired(partitionedRecords) ? this.db.getSyncCounterValue() : -1;
            this.putAll((List)partitionedRecords.get(UpdateType.UPDATE));
            this.deleteAll((List)partitionedRecords.get(UpdateType.DELETE));
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
        return counterValue;
    }

    private boolean syncRequired(Map<UpdateType, List<RepositoryRecord>> recordMap) {
        for (UpdateType updateType : recordMap.keySet()) {
            if (updateType != UpdateType.CREATE && updateType != UpdateType.SWAP_OUT && updateType != UpdateType.SWAP_IN) continue;
            return true;
        }
        return false;
    }

    private void deleteAll(List<RepositoryRecord> repositoryRecords) throws RocksDBException {
        if (repositoryRecords != null) {
            for (RepositoryRecord record : repositoryRecords) {
                LiveSerializedRepositoryRecord serialized = new LiveSerializedRepositoryRecord(record);
                Long id = this.serdeFactory.getRecordIdentifier((SerializedRepositoryRecord)serialized);
                this.delete(id);
            }
        }
    }

    private void delete(Long recordId) throws RocksDBException {
        byte[] key = RocksDBMetronome.getBytes(recordId);
        this.db.delete(key);
    }

    private void putAll(List<RepositoryRecord> repositoryRecords) throws IOException, RocksDBException {
        if (repositoryRecords != null) {
            for (RepositoryRecord record : repositoryRecords) {
                this.put(record);
            }
        }
    }

    private void put(RepositoryRecord record) throws IOException, RocksDBException {
        Long recordIdentifier = this.serdeFactory.getRecordIdentifier((SerializedRepositoryRecord)new LiveSerializedRepositoryRecord(record));
        byte[] key = RocksDBMetronome.getBytes(recordIdentifier);
        byte[] serializedRecord = this.serialize(record);
        this.db.put(key, serializedRecord);
    }

    /*
     * Exception decompiling
     */
    private byte[] serialize(RepositoryRecord record) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineDestructibleClaims(Collection<RepositoryRecord> records) throws IOException {
        AtomicReference<Collection<ResourceClaim>> atomicReference;
        HashSet<ResourceClaim> claimsToAdd = new HashSet<ResourceClaim>();
        HashSet<String> swapLocationsAdded = new HashSet<String>();
        HashSet<String> swapLocationsRemoved = new HashSet<String>();
        for (RepositoryRecord record : records) {
            List transientClaims;
            String normalizedSwapLocation;
            String swapLocation;
            this.updateClaimCounts(record);
            if (record.getType() == RepositoryRecordType.DELETE) {
                if (this.isDestructible(record.getCurrentClaim())) {
                    claimsToAdd.add(record.getCurrentClaim().getResourceClaim());
                }
                if (this.shouldDestroyOriginal(record)) {
                    claimsToAdd.add(record.getOriginalClaim().getResourceClaim());
                }
            } else if (record.getType() == RepositoryRecordType.UPDATE) {
                if (this.shouldDestroyOriginal(record)) {
                    claimsToAdd.add(record.getOriginalClaim().getResourceClaim());
                }
            } else if (record.getType() == RepositoryRecordType.SWAP_OUT) {
                swapLocation = record.getSwapLocation();
                normalizedSwapLocation = RocksDBFlowFileRepository.normalizeSwapLocation(swapLocation);
                swapLocationsAdded.add(normalizedSwapLocation);
                swapLocationsRemoved.remove(normalizedSwapLocation);
            } else if (record.getType() == RepositoryRecordType.SWAP_IN) {
                swapLocation = record.getSwapLocation();
                normalizedSwapLocation = RocksDBFlowFileRepository.normalizeSwapLocation(swapLocation);
                swapLocationsRemoved.add(normalizedSwapLocation);
                swapLocationsAdded.remove(normalizedSwapLocation);
            }
            if ((transientClaims = record.getTransientClaims()) == null) continue;
            for (ContentClaim transientClaim : transientClaims) {
                if (!this.isDestructible(transientClaim)) continue;
                claimsToAdd.add(transientClaim.getResourceClaim());
            }
        }
        if (!swapLocationsAdded.isEmpty() || !swapLocationsRemoved.isEmpty()) {
            atomicReference = this.swapLocationSuffixes;
            synchronized (atomicReference) {
                this.removeNormalizedSwapLocations(swapLocationsRemoved);
                this.addNormalizedSwapLocations(swapLocationsAdded);
            }
        }
        if (!claimsToAdd.isEmpty()) {
            atomicReference = this.claimsAwaitingDestruction;
            synchronized (atomicReference) {
                this.claimsAwaitingDestruction.get().addAll(claimsToAdd);
            }
        }
    }

    private void updateClaimCounts(RepositoryRecord record) {
        ContentClaim originalClaim;
        boolean claimChanged;
        ContentClaim currentClaim = record.getCurrentClaim();
        boolean bl = claimChanged = !Objects.equals(currentClaim, originalClaim = record.getOriginalClaim());
        if (record.getType() == RepositoryRecordType.DELETE || record.getType() == RepositoryRecordType.CONTENTMISSING) {
            this.decrementClaimCount(currentClaim);
        }
        if (claimChanged) {
            this.decrementClaimCount(originalClaim);
        }
    }

    private void decrementClaimCount(ContentClaim claim) {
        if (claim == null) {
            return;
        }
        this.claimManager.decrementClaimantCount(claim.getResourceClaim());
    }

    private boolean isDestructible(ContentClaim claim) {
        if (claim == null) {
            return false;
        }
        ResourceClaim resourceClaim = claim.getResourceClaim();
        if (resourceClaim == null) {
            return false;
        }
        return !resourceClaim.isInUse();
    }

    private boolean shouldDestroyOriginal(RepositoryRecord record) {
        ContentClaim originalClaim = record.getOriginalClaim();
        return this.isDestructible(originalClaim) && !originalClaim.equals(record.getCurrentClaim());
    }

    public boolean isVolatile() {
        return false;
    }

    public long getStorageCapacity() throws IOException {
        return this.db.getStorageCapacity();
    }

    public long getUsableStorageSpace() throws IOException {
        return this.db.getUsableStorageSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSwapLocationSuffix(String swapLocationSuffix) {
        String normalizedSwapLocation = RocksDBFlowFileRepository.normalizeSwapLocation(swapLocationSuffix);
        Set<String> set = this.swapLocationSuffixes;
        synchronized (set) {
            return this.swapLocationSuffixes.contains(normalizedSwapLocation);
        }
    }

    static String normalizeSwapLocation(String swapLocation) {
        if (swapLocation == null) {
            return null;
        }
        String normalizedPath = swapLocation.replace("\\", "/");
        String withoutTrailing = normalizedPath.endsWith("/") && normalizedPath.length() > 1 ? normalizedPath.substring(0, normalizedPath.length() - 1) : normalizedPath;
        String pathRemoved = RocksDBFlowFileRepository.getLocationSuffix(withoutTrailing);
        return StringUtils.substringBefore((String)pathRemoved, (String)".");
    }

    private static String getLocationSuffix(String swapLocation) {
        int lastIndex = swapLocation.lastIndexOf("/");
        if (lastIndex < 0 || lastIndex >= swapLocation.length() - 1) {
            return swapLocation;
        }
        return swapLocation.substring(lastIndex + 1);
    }

    public void swapFlowFilesOut(List<FlowFileRecord> swappedOut, FlowFileQueue queue, String swapLocation) throws IOException {
        ArrayList<RepositoryRecord> repoRecords = new ArrayList<RepositoryRecord>();
        if (swappedOut == null || swappedOut.isEmpty()) {
            return;
        }
        for (FlowFileRecord swapRecord : swappedOut) {
            StandardRepositoryRecord repoRecord = new StandardRepositoryRecord(queue, swapRecord, swapLocation);
            repoRecords.add((RepositoryRecord)repoRecord);
        }
        this.updateRepository(repoRecords);
        this.addRawSwapLocation(swapLocation);
        logger.info("Successfully swapped out {} FlowFiles from {} to Swap File {}", new Object[]{swappedOut.size(), queue, swapLocation});
    }

    public void swapFlowFilesIn(String swapLocation, List<FlowFileRecord> swapRecords, FlowFileQueue queue) throws IOException {
        ArrayList<RepositoryRecord> repoRecords = new ArrayList<RepositoryRecord>();
        for (FlowFileRecord swapRecord : swapRecords) {
            StandardRepositoryRecord repoRecord = new StandardRepositoryRecord(queue, swapRecord);
            repoRecord.setSwapLocation(swapLocation);
            repoRecord.setDestination(queue);
            repoRecords.add((RepositoryRecord)repoRecord);
        }
        this.updateRepository(repoRecords);
        this.removeRawSwapLocation(swapLocation);
        logger.info("Repository updated to reflect that {} FlowFiles were swapped in to {}", (Object)swapRecords.size(), (Object)queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long loadFlowFiles(QueueProvider queueProvider) throws IOException {
        long startTime = System.nanoTime();
        this.queueMap.clear();
        for (FlowFileQueue queue : queueProvider.getAllQueues()) {
            this.queueMap.put(queue.getIdentifier(), queue);
        }
        ExecutorService recordDeserializationExecutor = Executors.newFixedThreadPool(this.deserializationThreads, r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        ArrayBlockingQueue<byte[]> recordBytesQueue = new ArrayBlockingQueue<byte[]>(this.deserializationBufferSize);
        AtomicBoolean doneReading = new AtomicBoolean(false);
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>(this.deserializationThreads);
        StandardRepositoryRecordSerdeFactory factory = new StandardRepositoryRecordSerdeFactory(this.claimManager);
        AtomicInteger numFlowFilesMissingQueue = new AtomicInteger(0);
        AtomicInteger recordCount = new AtomicInteger(0);
        AtomicInteger recoveryModeRecordCount = new AtomicInteger(0);
        for (int i = 0; i < this.deserializationThreads; ++i) {
            futures.add(recordDeserializationExecutor.submit(() -> this.lambda$loadFlowFiles$4((RepositoryRecordSerdeFactory)factory, doneReading, recordBytesQueue, numFlowFilesMissingQueue, recoveryModeRecordCount, recordCount)));
        }
        long maxId = 0L;
        RocksIterator rocksIterator = this.db.getIterator();
        rocksIterator.seekToFirst();
        long counter = 0L;
        long totalRecords = 0L;
        try {
            while (rocksIterator.isValid()) {
                if (recordBytesQueue.offer(rocksIterator.value(), 10L, TimeUnit.SECONDS)) {
                    rocksIterator.next();
                    if (++counter != 5000L) continue;
                    totalRecords += counter;
                    counter = 0L;
                    logger.info("Read {} records from disk", (Object)totalRecords);
                    continue;
                }
                for (Future future : futures) {
                    if (!future.isDone()) continue;
                    future.get();
                }
                logger.warn("Failed to add record bytes to queue.  Will keep trying...");
            }
            doneReading.set(true);
            logger.info("Finished reading from rocksDB.  Read {} records from disk", (Object)(totalRecords += counter));
            for (Future future : futures) {
                long futureMax = (Long)future.get();
                if (futureMax <= maxId) continue;
                maxId = futureMax;
            }
            logger.info("Finished deserializing {} records", (Object)recordCount.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        finally {
            recordDeserializationExecutor.shutdownNow();
        }
        this.flowFileSequenceGenerator.set(maxId + 1L);
        int flowFilesInQueues = recordCount.get() - numFlowFilesMissingQueue.get();
        this.inMemoryFlowFiles.set(!this.enableRecoveryMode ? (long)flowFilesInQueues : Math.min((long)flowFilesInQueues, this.recoveryModeFlowFileLimit));
        logger.info("Successfully restored {} FlowFiles in {} milliseconds using {} threads", new Object[]{this.getInMemoryFlowFiles(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), this.deserializationThreads});
        if (logger.isDebugEnabled()) {
            Set<String> set = this.swapLocationSuffixes;
            synchronized (set) {
                logger.debug("Recovered {} Swap Files: {}", (Object)this.swapLocationSuffixes.size(), this.swapLocationSuffixes);
            }
        }
        if (numFlowFilesMissingQueue.get() > 0) {
            logger.warn("On recovery, found {} FlowFiles whose queue no longer exists.  These FlowFiles have been dropped.", (Object)numFlowFilesMissingQueue);
        }
        SerDe serDe = factory.createSerDe(this.serializationEncodingName);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.serializationHeader);
             DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
            serDe.readHeader(dataInputStream);
        }
        if (this.enableRecoveryMode) {
            this.recordDeserializer.set((SerDe<SerializedRepositoryRecord>)serDe);
        }
        return maxId;
    }

    public Set<String> findQueuesWithFlowFiles(FlowFileSwapManager flowFileSwapManager) throws IOException {
        return null;
    }

    private void addRawSwapLocation(String rawSwapLocation) throws IOException {
        this.addRawSwapLocations(Collections.singleton(rawSwapLocation));
    }

    private void addRawSwapLocations(Collection<String> rawSwapLocations) throws IOException {
        this.addNormalizedSwapLocations(rawSwapLocations.stream().map(RocksDBFlowFileRepository::normalizeSwapLocation).collect(Collectors.toSet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNormalizedSwapLocations(Collection<String> normalizedSwapLocations) throws IOException {
        Set<String> set = this.swapLocationSuffixes;
        synchronized (set) {
            this.swapLocationSuffixes.addAll(normalizedSwapLocations);
            this.persistSwapLocationSuffixes();
        }
    }

    private void removeRawSwapLocation(String rawSwapLocation) throws IOException {
        this.removeRawSwapLocations(Collections.singleton(rawSwapLocation));
    }

    private void removeRawSwapLocations(Collection<String> rawSwapLocations) throws IOException {
        this.removeNormalizedSwapLocations(rawSwapLocations.stream().map(RocksDBFlowFileRepository::normalizeSwapLocation).collect(Collectors.toSet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNormalizedSwapLocations(Collection<String> normalizedSwapLocations) throws IOException {
        Set<String> set = this.swapLocationSuffixes;
        synchronized (set) {
            this.swapLocationSuffixes.removeAll(normalizedSwapLocations);
            this.persistSwapLocationSuffixes();
        }
    }

    private void persistSwapLocationSuffixes() throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(this.swapLocationSuffixes);
            this.db.putConfiguration(SWAP_LOCATION_SUFFIX_KEY, byteArrayOutputStream.toByteArray());
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    public void updateMaxFlowFileIdentifier(long maxId) {
        long currentId;
        boolean updated;
        do {
            if ((currentId = this.flowFileSequenceGenerator.get()) < maxId) continue;
            return;
        } while (!(updated = this.flowFileSequenceGenerator.compareAndSet(currentId, maxId)));
    }

    public long getNextFlowFileSequence() {
        return this.flowFileSequenceGenerator.getAndIncrement();
    }

    public long getMaxFlowFileIdentifier() {
        return this.flowFileSequenceGenerator.get() - 1L;
    }

    private /* synthetic */ Long lambda$loadFlowFiles$4(RepositoryRecordSerdeFactory factory, AtomicBoolean doneReading, BlockingQueue recordBytesQueue, AtomicInteger numFlowFilesMissingQueue, AtomicInteger recoveryModeRecordCount, AtomicInteger recordCount) throws Exception {
        long localMaxId = 0L;
        int localRecordCount = 0;
        HashSet<String> localRecoveredSwapLocations = new HashSet<String>();
        SerDe localDeserializer = factory.createSerDe(this.serializationEncodingName);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.serializationHeader);
             DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
            localDeserializer.readHeader(dataInputStream);
        }
        while (!doneReading.get() || !recordBytesQueue.isEmpty()) {
            byte[] value = (byte[])recordBytesQueue.poll(100L, TimeUnit.MILLISECONDS);
            if (value == null) continue;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(value);
            Throwable throwable = null;
            try {
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                Throwable throwable2 = null;
                try {
                    byte[] key;
                    Long recordIdentifier;
                    long recordId;
                    SerializedRepositoryRecord record = (SerializedRepositoryRecord)localDeserializer.deserializeRecord(dataInputStream, localDeserializer.getVersion());
                    ++localRecordCount;
                    ContentClaim claim = record.getContentClaim();
                    if (claim != null) {
                        this.claimManager.incrementClaimantCount(claim.getResourceClaim());
                    }
                    if ((recordId = record.getFlowFileRecord().getId()) > localMaxId) {
                        localMaxId = recordId;
                    }
                    if (record.getType().equals((Object)RepositoryRecordType.SWAP_OUT)) {
                        localRecoveredSwapLocations.add(RocksDBFlowFileRepository.normalizeSwapLocation(record.getSwapLocation()));
                    }
                    FlowFileRecord flowFile = record.getFlowFileRecord();
                    FlowFileQueue queue = this.queueMap.get(record.getQueueIdentifier());
                    if (queue == null) {
                        if (!this.removeOrphanedFlowFiles) {
                            throw new IOException("Found FlowFile in repository without a corresponding queue.  This may indicate an issue syncing the flow.xml in a cluster.  To resolve this issue you should restore the flow.xml.  Alternatively, if removing data is acceptable, you can add the following to nifi.properties: \n\n\t\t" + RocksDbProperty.REMOVE_ORPHANED_FLOWFILES.propertyName + "=true\n\n...once this has allowed you to restart nifi, you should remove it from nifi.properties to prevent inadvertent future data loss.");
                        }
                        numFlowFilesMissingQueue.incrementAndGet();
                        try {
                            recordIdentifier = factory.getRecordIdentifier(record);
                            key = RocksDBMetronome.getBytes(recordIdentifier);
                            this.db.delete(key);
                        }
                        catch (RocksDBException e) {
                            logger.warn("Could not clean up repository", (Throwable)e);
                        }
                        continue;
                    }
                    if (!this.enableRecoveryMode) {
                        queue.put(flowFile);
                        continue;
                    }
                    if ((long)recoveryModeRecordCount.incrementAndGet() <= this.recoveryModeFlowFileLimit) {
                        queue.put(flowFile);
                        continue;
                    }
                    recordIdentifier = factory.getRecordIdentifier(record);
                    key = RocksDBMetronome.getBytes(recordIdentifier);
                    this.recordsToRestore.add(key);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (dataInputStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    dataInputStream.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (byteArrayInputStream == null) continue;
                if (throwable != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                byteArrayInputStream.close();
            }
        }
        recordCount.addAndGet(localRecordCount);
        this.addNormalizedSwapLocations(localRecoveredSwapLocations);
        return localMaxId;
    }

    static enum RocksDbProperty {
        SYNC_WARNING_PERIOD("rocksdb.sync.warning.period", "30 seconds"),
        CLAIM_CLEANUP_PERIOD("rocksdb.claim.cleanup.period", "30 seconds"),
        DESERIALIZATION_THREADS("rocksdb.deserialization.threads", "16"),
        DESERIALIZATION_BUFFER_SIZE("rocksdb.deserialization.buffer.size", "1000"),
        SYNC_PERIOD("rocksdb.sync.period", "10 milliseconds"),
        ACCEPT_DATA_LOSS("rocksdb.accept.data.loss", "false"),
        ENABLE_STALL_STOP("rocksdb.enable.stall.stop", "false"),
        STALL_PERIOD("rocksdb.stall.period", "100 milliseconds"),
        STALL_FLOWFILE_COUNT("rocksdb.stall.flowfile.count", "800000"),
        STALL_HEAP_USAGE_PERCENT("rocksdb.stall.heap.usage.percent", "95%"),
        STOP_FLOWFILE_COUNT("rocksdb.stop.flowfile.count", "1100000"),
        STOP_HEAP_USAGE_PERCENT("rocksdb.stop.heap.usage.percent", "99.9%"),
        REMOVE_ORPHANED_FLOWFILES("rocksdb.remove.orphaned.flowfiles.on.startup", "false"),
        ENABLE_RECOVERY_MODE("rocksdb.enable.recovery.mode", "false"),
        RECOVERY_MODE_FLOWFILE_LIMIT("rocksdb.recovery.mode.flowfile.count", "5000"),
        DB_PARALLEL_THREADS("rocksdb.parallel.threads", "8"),
        MAX_WRITE_BUFFER_NUMBER("rocksdb.max.write.buffer.number", "4"),
        WRITE_BUFFER_SIZE("rocksdb.write.buffer.size", "256 MB"),
        LEVEL_O_SLOWDOWN_WRITES_TRIGGER("rocksdb.level.0.slowdown.writes.trigger", "20"),
        LEVEL_O_STOP_WRITES_TRIGGER("rocksdb.level.0.stop.writes.trigger", "40"),
        DELAYED_WRITE_RATE("rocksdb.delayed.write.bytes.per.second", "16 MB"),
        MAX_BACKGROUND_FLUSHES("rocksdb.max.background.flushes", "1"),
        MAX_BACKGROUND_COMPACTIONS("rocksdb.max.background.compactions", "1"),
        MIN_WRITE_BUFFER_NUMBER_TO_MERGE("rocksdb.min.write.buffer.number.to.merge", "1"),
        STAT_DUMP_PERIOD("rocksdb.stat.dump.period", "600 sec");

        final String propertyName;
        final String defaultValue;

        private RocksDbProperty(String propertyName, String defaultValue) {
            this.propertyName = RocksDBFlowFileRepository.FLOWFILE_PROPERTY_PREFIX + propertyName;
            this.defaultValue = defaultValue;
        }

        long getTimeValue(NiFiProperties niFiProperties, TimeUnit timeUnit) {
            String propertyValue = niFiProperties.getProperty(this.propertyName, this.defaultValue);
            long timeValue = 0L;
            try {
                timeValue = Math.round(FormatUtils.getPreciseTimeDuration((String)propertyValue, (TimeUnit)timeUnit));
            }
            catch (IllegalArgumentException e) {
                this.generateIllegalArgumentException(propertyValue, e);
            }
            return timeValue;
        }

        boolean getBooleanValue(NiFiProperties niFiProperties) {
            String propertyValue = niFiProperties.getProperty(this.propertyName, this.defaultValue);
            return Boolean.parseBoolean(propertyValue);
        }

        int getIntValue(NiFiProperties niFiProperties) {
            String propertyValue = niFiProperties.getProperty(this.propertyName, this.defaultValue);
            int returnValue = 0;
            try {
                returnValue = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException e) {
                this.generateIllegalArgumentException(propertyValue, e);
            }
            return returnValue;
        }

        long getByteCountValue(NiFiProperties niFiProperties) {
            long returnValue = 0L;
            String propertyValue = niFiProperties.getProperty(this.propertyName, this.defaultValue);
            try {
                double writeBufferDouble = DataUnit.parseDataSize((String)propertyValue, (DataUnit)DataUnit.B);
                returnValue = (long)(writeBufferDouble < 9.223372036854776E18 ? writeBufferDouble : 9.223372036854776E18);
            }
            catch (IllegalArgumentException e) {
                this.generateIllegalArgumentException(propertyValue, e);
            }
            return returnValue;
        }

        double getPercentValue(NiFiProperties niFiProperties) {
            String propertyValue = niFiProperties.getProperty(this.propertyName, this.defaultValue).replace('%', ' ');
            double returnValue = 0.0;
            try {
                returnValue = Double.parseDouble(propertyValue) / 100.0;
                if (returnValue > 1.0) {
                    this.generateIllegalArgumentException(propertyValue, null);
                }
            }
            catch (NumberFormatException e) {
                this.generateIllegalArgumentException(propertyValue, e);
            }
            return returnValue;
        }

        long getLongValue(NiFiProperties niFiProperties) {
            String propertyValue = niFiProperties.getProperty(this.propertyName, this.defaultValue);
            long returnValue = 0L;
            try {
                returnValue = Long.parseLong(propertyValue);
            }
            catch (NumberFormatException e) {
                this.generateIllegalArgumentException(propertyValue, e);
            }
            return returnValue;
        }

        void generateIllegalArgumentException(String badValue, Throwable t) {
            throw new IllegalArgumentException("The NiFi Property: [" + this.propertyName + "] with value: [" + badValue + "] is not valid", t);
        }
    }
}

