/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.util.StringUtils;
import org.rocksdb.AccessHint;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RocksDBMetronome
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(RocksDBMetronome.class);
    static final String CONFIGURATION_FAMILY = "configuration.column.family";
    static final String DEFAULT_FAMILY = "default";
    private final AtomicLong lastSyncWarningNanos = new AtomicLong(0L);
    private final int parallelThreads;
    private final int maxWriteBufferNumber;
    private final int minWriteBufferNumberToMerge;
    private final long writeBufferSize;
    private final long maxTotalWalSize;
    private final long delayedWriteRate;
    private final int level0SlowdownWritesTrigger;
    private final int level0StopWritesTrigger;
    private final int maxBackgroundFlushes;
    private final int maxBackgroundCompactions;
    private final int statDumpSeconds;
    private final long syncMillis;
    private final long syncWarningNanos;
    private final Path storagePath;
    private final boolean adviseRandomOnOpen;
    private final boolean createIfMissing;
    private final boolean createMissingColumnFamilies;
    private final boolean useFsync;
    private final Set<byte[]> columnFamilyNames;
    private final Map<String, ColumnFamilyHandle> columnFamilyHandles;
    private final boolean periodicSyncEnabled;
    private final ScheduledExecutorService syncExecutor;
    private final ReentrantLock syncLock = new ReentrantLock();
    private final Condition syncCondition = this.syncLock.newCondition();
    private final AtomicInteger syncCounter = new AtomicInteger(0);
    private volatile RocksDB rocksDB = null;
    private final ReentrantReadWriteLock dbReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock dbReadLock = this.dbReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock dbWriteLock = this.dbReadWriteLock.writeLock();
    private volatile boolean closed = false;
    private ColumnFamilyHandle configurationColumnFamilyHandle;
    private ColumnFamilyHandle defaultColumnFamilyHandle;
    private WriteOptions forceSyncWriteOptions;
    private WriteOptions noSyncWriteOptions;

    private RocksDBMetronome(Builder builder) {
        this.statDumpSeconds = builder.statDumpSeconds;
        this.parallelThreads = builder.parallelThreads;
        this.maxWriteBufferNumber = builder.maxWriteBufferNumber;
        this.minWriteBufferNumberToMerge = builder.minWriteBufferNumberToMerge;
        this.writeBufferSize = builder.writeBufferSize;
        this.maxTotalWalSize = builder.getMaxTotalWalSize();
        this.delayedWriteRate = builder.delayedWriteRate;
        this.level0SlowdownWritesTrigger = builder.level0SlowdownWritesTrigger;
        this.level0StopWritesTrigger = builder.level0StopWritesTrigger;
        this.maxBackgroundFlushes = builder.maxBackgroundFlushes;
        this.maxBackgroundCompactions = builder.maxBackgroundCompactions;
        this.syncMillis = builder.syncMillis;
        this.syncWarningNanos = builder.syncWarningNanos;
        this.storagePath = builder.storagePath;
        this.adviseRandomOnOpen = builder.adviseRandomOnOpen;
        this.createIfMissing = builder.createIfMissing;
        this.createMissingColumnFamilies = builder.createMissingColumnFamilies;
        this.useFsync = builder.useFsync;
        this.columnFamilyNames = builder.columnFamilyNames;
        this.columnFamilyHandles = new HashMap<String, ColumnFamilyHandle>(this.columnFamilyNames.size());
        this.periodicSyncEnabled = builder.periodicSyncEnabled;
        this.syncExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
    }

    public void initialize() throws IOException {
        String rocksSharedLibDir = System.getenv("ROCKSDB_SHAREDLIB_DIR");
        String javaTmpDir = System.getProperty("java.io.tmpdir");
        String libDir = !StringUtils.isBlank((String)rocksSharedLibDir) ? rocksSharedLibDir : javaTmpDir;
        try {
            Files.createDirectories(Paths.get(libDir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IOException("Unable to load the RocksDB shared library into directory: " + libDir, e);
        }
        File[] rocksSos = Paths.get(libDir, new String[0]).toFile().listFiles((dir, name) -> name.startsWith("librocksdbjni") && name.endsWith(".so"));
        if (rocksSos != null) {
            for (File rocksSo : rocksSos) {
                if (rocksSo.delete()) continue;
                logger.warn("Could not delete existing librocksdbjni*.so file {}", (Object)rocksSo);
            }
        }
        try {
            RocksDB.loadLibrary();
        }
        catch (Throwable t) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                logger.error("The RocksDBMetronome will only work on Windows if you have Visual C++ runtime libraries for Visual Studio 2015 installed.  If the DLLs required to support RocksDB cannot be found, then NiFi will not start!");
            }
            throw t;
        }
        Files.createDirectories(this.storagePath, new FileAttribute[0]);
        this.forceSyncWriteOptions = new WriteOptions().setDisableWAL(false).setSync(true);
        this.noSyncWriteOptions = new WriteOptions().setDisableWAL(false).setSync(false);
        this.dbWriteLock.lock();
        try (DBOptions dbOptions = new DBOptions().setAccessHintOnCompactionStart(AccessHint.SEQUENTIAL).setAdviseRandomOnOpen(this.adviseRandomOnOpen).setAllowMmapWrites(false).setCreateIfMissing(this.createIfMissing).setCreateMissingColumnFamilies(this.createMissingColumnFamilies).setDelayedWriteRate(this.delayedWriteRate).setIncreaseParallelism(this.parallelThreads).setLogger(this.getRocksLogger()).setMaxBackgroundCompactions(this.maxBackgroundCompactions).setMaxBackgroundFlushes(this.maxBackgroundFlushes).setMaxTotalWalSize(this.maxTotalWalSize).setStatsDumpPeriodSec(this.statDumpSeconds).setUseFsync(this.useFsync);
             ColumnFamilyOptions cfOptions = new ColumnFamilyOptions().setCompressionType(CompressionType.LZ4_COMPRESSION).setLevel0SlowdownWritesTrigger(this.level0SlowdownWritesTrigger).setLevel0StopWritesTrigger(this.level0StopWritesTrigger).setMaxWriteBufferNumber(this.maxWriteBufferNumber).setMinWriteBufferNumberToMerge(this.minWriteBufferNumberToMerge).setWriteBufferSize(this.writeBufferSize);){
            ArrayList<ColumnFamilyDescriptor> familyDescriptors = new ArrayList<ColumnFamilyDescriptor>(this.columnFamilyNames.size());
            for (byte[] name2 : this.columnFamilyNames) {
                familyDescriptors.add(new ColumnFamilyDescriptor(name2, cfOptions));
            }
            ArrayList columnFamilyList = new ArrayList(this.columnFamilyNames.size());
            this.rocksDB = RocksDB.open((DBOptions)dbOptions, (String)this.storagePath.toString(), familyDescriptors, columnFamilyList);
            this.columnFamilyHandles.put(DEFAULT_FAMILY, this.rocksDB.getDefaultColumnFamily());
            for (ColumnFamilyHandle cf : columnFamilyList) {
                this.columnFamilyHandles.put(new String(cf.getName(), StandardCharsets.UTF_8), cf);
            }
            this.defaultColumnFamilyHandle = this.rocksDB.getDefaultColumnFamily();
            this.configurationColumnFamilyHandle = this.columnFamilyHandles.get(CONFIGURATION_FAMILY);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
        finally {
            this.dbWriteLock.unlock();
        }
        if (this.periodicSyncEnabled) {
            this.syncExecutor.scheduleWithFixedDelay(this::doSync, this.syncMillis, this.syncMillis, TimeUnit.MILLISECONDS);
        }
        logger.info("Initialized RocksDB Repository at {}", (Object)this.storagePath);
    }

    private void checkDbState() throws IllegalStateException {
        if (this.rocksDB == null) {
            if (this.closed) {
                throw new IllegalStateException("RocksDBMetronome is closed");
            }
            throw new IllegalStateException("RocksDBMetronome has not been initialized");
        }
    }

    public RocksIterator getIterator(ColumnFamilyHandle columnFamilyHandle) {
        this.dbReadLock.lock();
        try {
            this.checkDbState();
            RocksIterator rocksIterator = this.rocksDB.newIterator(columnFamilyHandle);
            return rocksIterator;
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        this.dbReadLock.lock();
        try {
            this.checkDbState();
            byte[] byArray = this.rocksDB.get(columnFamilyHandle, key);
            return byArray;
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] key, byte[] value) throws RocksDBException {
        this.dbReadLock.lock();
        try {
            this.checkDbState();
            this.rocksDB.put(columnFamilyHandle, writeOptions, key, value);
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] key, WriteOptions writeOptions) throws RocksDBException {
        this.dbReadLock.lock();
        try {
            this.checkDbState();
            this.rocksDB.delete(columnFamilyHandle, writeOptions, key);
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    public void forceSync() throws RocksDBException {
        this.dbReadLock.lock();
        try {
            this.checkDbState();
            this.rocksDB.syncWal();
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    public ColumnFamilyHandle getColumnFamilyHandle(String familyName) {
        return this.columnFamilyHandles.get(familyName);
    }

    public void putConfiguration(byte[] key, byte[] value) throws RocksDBException {
        this.put(this.configurationColumnFamilyHandle, this.forceSyncWriteOptions, key, value);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        this.put(columnFamilyHandle, this.noSyncWriteOptions, key, value);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value, boolean forceSync) throws RocksDBException {
        this.put(columnFamilyHandle, this.getWriteOptions(forceSync), key, value);
    }

    public void put(byte[] key, byte[] value, boolean forceSync) throws RocksDBException {
        this.put(this.defaultColumnFamilyHandle, this.getWriteOptions(forceSync), key, value);
    }

    public void put(byte[] key, byte[] value) throws RocksDBException {
        this.put(this.defaultColumnFamilyHandle, this.noSyncWriteOptions, key, value);
    }

    public byte[] get(byte[] key) throws RocksDBException {
        return this.get(this.defaultColumnFamilyHandle, key);
    }

    public byte[] getConfiguration(byte[] key) throws RocksDBException {
        return this.get(this.configurationColumnFamilyHandle, key);
    }

    public void delete(byte[] key) throws RocksDBException {
        this.delete(this.defaultColumnFamilyHandle, key, this.noSyncWriteOptions);
    }

    public void delete(byte[] key, boolean forceSync) throws RocksDBException {
        this.delete(this.defaultColumnFamilyHandle, key, this.getWriteOptions(forceSync));
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        this.delete(columnFamilyHandle, key, this.noSyncWriteOptions);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] key, boolean forceSync) throws RocksDBException {
        this.delete(columnFamilyHandle, key, this.getWriteOptions(forceSync));
    }

    private WriteOptions getWriteOptions(boolean forceSync) {
        return forceSync ? this.forceSyncWriteOptions : this.noSyncWriteOptions;
    }

    public RocksIterator getIterator() {
        return this.getIterator(this.defaultColumnFamilyHandle);
    }

    public int getSyncCounterValue() {
        return this.syncCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        logger.info("Closing RocksDBMetronome");
        this.dbWriteLock.lock();
        try {
            logger.info("Shutting down RocksDBMetronome sync executor");
            this.syncExecutor.shutdownNow();
            try {
                logger.info("Pausing RocksDB background work");
                this.rocksDB.pauseBackgroundWork();
            }
            catch (RocksDBException e) {
                logger.warn("Unable to pause background work before close.", (Throwable)e);
            }
            AtomicReference<Exception> exceptionReference = new AtomicReference<Exception>();
            logger.info("Closing RocksDB configurations");
            this.safeClose((AutoCloseable)this.forceSyncWriteOptions, exceptionReference);
            this.safeClose((AutoCloseable)this.noSyncWriteOptions, exceptionReference);
            for (ColumnFamilyHandle cfh : this.columnFamilyHandles.values()) {
                this.safeClose((AutoCloseable)cfh, exceptionReference);
            }
            logger.info("Closing RocksDB database");
            this.safeClose((AutoCloseable)this.rocksDB, exceptionReference);
            this.rocksDB = null;
            this.closed = true;
            if (exceptionReference.get() != null) {
                throw new IOException(exceptionReference.get());
            }
        }
        finally {
            this.dbWriteLock.unlock();
        }
    }

    private void safeClose(AutoCloseable autoCloseable, AtomicReference<Exception> exceptionReference) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                exceptionReference.set(e);
            }
        }
    }

    public long getStorageCapacity() throws IOException {
        return Files.getFileStore(this.storagePath).getTotalSpace();
    }

    public long getUsableStorageSpace() throws IOException {
        return Files.getFileStore(this.storagePath).getUsableSpace();
    }

    void doSync() {
        this.syncLock.lock();
        try {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.forceSync();
            this.syncCounter.incrementAndGet();
            this.syncCondition.signalAll();
        }
        catch (IllegalArgumentException e) {
            logger.error("Unable to sync, likely because the repository is out of space.", (Throwable)e);
        }
        catch (Throwable t) {
            logger.error("Unable to sync", t);
        }
        finally {
            this.syncLock.unlock();
        }
    }

    public void waitForSync() throws InterruptedException {
        int counterValue = this.syncCounter.get();
        this.waitForSync(counterValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSync(int counterValue) throws InterruptedException {
        if (counterValue != this.syncCounter.get()) {
            return;
        }
        long waitTimeRemaining = this.syncWarningNanos;
        this.syncLock.lock();
        try {
            while (counterValue == this.syncCounter.get()) {
                long lastWarning;
                if ((waitTimeRemaining = this.syncCondition.awaitNanos(waitTimeRemaining)) > 0L) continue;
                long now = System.nanoTime();
                if (now - (lastWarning = this.lastSyncWarningNanos.get()) > this.syncWarningNanos && this.lastSyncWarningNanos.compareAndSet(lastWarning, now)) {
                    logger.warn("Failed to sync within {} seconds... system configuration may need to be adjusted", (Object)TimeUnit.NANOSECONDS.toSeconds(this.syncWarningNanos));
                }
                waitTimeRemaining = this.syncWarningNanos;
            }
        }
        finally {
            this.syncLock.unlock();
        }
    }

    public static byte[] getBytes(long value) {
        byte[] bytes = new byte[8];
        RocksDBMetronome.writeLong(value, bytes);
        return bytes;
    }

    public static void writeLong(long l, byte[] bytes) {
        bytes[0] = (byte)(l >>> 56);
        bytes[1] = (byte)(l >>> 48);
        bytes[2] = (byte)(l >>> 40);
        bytes[3] = (byte)(l >>> 32);
        bytes[4] = (byte)(l >>> 24);
        bytes[5] = (byte)(l >>> 16);
        bytes[6] = (byte)(l >>> 8);
        bytes[7] = (byte)l;
    }

    public static long readLong(byte[] bytes) throws IOException {
        if (bytes.length != 8) {
            throw new IOException("wrong number of bytes to convert to long (must be 8)");
        }
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + ((long)(bytes[5] & 0xFF) << 16) + ((long)(bytes[6] & 0xFF) << 8) + (long)(bytes[7] & 0xFF);
    }

    public Path getStoragePath() {
        return this.storagePath;
    }

    private org.rocksdb.Logger getRocksLogger() {
        try (Options options = new Options().setInfoLogLevel(InfoLogLevel.DEBUG_LEVEL);){
            LogWrapper logWrapper = new LogWrapper(options);
            return logWrapper;
        }
    }

    public static class Builder {
        int parallelThreads = 8;
        int maxWriteBufferNumber = 4;
        int minWriteBufferNumberToMerge = 1;
        long writeBufferSize = (long)DataUnit.MB.toB(256.0);
        long delayedWriteRate = (long)DataUnit.MB.toB(16.0);
        int level0SlowdownWritesTrigger = 20;
        int level0StopWritesTrigger = 40;
        int maxBackgroundFlushes = 1;
        int maxBackgroundCompactions = 1;
        int statDumpSeconds = 600;
        long syncMillis = 10L;
        long syncWarningNanos = TimeUnit.SECONDS.toNanos(30L);
        Path storagePath;
        boolean adviseRandomOnOpen = false;
        boolean createIfMissing = true;
        boolean createMissingColumnFamilies = true;
        boolean useFsync = true;
        boolean periodicSyncEnabled = true;
        final Set<byte[]> columnFamilyNames = new HashSet<byte[]>();

        public RocksDBMetronome build() {
            if (this.storagePath == null) {
                throw new IllegalStateException("Cannot create RocksDBMetronome because storagePath is not set");
            }
            this.columnFamilyNames.add(RocksDB.DEFAULT_COLUMN_FAMILY);
            this.columnFamilyNames.add(RocksDBMetronome.CONFIGURATION_FAMILY.getBytes(StandardCharsets.UTF_8));
            return new RocksDBMetronome(this);
        }

        public Builder addColumnFamily(String name) {
            this.columnFamilyNames.add(name.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public Builder setStoragePath(Path storagePath) {
            this.storagePath = storagePath;
            return this;
        }

        public Builder setParallelThreads(int parallelThreads) {
            this.parallelThreads = parallelThreads;
            return this;
        }

        public Builder setMaxWriteBufferNumber(int maxWriteBufferNumber) {
            this.maxWriteBufferNumber = maxWriteBufferNumber;
            return this;
        }

        public Builder setMinWriteBufferNumberToMerge(int minWriteBufferNumberToMerge) {
            this.minWriteBufferNumberToMerge = minWriteBufferNumberToMerge;
            return this;
        }

        public Builder setWriteBufferSize(long writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
            return this;
        }

        public Builder setDelayedWriteRate(long delayedWriteRate) {
            this.delayedWriteRate = delayedWriteRate;
            return this;
        }

        public Builder setLevel0SlowdownWritesTrigger(int level0SlowdownWritesTrigger) {
            this.level0SlowdownWritesTrigger = level0SlowdownWritesTrigger;
            return this;
        }

        public Builder setLevel0StopWritesTrigger(int level0StopWritesTrigger) {
            this.level0StopWritesTrigger = level0StopWritesTrigger;
            return this;
        }

        public Builder setMaxBackgroundFlushes(int maxBackgroundFlushes) {
            this.maxBackgroundFlushes = maxBackgroundFlushes;
            return this;
        }

        public Builder setMaxBackgroundCompactions(int maxBackgroundCompactions) {
            this.maxBackgroundCompactions = maxBackgroundCompactions;
            return this;
        }

        public Builder setStatDumpSeconds(int statDumpSeconds) {
            this.statDumpSeconds = statDumpSeconds;
            return this;
        }

        public Builder setSyncMillis(long syncMillis) {
            this.syncMillis = syncMillis;
            return this;
        }

        public Builder setSyncWarningNanos(long syncWarningNanos) {
            this.syncWarningNanos = syncWarningNanos;
            return this;
        }

        public Builder setAdviseRandomOnOpen(boolean adviseRandomOnOpen) {
            this.adviseRandomOnOpen = adviseRandomOnOpen;
            return this;
        }

        public Builder setCreateMissingColumnFamilies(boolean createMissingColumnFamilies) {
            this.createMissingColumnFamilies = createMissingColumnFamilies;
            return this;
        }

        public Builder setCreateIfMissing(boolean createIfMissing) {
            this.createIfMissing = createIfMissing;
            return this;
        }

        public Builder setUseFsync(boolean useFsync) {
            this.useFsync = useFsync;
            return this;
        }

        public Builder setPeriodicSyncEnabled(boolean periodicSyncEnabled) {
            this.periodicSyncEnabled = periodicSyncEnabled;
            return this;
        }

        long getMaxTotalWalSize() {
            return this.writeBufferSize * (long)this.maxWriteBufferNumber;
        }
    }

    private class LogWrapper
    extends org.rocksdb.Logger {
        LogWrapper(Options options) {
            super(options);
        }

        protected void log(InfoLogLevel infoLogLevel, String logMsg) {
            switch (infoLogLevel) {
                case ERROR_LEVEL: 
                case FATAL_LEVEL: {
                    logger.error(logMsg);
                    break;
                }
                case WARN_LEVEL: {
                    logger.warn(logMsg);
                    break;
                }
                case INFO_LEVEL: 
                case DEBUG_LEVEL: {
                    logger.debug(logMsg);
                    break;
                }
                default: {
                    logger.info(logMsg);
                }
            }
        }
    }
}

