/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Invocable;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.AbstractScriptProcessor;
import org.apache.nifi.processors.script.ExecuteScript;
import org.apache.nifi.processors.script.ScriptEngineConfigurator;

@Tags(value={"script", "invoke", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj"})
@CapabilityDescription(value="Experimental - Invokes a script engine for a Processor defined in the given script. The script must define a valid class that implements the Processor interface, and it must set a variable 'processor' to an instance of the class. Processor methods such as onTrigger() will be delegated to the scripted Processor instance. Also any Relationships or PropertyDescriptors defined by the scripted processor will be added to the configuration dialog.  Experimental: Impact of sustained usage not yet verified.")
@DynamicProperty(name="A script engine property to update", value="The value to set it to", supportsExpressionLanguage=true, description="Updates a script engine property specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@SeeAlso(value={ExecuteScript.class})
public class InvokeScriptedProcessor
extends AbstractScriptProcessor {
    private final AtomicReference<Processor> processor = new AtomicReference();
    private final AtomicReference<Collection<ValidationResult>> validationResults = new AtomicReference(new ArrayList());
    private AtomicBoolean scriptNeedsReload = new AtomicBoolean(true);

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        Processor instance = this.processor.get();
        if (instance != null) {
            try {
                relationships.addAll(instance.getRelationships());
            }
            catch (Throwable t) {
                ProcessorLog logger = this.getLogger();
                String message = "Unable to get relationships from scripted Processor: " + t;
                logger.error(message);
                if (logger.isDebugEnabled()) {
                    logger.error(message, t);
                }
            }
        } else {
            relationships.add(REL_SUCCESS);
            relationships.add(REL_FAILURE);
        }
        return Collections.unmodifiableSet(relationships);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList supportedPropertyDescriptors;
        block8: {
            AtomicBoolean atomicBoolean = this.isInitialized;
            synchronized (atomicBoolean) {
                if (!this.isInitialized.get()) {
                    this.createResources();
                }
            }
            supportedPropertyDescriptors = new ArrayList();
            supportedPropertyDescriptors.addAll(this.descriptors);
            Processor instance = this.processor.get();
            if (instance != null) {
                try {
                    List instanceDescriptors = instance.getPropertyDescriptors();
                    if (instanceDescriptors != null) {
                        supportedPropertyDescriptors.addAll(instanceDescriptors);
                    }
                }
                catch (Throwable t) {
                    ProcessorLog logger = this.getLogger();
                    String message = "Unable to get property descriptors from Processor: " + t;
                    logger.error(message);
                    if (!logger.isDebugEnabled()) break block8;
                    logger.error(message, t);
                }
            }
        }
        return Collections.unmodifiableList(supportedPropertyDescriptors);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).dynamic(true).build();
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        this.scriptEngineName = context.getProperty(SCRIPT_ENGINE).getValue();
        this.scriptPath = context.getProperty(SCRIPT_FILE).evaluateAttributeExpressions().getValue();
        this.scriptBody = context.getProperty(SCRIPT_BODY).getValue();
        String modulePath = context.getProperty(MODULES).getValue();
        this.modules = !StringUtils.isEmpty((CharSequence)modulePath) ? modulePath.split(",") : new String[0];
        this.setup();
    }

    @Override
    public void setup() {
        super.setup();
        if (this.scriptNeedsReload.get() || this.processor.get() == null) {
            if (this.isFile(this.scriptPath)) {
                this.reloadScriptFile(this.scriptPath);
            } else {
                this.reloadScriptBody(this.scriptBody);
            }
            this.scriptNeedsReload.set(false);
        }
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        ProcessorLog logger = this.getLogger();
        Processor instance = this.processor.get();
        if (SCRIPT_FILE.equals((Object)descriptor) || SCRIPT_BODY.equals((Object)descriptor) || MODULES.equals((Object)descriptor) || SCRIPT_ENGINE.equals((Object)descriptor)) {
            this.scriptNeedsReload.set(true);
        } else if (instance != null) {
            try {
                instance.onPropertyModified(descriptor, oldValue, newValue);
            }
            catch (Exception e) {
                String message = "Unable to invoke onPropertyModified from script Processor: " + e;
                logger.error(message, (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reloadScriptFile(String scriptPath) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        try (FileInputStream scriptStream = new FileInputStream(scriptPath);){
            boolean throwable3 = this.reloadScript(IOUtils.toString((InputStream)scriptStream));
            return throwable3;
        }
        catch (Exception e) {
            ProcessorLog logger = this.getLogger();
            String message = "Unable to load script: " + e;
            logger.error(message, (Throwable)e);
            results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + e).input(scriptPath).build());
            this.validationResults.set(results);
            return results.isEmpty();
        }
    }

    private boolean reloadScriptBody(String scriptBody) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        try {
            return this.reloadScript(scriptBody);
        }
        catch (Exception e) {
            ProcessorLog logger = this.getLogger();
            String message = "Unable to load script: " + e;
            logger.error(message, (Throwable)e);
            results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + e).input(this.scriptPath).build());
            this.validationResults.set(results);
            return results.isEmpty();
        }
    }

    private boolean reloadScript(String scriptBody) {
        HashSet<ValidationResult> results;
        block9: {
            results = new HashSet<ValidationResult>();
            try {
                if (!(this.scriptEngine instanceof Invocable)) break block9;
                Invocable invocable = (Invocable)((Object)this.scriptEngine);
                ScriptEngineConfigurator configurator = (ScriptEngineConfigurator)this.scriptEngineConfiguratorMap.get(this.scriptEngineName.toLowerCase());
                if (configurator != null) {
                    configurator.eval(this.scriptEngine, scriptBody, this.modules);
                } else {
                    this.scriptEngine.eval(scriptBody);
                }
                Object obj = this.scriptEngine.get("processor");
                if (obj != null) {
                    ProcessorLog logger;
                    block10: {
                        logger = this.getLogger();
                        try {
                            invocable.invokeMethod(obj, "setLogger", logger);
                        }
                        catch (NoSuchMethodException nsme) {
                            if (!logger.isDebugEnabled()) break block10;
                            logger.debug("Configured script Processor does not contain a setLogger method.");
                        }
                    }
                    Processor scriptProcessor = invocable.getInterface(obj, Processor.class);
                    this.processor.set(scriptProcessor);
                    if (scriptProcessor == null) break block9;
                    try {
                        scriptProcessor.initialize(new ProcessorInitializationContext(){

                            public String getIdentifier() {
                                return InvokeScriptedProcessor.this.getIdentifier();
                            }

                            public ProcessorLog getLogger() {
                                return logger;
                            }

                            public ControllerServiceLookup getControllerServiceLookup() {
                                return InvokeScriptedProcessor.super.getControllerServiceLookup();
                            }
                        });
                        break block9;
                    }
                    catch (Exception e) {
                        logger.error("Unable to initialize scripted Processor: " + e.getLocalizedMessage(), (Throwable)e);
                        throw new ProcessException((Throwable)e);
                    }
                }
                throw new ScriptException("No processor was defined by the script.");
            }
            catch (Exception ex) {
                ProcessorLog logger = this.getLogger();
                String message = "Unable to load script: " + ex.getLocalizedMessage();
                logger.error(message, (Throwable)ex);
                results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + ex.getLocalizedMessage()).input(this.scriptPath).build());
            }
        }
        this.validationResults.set(results);
        return results.isEmpty();
    }

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        Collection<ValidationResult> commonValidationResults = super.customValidate(context);
        if (!commonValidationResults.isEmpty()) {
            return commonValidationResults;
        }
        this.scriptEngineName = context.getProperty(SCRIPT_ENGINE).getValue();
        this.scriptPath = context.getProperty(SCRIPT_FILE).evaluateAttributeExpressions().getValue();
        this.scriptBody = context.getProperty(SCRIPT_BODY).getValue();
        String modulePath = context.getProperty(MODULES).getValue();
        this.modules = !StringUtils.isEmpty((CharSequence)modulePath) ? modulePath.split(",") : new String[0];
        this.setup();
        Processor instance = this.processor.get();
        Collection<ValidationResult> currentValidationResults = this.validationResults.get();
        if (currentValidationResults.isEmpty() && instance != null) {
            try {
                Collection instanceResults = instance.validate(context);
                if (instanceResults != null && instanceResults.size() > 0) {
                    return instanceResults;
                }
            }
            catch (Exception e) {
                ProcessorLog logger = this.getLogger();
                String message = "Unable to validate the script Processor: " + e;
                logger.error(message, (Throwable)e);
                HashSet<ValidationResult> results = new HashSet<ValidationResult>();
                results.add(new ValidationResult.Builder().subject("Validation").valid(false).explanation("An error occurred calling validate in the configured script Processor.").input(context.getProperty(SCRIPT_FILE).getValue()).build());
                return results;
            }
        }
        return currentValidationResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.isInitialized.get()) {
                super.createResources();
            }
        }
        ProcessorLog log = this.getLogger();
        Processor instance = this.processor.get();
        Collection<ValidationResult> results = this.validationResults.get();
        if (!results.isEmpty()) {
            log.error(String.format("Unable to run because the Processor is not valid: [%s]", StringUtils.join(results, (String)", ")));
            context.yield();
            return;
        }
        if (instance != null) {
            try {
                instance.onTrigger(context, sessionFactory);
            }
            catch (ProcessException e) {
                String message = String.format("An error occurred executing the configured Processor [%s]: %s", new Object[]{context.getProperty(SCRIPT_FILE).getValue(), e});
                log.error(message);
                throw e;
            }
        } else {
            log.error("There is no processor defined by the script");
        }
    }

    @OnStopped
    public void stop() {
        this.processor.set(null);
    }
}

