/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.metrics;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.reporting.ReportingContext;

public class JvmMetricsEnumerator
implements Enumerator<Object> {
    private final ReportingContext context;
    private final ComponentLog logger;
    private final int[] fields;
    private volatile JvmMetrics virtualMachineMetrics;
    private Object currentRow;
    private boolean fetchMetrics = true;

    public JvmMetricsEnumerator(ReportingContext context, ComponentLog logger, int[] fields) {
        this.context = context;
        this.logger = logger;
        this.fields = fields;
        this.reset();
        this.virtualMachineMetrics = JmxJvmMetrics.getInstance();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        if (this.fetchMetrics) {
            this.currentRow = this.filterColumns(this.virtualMachineMetrics);
            this.fetchMetrics = false;
            return true;
        }
        this.close();
        try {
            this.onFinish();
        }
        catch (Exception e) {
            this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
        }
        this.fetchMetrics = true;
        return false;
    }

    protected int getRecordsRead() {
        return 1;
    }

    protected void onFinish() {
    }

    private Object filterColumns(JvmMetrics metrics) {
        if (metrics == null) {
            return null;
        }
        ArrayList<Number> rowList = new ArrayList<Number>();
        rowList.add(this.virtualMachineMetrics.daemonThreadCount());
        rowList.add(this.virtualMachineMetrics.threadCount());
        Double d = (Double)this.virtualMachineMetrics.threadStatePercentages().get((Object)Thread.State.BLOCKED);
        rowList.add((int)(100.0 * (d == null ? 0.0 : d)));
        d = (Double)this.virtualMachineMetrics.threadStatePercentages().get((Object)Thread.State.RUNNABLE);
        rowList.add((int)(100.0 * (d == null ? 0.0 : d)));
        d = (Double)this.virtualMachineMetrics.threadStatePercentages().get((Object)Thread.State.TERMINATED);
        rowList.add((int)(100.0 * (d == null ? 0.0 : d)));
        d = (Double)this.virtualMachineMetrics.threadStatePercentages().get((Object)Thread.State.TIMED_WAITING);
        rowList.add((int)(100.0 * (d == null ? 0.0 : d)));
        rowList.add(this.virtualMachineMetrics.uptime());
        rowList.add(this.virtualMachineMetrics.heapUsed(DataUnit.B));
        rowList.add(this.virtualMachineMetrics.heapUsage());
        rowList.add(this.virtualMachineMetrics.nonHeapUsage());
        rowList.add(this.virtualMachineMetrics.fileDescriptorUsage());
        this.virtualMachineMetrics.garbageCollectors().values().forEach(gc -> {
            rowList.add(gc.getRuns());
            rowList.add(gc.getTime(TimeUnit.MILLISECONDS));
        });
        Object[] row = rowList.toArray();
        if (this.fields == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return row[desiredCellIndex];
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = row[indexToKeep];
        }
        return filtered;
    }

    public void reset() {
        this.fetchMetrics = true;
    }

    public void close() {
    }
}

