/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.bulletins;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.ReportingContext;

public class BulletinEnumerator
implements Enumerator<Object> {
    private final ReportingContext context;
    private final ComponentLog logger;
    private final int[] fields;
    private Iterator<Bulletin> bulletinIterator;
    private Object currentRow;
    private int recordsRead = 0;

    public BulletinEnumerator(ReportingContext context, ComponentLog logger, int[] fields) {
        this.context = context;
        this.logger = logger;
        this.fields = fields;
        this.reset();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        this.currentRow = null;
        if (!this.bulletinIterator.hasNext()) {
            this.close();
            try {
                this.onFinish();
            }
            catch (Exception e) {
                this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
            }
            return false;
        }
        Bulletin bulletin = this.bulletinIterator.next();
        this.currentRow = this.filterColumns(bulletin);
        ++this.recordsRead;
        return true;
    }

    protected int getRecordsRead() {
        return this.recordsRead;
    }

    protected void onFinish() {
    }

    private Object filterColumns(Bulletin bulletin) {
        if (bulletin == null) {
            return null;
        }
        boolean isClustered = this.context.isClustered();
        String nodeId = this.context.getClusterNodeIdentifier();
        if (nodeId == null && isClustered) {
            nodeId = "unknown";
        }
        Object[] row = new Object[]{bulletin.getId(), bulletin.getCategory(), bulletin.getGroupId(), bulletin.getGroupName(), bulletin.getGroupPath(), bulletin.getLevel(), bulletin.getMessage(), bulletin.getNodeAddress(), nodeId, bulletin.getSourceId(), bulletin.getSourceName(), bulletin.getSourceType() == null ? null : bulletin.getSourceType().name(), bulletin.getTimestamp() == null ? null : Long.valueOf(bulletin.getTimestamp().getTime()), bulletin.getFlowFileUuid()};
        if (this.fields == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return row[desiredCellIndex];
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = row[indexToKeep];
        }
        return filtered;
    }

    public void reset() {
        BulletinRepository bulletinRepo = this.context.getBulletinRepository();
        ArrayList fullBulletinList = new ArrayList(bulletinRepo.findBulletinsForController());
        fullBulletinList.addAll(bulletinRepo.findBulletins(new BulletinQuery.Builder().sourceType(ComponentType.PROCESSOR).build()));
        fullBulletinList.addAll(bulletinRepo.findBulletins(new BulletinQuery.Builder().sourceType(ComponentType.INPUT_PORT).build()));
        fullBulletinList.addAll(bulletinRepo.findBulletins(new BulletinQuery.Builder().sourceType(ComponentType.OUTPUT_PORT).build()));
        fullBulletinList.addAll(bulletinRepo.findBulletins(new BulletinQuery.Builder().sourceType(ComponentType.REMOTE_PROCESS_GROUP).build()));
        fullBulletinList.addAll(bulletinRepo.findBulletins(new BulletinQuery.Builder().sourceType(ComponentType.REPORTING_TASK).build()));
        fullBulletinList.addAll(bulletinRepo.findBulletins(new BulletinQuery.Builder().sourceType(ComponentType.PARAMETER_PROVIDER).build()));
        fullBulletinList.addAll(bulletinRepo.findBulletins(new BulletinQuery.Builder().sourceType(ComponentType.FLOW_REGISTRY_CLIENT).build()));
        fullBulletinList.addAll(bulletinRepo.findBulletins(new BulletinQuery.Builder().sourceType(ComponentType.CONTROLLER_SERVICE).build()));
        this.bulletinIterator = fullBulletinList.iterator();
    }

    public void close() {
    }
}

