/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.flowconfighistory;

import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.details.ConfigureDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.MoveDetails;
import org.apache.nifi.action.details.PurgeDetails;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;

public class FlowConfigHistoryEnumerator
implements Enumerator<Object> {
    private final ReportingContext context;
    private final ComponentLog logger;
    private final int[] fields;
    private Iterator<Action> actionIterator;
    private Object currentRow;
    private int recordsRead = 0;

    public FlowConfigHistoryEnumerator(ReportingContext context, ComponentLog logger, int[] fields) {
        this.context = context;
        this.logger = logger;
        this.fields = fields;
        this.reset();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        this.currentRow = null;
        if (!this.actionIterator.hasNext()) {
            this.close();
            try {
                this.onFinish();
            }
            catch (Exception e) {
                this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
            }
            return false;
        }
        Action action = this.actionIterator.next();
        this.currentRow = this.filterColumns(action);
        ++this.recordsRead;
        return true;
    }

    protected int getRecordsRead() {
        return this.recordsRead;
    }

    protected void onFinish() {
    }

    private Object filterColumns(Action action) {
        if (action == null) {
            return null;
        }
        boolean isClustered = this.context.isClustered();
        String nodeId = this.context.getClusterNodeIdentifier();
        if (nodeId == null && isClustered) {
            nodeId = "unknown";
        }
        Object[] row = new Object[]{action.getId(), action.getTimestamp().getTime(), action.getUserIdentity(), action.getSourceId(), action.getSourceName(), action.getSourceType(), action.getOperation().toString(), action.getActionDetails() instanceof ConfigureDetails ? ((ConfigureDetails)action.getActionDetails()).getName() : null, action.getActionDetails() instanceof ConfigureDetails ? ((ConfigureDetails)action.getActionDetails()).getPreviousValue() : null, action.getActionDetails() instanceof ConfigureDetails ? ((ConfigureDetails)action.getActionDetails()).getValue() : null, action.getActionDetails() instanceof ConnectDetails ? ((ConnectDetails)action.getActionDetails()).getSourceId() : null, action.getActionDetails() instanceof ConnectDetails ? ((ConnectDetails)action.getActionDetails()).getSourceName() : null, action.getActionDetails() instanceof ConnectDetails ? ((ConnectDetails)action.getActionDetails()).getSourceType() : null, action.getActionDetails() instanceof ConnectDetails ? ((ConnectDetails)action.getActionDetails()).getDestinationId() : null, action.getActionDetails() instanceof ConnectDetails ? ((ConnectDetails)action.getActionDetails()).getDestinationName() : null, action.getActionDetails() instanceof ConnectDetails ? ((ConnectDetails)action.getActionDetails()).getDestinationType() : null, action.getActionDetails() instanceof ConnectDetails ? ((ConnectDetails)action.getActionDetails()).getRelationship() : null, action.getActionDetails() instanceof MoveDetails ? ((MoveDetails)action.getActionDetails()).getGroup() : null, action.getActionDetails() instanceof MoveDetails ? ((MoveDetails)action.getActionDetails()).getGroupId() : null, action.getActionDetails() instanceof MoveDetails ? ((MoveDetails)action.getActionDetails()).getPreviousGroup() : null, action.getActionDetails() instanceof MoveDetails ? ((MoveDetails)action.getActionDetails()).getPreviousGroupId() : null, action.getActionDetails() instanceof PurgeDetails ? Long.valueOf(((PurgeDetails)action.getActionDetails()).getEndDate().getTime()) : null};
        if (this.fields == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return row[desiredCellIndex];
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = row[indexToKeep];
        }
        return filtered;
    }

    public void reset() {
        List fullFlowConfigHistoryList = this.context.getEventAccess().getFlowChanges(0, Short.MAX_VALUE);
        this.actionIterator = fullFlowConfigHistoryList.iterator();
    }

    public void close() {
    }
}

