/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.provenance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.util.provenance.ComponentMapHolder;

public class ProvenanceEnumerator
implements Enumerator<Object> {
    private static final int FETCH_SIZE = 1000;
    private final ComponentLog logger;
    private final int[] fields;
    private final ProvenanceEventRepository provenanceEventRepository;
    private List<ProvenanceEventRecord> provenanceEvents;
    private final ComponentMapHolder componentMapHolder;
    private final String nodeIdentifier;
    private Object currentRow;
    private long currentId = 0L;
    private int currentIndex = 0;

    public ProvenanceEnumerator(ReportingContext context, ComponentLog logger, int[] fields) {
        this.logger = logger;
        this.fields = fields;
        EventAccess eventAccess = context.getEventAccess();
        this.provenanceEventRepository = eventAccess.getProvenanceRepository();
        ProcessGroupStatus procGroupStatus = eventAccess.getControllerStatus();
        this.componentMapHolder = ComponentMapHolder.createComponentMap((ProcessGroupStatus)procGroupStatus);
        boolean isClustered = context.isClustered();
        this.nodeIdentifier = context.getClusterNodeIdentifier();
        if (this.nodeIdentifier == null && isClustered) {
            logger.warn("This instance of NiFi is configured for clustering, but the Cluster Node Identifier is not yet available. The contentPath and previousContentPath fields will be null for all rows in this query");
        }
        try {
            this.provenanceEvents = this.provenanceEventRepository.getEvents(0L, 1000);
        }
        catch (IOException ioe) {
            logger.error("Error retrieving provenance events, queries will return no rows");
        }
        this.reset();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        if (this.provenanceEvents == null) {
            return false;
        }
        this.currentRow = null;
        if (this.currentIndex == this.provenanceEvents.size()) {
            try {
                this.provenanceEvents = this.provenanceEventRepository.getEvents(this.currentId + 1L, 1000);
                this.currentIndex = 0;
            }
            catch (IOException ioe) {
                this.logger.error("Error retrieving provenance events, queries will return no further rows");
                return false;
            }
        }
        if (this.provenanceEvents.isEmpty()) {
            this.close();
            try {
                this.onFinish();
            }
            catch (Exception e) {
                this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
            }
            return false;
        }
        ProvenanceEventRecord provenanceEvent = this.provenanceEvents.get(this.currentIndex);
        this.currentRow = this.filterColumns(provenanceEvent);
        this.currentId = provenanceEvent.getEventId();
        ++this.currentIndex;
        return true;
    }

    protected int getRecordsRead() {
        return 1;
    }

    protected void onFinish() {
    }

    private Object filterColumns(ProvenanceEventRecord provenanceEvent) {
        if (provenanceEvent == null) {
            return null;
        }
        ArrayList<Object> rowList = new ArrayList<Object>();
        rowList.add(provenanceEvent.getEventId());
        rowList.add(provenanceEvent.getEventType().name());
        rowList.add(provenanceEvent.getEventTime());
        rowList.add(provenanceEvent.getEventDuration());
        rowList.add(provenanceEvent.getLineageStartDate());
        rowList.add(provenanceEvent.getDetails());
        rowList.add(provenanceEvent.getComponentId());
        rowList.add(this.componentMapHolder.getComponentName(provenanceEvent.getComponentId()));
        rowList.add(provenanceEvent.getComponentType());
        String processGroupId = this.componentMapHolder.getProcessGroupId(provenanceEvent.getComponentId(), provenanceEvent.getComponentType());
        rowList.add(processGroupId);
        rowList.add(this.componentMapHolder.getComponentName(processGroupId));
        rowList.add(provenanceEvent.getFlowFileUuid());
        rowList.add("org.apache.nifi.flowfile.FlowFile");
        rowList.add(provenanceEvent.getFileSize());
        rowList.add(provenanceEvent.getPreviousFileSize());
        rowList.add(provenanceEvent.getUpdatedAttributes());
        rowList.add(provenanceEvent.getPreviousAttributes());
        if (this.nodeIdentifier != null) {
            String contentPathBase = "/nifi-api/provenance-events/" + provenanceEvent.getEventId() + "/content/";
            String nodeIdSuffix = "?clusterNodeId=" + this.nodeIdentifier;
            rowList.add(contentPathBase + "output" + nodeIdSuffix);
            rowList.add(contentPathBase + "input" + nodeIdSuffix);
        } else {
            rowList.add(null);
            rowList.add(null);
        }
        rowList.add(provenanceEvent.getParentUuids());
        rowList.add(provenanceEvent.getChildUuids());
        rowList.add(provenanceEvent.getTransitUri());
        rowList.add(provenanceEvent.getSourceSystemFlowFileIdentifier());
        rowList.add(provenanceEvent.getAlternateIdentifierUri());
        Object[] row = rowList.toArray();
        if (this.fields == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return row[desiredCellIndex];
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = row[indexToKeep];
        }
        return filtered;
    }

    public void reset() {
        this.currentId = 0L;
        this.currentIndex = 0;
    }

    public void close() {
    }
}

