/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.util;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.reporting.ReportingContext;

public class ConnectionStatusRecursiveIterator
implements Iterator<ConnectionStatus> {
    private final ReportingContext context;
    private Deque<Iterator<ProcessGroupStatus>> iteratorBreadcrumb;
    private Iterator<ConnectionStatus> connectionStatusIterator;
    private ConnectionStatus currentRow;

    public ConnectionStatusRecursiveIterator(ReportingContext context) {
        this.context = context;
        this.iteratorBreadcrumb = new LinkedList<Iterator<ProcessGroupStatus>>();
    }

    @Override
    public boolean hasNext() {
        if (this.iteratorBreadcrumb.isEmpty()) {
            ProcessGroupStatus rootStatus = this.context.getEventAccess().getControllerStatus();
            this.iteratorBreadcrumb.push(rootStatus.getProcessGroupStatus().iterator());
            this.connectionStatusIterator = rootStatus.getConnectionStatus().iterator();
        }
        this.currentRow = this.getNextConnectionStatus();
        return this.currentRow != null;
    }

    @Override
    public ConnectionStatus next() {
        if (this.currentRow != null) {
            ConnectionStatus result = this.currentRow;
            this.currentRow = null;
            return result;
        }
        if (this.hasNext()) {
            ConnectionStatus result = this.currentRow;
            this.currentRow = null;
            return result;
        }
        return null;
    }

    private ConnectionStatus getNextConnectionStatus() {
        if (this.connectionStatusIterator != null && this.connectionStatusIterator.hasNext()) {
            return this.connectionStatusIterator.next();
        }
        this.connectionStatusIterator = null;
        Iterator<ProcessGroupStatus> i = this.iteratorBreadcrumb.peek();
        if (i == null) {
            return null;
        }
        if (i.hasNext()) {
            ProcessGroupStatus nextPG = i.next();
            this.iteratorBreadcrumb.push(nextPG.getProcessGroupStatus().iterator());
            this.connectionStatusIterator = nextPG.getConnectionStatus().iterator();
            return this.getNextConnectionStatus();
        }
        this.iteratorBreadcrumb.pop();
        return this.getNextConnectionStatus();
    }
}

