/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.flowanalyzer;

import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import org.apache.nifi.security.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowAnalyzerDriver {
    static final String CONST_BYTES_GB_CONV = "1000000000";
    static final String CONST_BYTES_MB_CONV = "1000000";
    static final String CONST_BYTES_KB_CONV = "1000";
    static final int DIVIDE_SCALE = 9;
    static final String CONST_XMLNODE_CONNECTION = "connection";

    private static void printUsage() {
        System.out.println("This application seeks to produce a report to analyze the flow.xml.gz file");
        System.out.println("Currently the reports supported by this application are Total Storage for all queues backpressure, average storage of all queues backpressure, and min and max of all queues backpressure over the entire flow.");
        System.out.println("\n\n\n");
        System.out.println("Usage: flow-analyzer.sh <path to flow.xml.gz>");
    }

    public static void main(String[] args) throws Exception {
        BigDecimal totalDataSize = new BigDecimal("0.0");
        BigDecimal max = new BigDecimal("0.0");
        BigDecimal min = new BigDecimal("0.0");
        BigDecimal avg = new BigDecimal("0.0");
        long maxQueueSize = 0L;
        long minQueueSize = 0L;
        long totalQueueSize = 0L;
        int numberOfConnections = 0;
        if (FlowAnalyzerDriver.helpRequested(args)) {
            FlowAnalyzerDriver.printUsage();
            return;
        }
        String input = args[0];
        if (!input.contains("xml.gz")) {
            input = input + "/flow.xml.gz";
        }
        FileInputStream fileStream = new FileInputStream(input);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        System.out.println("Using flow=" + input);
        try {
            DocumentBuilder documentBuilder = XmlUtils.createSafeDocumentBuilder((boolean)false);
            Document document = documentBuilder.parse(gzipStream);
            NodeList connectionNode = document.getElementsByTagName(CONST_XMLNODE_CONNECTION);
            for (int x = 0; x < connectionNode.getLength(); ++x) {
                Node nNode = connectionNode.item(x);
                if (nNode.getNodeType() != 1) continue;
                Element maxWorkQueueSize = (Element)nNode;
                String maxDataSize = maxWorkQueueSize.getElementsByTagName("maxWorkQueueDataSize").item(0).getTextContent();
                BigDecimal byteValue = FlowAnalyzerDriver.convertSizeToByteValue(maxDataSize) != null ? FlowAnalyzerDriver.convertSizeToByteValue(maxDataSize) : new BigDecimal("0.0");
                ++numberOfConnections;
                avg = avg.add(byteValue);
                String dataQueueSize = maxWorkQueueSize.getElementsByTagName("maxWorkQueueSize").item(0).getTextContent();
                Long dataQueueSizeL = Long.valueOf(dataQueueSize);
                totalQueueSize = dataQueueSizeL + totalQueueSize;
                if (dataQueueSizeL > maxQueueSize) {
                    maxQueueSize = dataQueueSizeL;
                }
                if (dataQueueSizeL < minQueueSize || minQueueSize == 0L) {
                    minQueueSize = dataQueueSizeL;
                }
                if (max.compareTo(byteValue) < 0) {
                    max = byteValue;
                }
                if (byteValue.compareTo(min) < 0 || min.compareTo(new BigDecimal("0.0")) == 0) {
                    min = byteValue;
                }
                totalDataSize = totalDataSize.add(byteValue);
            }
            System.out.println("Total Bytes Utilized by System=" + FlowAnalyzerDriver.convertBytesToGB(totalDataSize).toPlainString() + " GB\nMax Back Pressure Size=" + FlowAnalyzerDriver.convertBytesToGB(max).toPlainString() + " GB\nMin Back Pressure Size=" + FlowAnalyzerDriver.convertBytesToGB(min).toPlainString() + " GB\nAverage Back Pressure Size=" + FlowAnalyzerDriver.convertBytesToGB(avg.divide(new BigDecimal(numberOfConnections), 9, RoundingMode.HALF_UP)) + " GB");
            System.out.println("Max Flowfile Queue Size=" + maxQueueSize + "\nMin Flowfile Queue Size=" + minQueueSize + "\nAvg Flowfile Queue Size=" + new BigDecimal(totalQueueSize).divide(new BigDecimal(numberOfConnections), 9, RoundingMode.HALF_UP));
            ((InputStream)gzipStream).close();
            ((InputStream)fileStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception occurred while attempting to parse flow.xml.gz.  Cause: " + e.getCause());
        }
    }

    private static boolean helpRequested(String[] args) {
        return args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("--help");
    }

    public static BigDecimal convertSizeToByteValue(String value) {
        String numericValue;
        BigDecimal size = null;
        if (value.contains("GB")) {
            numericValue = value.substring(0, value.indexOf("G") - 1);
            size = new BigDecimal(numericValue).multiply(new BigDecimal(CONST_BYTES_GB_CONV));
        }
        if (value.contains("MB")) {
            numericValue = value.substring(0, value.indexOf("M") - 1);
            size = new BigDecimal(numericValue).multiply(new BigDecimal(CONST_BYTES_MB_CONV));
        }
        if (value.contains("KB")) {
            numericValue = value.substring(0, value.indexOf("K") - 1);
            size = new BigDecimal(numericValue).multiply(new BigDecimal(CONST_BYTES_KB_CONV));
        }
        return size;
    }

    public static BigDecimal convertBytesToGB(BigDecimal bytes) {
        return bytes.divide(new BigDecimal(CONST_BYTES_GB_CONV), 9, RoundingMode.HALF_UP).stripTrailingZeros();
    }
}

