/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.attributes;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DefaultRunDuration;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.documentation.UseCases;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.search.SearchContext;
import org.apache.nifi.search.SearchResult;
import org.apache.nifi.search.Searchable;
import org.apache.nifi.update.attributes.Action;
import org.apache.nifi.update.attributes.Condition;
import org.apache.nifi.update.attributes.Criteria;
import org.apache.nifi.update.attributes.FlowFilePolicy;
import org.apache.nifi.update.attributes.Rule;
import org.apache.nifi.update.attributes.serde.CriteriaSerDe;

@SideEffectFree
@SupportsBatching(defaultDuration=DefaultRunDuration.TWENTY_FIVE_MILLIS)
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"attributes", "modification", "update", "delete", "Attribute Expression Language", "state"})
@CapabilityDescription(value="Updates the Attributes for a FlowFile by using the Attribute Expression Language and/or deletes the attributes based on a regular expression")
@DynamicProperty(name="A FlowFile attribute to update", value="The value to set it to", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Updates a FlowFile attribute specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@WritesAttribute(attribute="See additional details", description="This processor may write or remove zero or more attributes as described in additional details")
@Stateful(scopes={Scope.LOCAL}, description="Gives the option to store values not only on the FlowFile but as stateful variables to be referenced in a recursive manner.")
@UseCases(value={@UseCase(description="Add a new FlowFile attribute", configuration="Leave \"Delete Attributes Expression\" and \"Stateful Variables Initial Value\" unset.\nSet \"Store State\" to \"Do not store state\".\n\nAdd a new property. The name of the property will become the name of the newly added attribute.\nThe value of the property will become the value of the newly added attribute. The value may use the NiFi Expression Language in order to reference other\nattributes or call Expression Language functions.\n"), @UseCase(description="Overwrite a FlowFile attribute with a new value", configuration="Leave \"Delete Attributes Expression\" and \"Stateful Variables Initial Value\" unset.\nSet \"Store State\" to \"Do not store state\".\n\nAdd a new property. The name of the property will become the name of the attribute whose value will be overwritten.\nThe value of the property will become the new value of the attribute. The value may use the NiFi Expression Language in order to reference other\nattributes or call Expression Language functions.\n\nFor example, to change the `txId` attribute to the uppercase version of its current value, add a property named `txId` with a value of `${txId:toUpper()}`\n"), @UseCase(description="Rename a file", configuration="Leave \"Delete Attributes Expression\" and \"Stateful Variables Initial Value\" unset.\nSet \"Store State\" to \"Do not store state\".\n\nAdd a new property whose name is `filename` and whose value is the desired filename.\n\nFor example, to set the filename to `abc.txt`, add a property named `filename` with a value of `abc.txt`.\nTo add the `txId` attribute as a prefix to the filename, add a property named `filename` with a value of `${txId}${filename}`.\nOr, to make the filename more readable, separate the txId from the rest of the filename with a hyphen by using a value of `${txId}-${filename}`.\n")})
public class UpdateAttribute
extends AbstractProcessor
implements Searchable {
    public static final String DO_NOT_STORE_STATE = "Do not store state";
    public static final String STORE_STATE_LOCALLY = "Store state locally";
    private final AtomicReference<Criteria> criteriaCache = new AtomicReference<Object>(null);
    private final ConcurrentMap<String, PropertyValue> propertyValues = new ConcurrentHashMap<String, PropertyValue>();
    private static final Set<Relationship> statelessRelationshipSet;
    private static final Set<Relationship> statefulRelationshipSet;
    private LoadingCache<String, String> canonicalValueLookup;
    public static final Relationship REL_SUCCESS;
    public static final Relationship REL_FAILED_SET_STATE;
    private volatile Set<Relationship> relationships = statelessRelationshipSet;
    private static final Validator DELETE_PROPERTY_VALIDATOR;
    public static final String DELETE_ATTRIBUTES_EXPRESSION_NAME = "Delete Attributes Expression";
    public static final PropertyDescriptor DELETE_ATTRIBUTES;
    public static final String STORE_STATE_NAME = "Store State";
    public static final PropertyDescriptor STORE_STATE;
    public static final String STATEFUL_VARIABLES_INIT_VALUE_NAME = "Stateful Variables Initial Value";
    public static final PropertyDescriptor STATEFUL_VARIABLES_INIT_VALUE;
    public static final PropertyDescriptor CANONICAL_VALUE_LOOKUP_CACHE_SIZE;
    private volatile Map<String, Action> defaultActions;
    private volatile boolean debugEnabled;
    private volatile boolean stateful = false;

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(DELETE_ATTRIBUTES);
        descriptors.add(STORE_STATE);
        descriptors.add(STATEFUL_VARIABLES_INIT_VALUE);
        descriptors.add(CANONICAL_VALUE_LOOKUP_CACHE_SIZE);
        return Collections.unmodifiableList(descriptors);
    }

    public boolean isStateful(ProcessContext context) {
        return !context.getProperty(STORE_STATE).getValue().equals(DO_NOT_STORE_STATE);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        super.onPropertyModified(descriptor, oldValue, newValue);
        if (descriptor.equals((Object)STORE_STATE)) {
            if (DO_NOT_STORE_STATE.equals(newValue)) {
                this.stateful = false;
                this.relationships = statelessRelationshipSet;
            } else {
                this.stateful = true;
                this.relationships = statefulRelationshipSet;
            }
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        int cacheSize = context.getProperty(CANONICAL_VALUE_LOOKUP_CACHE_SIZE).asInteger();
        this.canonicalValueLookup = Caffeine.newBuilder().maximumSize((long)cacheSize).build(attributeValue -> attributeValue);
        this.criteriaCache.set(CriteriaSerDe.deserialize((String)context.getAnnotationData()));
        this.propertyValues.clear();
        if (this.stateful) {
            StateManager stateManager = context.getStateManager();
            StateMap state = stateManager.getState(Scope.LOCAL);
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.putAll(state.toMap());
            String initValue = context.getProperty(STATEFUL_VARIABLES_INIT_VALUE).getValue();
            for (PropertyDescriptor entry : context.getProperties().keySet()) {
                if (!entry.isDynamic() || tempMap.containsKey(entry.getName())) continue;
                tempMap.put(entry.getName(), initValue);
            }
            Criteria criteria = this.criteriaCache.get();
            if (criteria != null) {
                for (Rule rule : criteria.getRules()) {
                    for (Action action : rule.getActions()) {
                        if (tempMap.containsKey(action.getAttribute())) continue;
                        tempMap.put(action.getAttribute(), initValue);
                    }
                }
            }
            context.getStateManager().setState(tempMap, Scope.LOCAL);
        }
        this.defaultActions = this.getDefaultActions(context.getProperties());
        this.debugEnabled = this.getLogger().isDebugEnabled();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        String initValue;
        ArrayList<ValidationResult> reasons = new ArrayList<ValidationResult>(super.customValidate(context));
        if (!context.getProperty(STORE_STATE).getValue().equals(DO_NOT_STORE_STATE) && (initValue = context.getProperty(STATEFUL_VARIABLES_INIT_VALUE).getValue()) == null) {
            reasons.add(new ValidationResult.Builder().subject(STATEFUL_VARIABLES_INIT_VALUE.getDisplayName()).valid(false).explanation("initial state value must be set if the processor is configured to store state.").build());
        }
        Criteria criteria = null;
        try {
            criteria = CriteriaSerDe.deserialize((String)context.getAnnotationData());
        }
        catch (IllegalArgumentException iae) {
            reasons.add(new ValidationResult.Builder().valid(false).explanation("Unable to deserialize the update criteria." + iae.getMessage()).build());
        }
        if (criteria != null) {
            List rules = criteria.getRules();
            if (rules == null) {
                reasons.add(new ValidationResult.Builder().valid(false).explanation("Update criteria has been specified by no rules were found.").build());
            } else {
                for (Rule rule : rules) {
                    Set conditions;
                    if (rule.getName() == null || rule.getName().trim().isEmpty()) {
                        reasons.add(new ValidationResult.Builder().valid(false).explanation("A rule name was not specified.").build());
                    }
                    if ((conditions = rule.getConditions()) == null) {
                        reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("No conditions for rule '%s' found.", rule.getName())).build());
                    } else {
                        for (Condition condition : conditions) {
                            if (condition.getExpression() == null) {
                                reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("No expression for a condition in rule '%s' was found.", rule.getName())).build());
                                continue;
                            }
                            String expression = condition.getExpression().trim();
                            reasons.add(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.BOOLEAN, (boolean)false).validate(String.format("Condition for rule '%s'.", rule.getName()), expression, context));
                        }
                    }
                    Set actions = rule.getActions();
                    if (actions == null) {
                        reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("No actions for rule '%s' found.", rule.getName())).build());
                        continue;
                    }
                    for (Action action : actions) {
                        if (action.getAttribute() == null) {
                            reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("An action in rule '%s' is missing the attribute name.", rule.getName())).build());
                            continue;
                        }
                        if (action.getValue() == null) {
                            reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("No value for attribute '%s' in rule '%s' was found.", action.getAttribute(), rule.getName())).build());
                            continue;
                        }
                        reasons.add(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true).validate(String.format("Action for rule '%s'.", rule.getName()), action.getValue(), context));
                    }
                }
            }
        }
        return reasons;
    }

    public Collection<SearchResult> search(SearchContext context) {
        String term = context.getSearchTerm();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if (StringUtils.isBlank((CharSequence)context.getAnnotationData())) {
            return results;
        }
        try {
            Criteria criteria = CriteriaSerDe.deserialize((String)context.getAnnotationData());
            if (criteria.getRules() != null) {
                FlowFilePolicy flowFilePolicy = criteria.getFlowFilePolicy();
                if (flowFilePolicy != null && StringUtils.containsIgnoreCase((CharSequence)flowFilePolicy.name(), (CharSequence)term)) {
                    results.add(new SearchResult.Builder().label("FlowFile policy").match(flowFilePolicy.name()).build());
                }
                for (Rule rule : criteria.getRules()) {
                    if (StringUtils.containsIgnoreCase((CharSequence)rule.getName(), (CharSequence)term)) {
                        results.add(new SearchResult.Builder().label("Rule name").match(rule.getName()).build());
                    }
                    if (rule.getConditions() != null) {
                        for (Condition condition : rule.getConditions()) {
                            if (!StringUtils.containsIgnoreCase((CharSequence)condition.getExpression(), (CharSequence)term)) continue;
                            results.add(new SearchResult.Builder().label(String.format("Condition in rule '%s'", rule.getName())).match(condition.getExpression()).build());
                        }
                    }
                    if (rule.getActions() == null) continue;
                    for (Action action : rule.getActions()) {
                        if (StringUtils.containsIgnoreCase((CharSequence)action.getAttribute(), (CharSequence)term)) {
                            results.add(new SearchResult.Builder().label(String.format("Action in rule '%s'", rule.getName())).match(action.getAttribute()).build());
                        }
                        if (!StringUtils.containsIgnoreCase((CharSequence)action.getValue(), (CharSequence)term)) continue;
                        results.add(new SearchResult.Builder().label(String.format("Action in rule '%s'", rule.getName())).match(action.getValue()).build());
                    }
                }
            }
            return results;
        }
        catch (Exception e) {
            return results;
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        HashMap<String, String> stateWorkingAttributes;
        Map stateInitialAttributes;
        ComponentLog logger = this.getLogger();
        Criteria criteria = this.criteriaCache.get();
        FlowFile incomingFlowFile = session.get();
        if (incomingFlowFile == null) {
            return;
        }
        HashMap<FlowFile, List<Rule>> matchedRules = new HashMap<FlowFile, List<Rule>>();
        StateMap stateMap = null;
        try {
            if (this.stateful) {
                stateMap = session.getState(Scope.LOCAL);
                stateInitialAttributes = stateMap.toMap();
                stateWorkingAttributes = new HashMap<String, String>(stateMap.toMap());
            } else {
                stateInitialAttributes = null;
                stateWorkingAttributes = null;
            }
        }
        catch (IOException e) {
            logger.error("Failed to get the initial state when processing {}; transferring FlowFile back to its incoming queue", new Object[]{incomingFlowFile, e});
            session.transfer(incomingFlowFile);
            context.yield();
            return;
        }
        Map<String, Action> defaultActions = this.defaultActions;
        LinkedList<FlowFile> flowFilesToTransfer = new LinkedList<FlowFile>();
        if (criteria != null && this.evaluateCriteria(session, context, criteria, incomingFlowFile, matchedRules, stateInitialAttributes)) {
            for (Map.Entry entry : matchedRules.entrySet()) {
                FlowFile match = (FlowFile)entry.getKey();
                List rules = (List)entry.getValue();
                boolean updateWorking = incomingFlowFile.equals((Object)match);
                match = this.executeActions(session, context, rules, defaultActions, match, stateInitialAttributes, stateWorkingAttributes);
                if (updateWorking) {
                    incomingFlowFile = match;
                }
                if (this.debugEnabled) {
                    logger.debug("Updated attributes for {}; transferring to '{}'", new Object[]{match, REL_SUCCESS.getName()});
                }
                flowFilesToTransfer.add(match);
            }
        } else {
            incomingFlowFile = this.executeActions(session, context, null, defaultActions, incomingFlowFile, stateInitialAttributes, stateWorkingAttributes);
            if (this.debugEnabled) {
                logger.debug("Updated attributes for {}; transferring to '{}'", new Object[]{incomingFlowFile, REL_SUCCESS.getName()});
            }
            flowFilesToTransfer.add(incomingFlowFile);
        }
        if (stateInitialAttributes != null) {
            try {
                boolean setState;
                if (!stateWorkingAttributes.equals(stateInitialAttributes) && !(setState = session.replaceState(stateMap, stateWorkingAttributes, Scope.LOCAL))) {
                    logger.warn("Failed to update the state after successfully processing {} due to having an old version of the StateMap. This is normally due to multiple threads running at once; transferring to '{}'", new Object[]{incomingFlowFile, REL_FAILED_SET_STATE.getName()});
                    flowFilesToTransfer.remove(incomingFlowFile);
                    if (flowFilesToTransfer.size() > 0) {
                        session.remove(flowFilesToTransfer);
                    }
                    session.transfer(incomingFlowFile, REL_FAILED_SET_STATE);
                    return;
                }
            }
            catch (IOException e) {
                logger.error("Failed to set the state after successfully processing {} due a failure when setting the state. This is normally due to multiple threads running at once; transferring to '{}'", new Object[]{incomingFlowFile, REL_FAILED_SET_STATE.getName(), e});
                flowFilesToTransfer.remove(incomingFlowFile);
                if (flowFilesToTransfer.size() > 0) {
                    session.remove(flowFilesToTransfer);
                }
                session.transfer(incomingFlowFile, REL_FAILED_SET_STATE);
                context.yield();
                return;
            }
        }
        for (FlowFile toTransfer : flowFilesToTransfer) {
            session.getProvenanceReporter().modifyAttributes(toTransfer);
        }
        session.transfer(flowFilesToTransfer, REL_SUCCESS);
    }

    private boolean evaluateCriteria(ProcessSession session, ProcessContext context, Criteria criteria, FlowFile flowfile, Map<FlowFile, List<Rule>> matchedRules, Map<String, String> statefulAttributes) {
        ComponentLog logger = this.getLogger();
        List rules = criteria.getRules();
        for (Rule rule : rules) {
            if (!this.evaluateRule(context, rule, flowfile, statefulAttributes)) continue;
            FlowFile flowfileToUse = FlowFilePolicy.USE_ORIGINAL.equals((Object)criteria.getFlowFilePolicy()) || matchedRules.isEmpty() ? flowfile : session.clone(flowfile);
            List<Rule> rulesForFlowFile = matchedRules.get(flowfileToUse);
            if (rulesForFlowFile == null) {
                rulesForFlowFile = new ArrayList<Rule>();
                matchedRules.put(flowfileToUse, rulesForFlowFile);
            }
            rulesForFlowFile.add(rule);
            if (!this.debugEnabled) continue;
            logger.debug(String.valueOf((Object)this) + " all conditions met for rule '" + rule.getName() + "'. Using flow file - " + String.valueOf(flowfileToUse));
        }
        return !matchedRules.isEmpty();
    }

    private boolean evaluateRule(ProcessContext context, Rule rule, FlowFile flowfile, Map<String, String> statefulAttributes) {
        for (Condition condition : rule.getConditions()) {
            if (this.evaluateCondition(context, condition, flowfile, statefulAttributes)) continue;
            return false;
        }
        return true;
    }

    private PropertyValue getPropertyValue(String text, ProcessContext context) {
        return this.propertyValues.computeIfAbsent(text, k -> context.newPropertyValue(text));
    }

    private boolean evaluateCondition(ProcessContext context, Condition condition, FlowFile flowfile, Map<String, String> statefulAttributes) {
        try {
            return this.getPropertyValue(condition.getExpression(), context).evaluateAttributeExpressions(flowfile, null, null, statefulAttributes).asBoolean();
        }
        catch (Exception e) {
            this.getLogger().error(String.format("Could not evaluate the condition '%s' while processing Flowfile '%s'", condition.getExpression(), flowfile));
            throw new ProcessException(String.format("Unable to evaluate condition '%s': %s.", condition.getExpression(), e), (Throwable)e);
        }
    }

    private FlowFile executeActions(ProcessSession session, ProcessContext context, List<Rule> rules, Map<String, Action> defaultActions, FlowFile flowfile, Map<String, String> stateInitialAttributes, Map<String, String> stateWorkingAttributes) {
        String ruleName;
        ComponentLog logger = this.getLogger();
        HashMap<String, Action> actions = new HashMap<String, Action>(defaultActions);
        String string = ruleName = rules == null || rules.isEmpty() ? "default" : rules.get(rules.size() - 1).getName();
        if (rules != null && rules.size() > 0) {
            for (Rule rule : rules) {
                for (Action action : rule.getActions()) {
                    actions.put(action.getAttribute(), action);
                }
            }
            Action matchedRuleAction = new Action();
            matchedRuleAction.setAttribute(((Object)((Object)this)).getClass().getSimpleName() + ".matchedRule");
            matchedRuleAction.setValue(ruleName);
            actions.put(matchedRuleAction.getAttribute(), matchedRuleAction);
        }
        HashMap<String, String> attributesToUpdate = new HashMap<String, String>(actions.size());
        HashSet<String> attributesToDelete = new HashSet<String>(actions.size());
        boolean debugEnabled = this.debugEnabled;
        for (Action action : actions.values()) {
            boolean setStatefulAttribute;
            String attribute = action.getAttribute();
            if (DELETE_ATTRIBUTES_EXPRESSION_NAME.equals(attribute)) {
                try {
                    String actionValue = action.getValue();
                    String regex = actionValue == null ? null : this.getPropertyValue(actionValue, context).evaluateAttributeExpressions(flowfile).getValue();
                    if (regex == null) continue;
                    Pattern pattern = Pattern.compile(regex);
                    Set attributeKeys = flowfile.getAttributes().keySet();
                    for (String key : attributeKeys) {
                        if (!pattern.matcher(key).matches()) continue;
                        if (debugEnabled) {
                            logger.debug(String.format("%s deleting attribute '%s' for %s per regex '%s'.", new Object[]{this, key, flowfile, regex}));
                        }
                        attributesToDelete.add(key);
                    }
                    attributesToUpdate.keySet().removeAll(attributesToDelete);
                    continue;
                }
                catch (Exception e) {
                    logger.error(String.format("Unable to delete attribute '%s' while processing FlowFile '%s' .", attribute, flowfile));
                    throw new ProcessException(String.format("Unable to delete attribute '%s': %s.", attribute, e), (Throwable)e);
                }
            }
            boolean notDeleted = !attributesToDelete.contains(attribute);
            boolean bl = setStatefulAttribute = stateInitialAttributes != null && !attribute.equals("UpdateAttribute.matchedRule");
            if (!notDeleted && !setStatefulAttribute) continue;
            try {
                String newAttributeValue = this.getPropertyValue(action.getValue(), context).evaluateAttributeExpressions(flowfile, null, null, stateInitialAttributes).getValue();
                newAttributeValue = (String)this.canonicalValueLookup.get((Object)newAttributeValue);
                if (debugEnabled) {
                    logger.debug(String.format("%s setting attribute '%s' = '%s' for %s per rule '%s'.", new Object[]{this, attribute, newAttributeValue, flowfile, ruleName}));
                }
                if (setStatefulAttribute) {
                    stateWorkingAttributes.put(attribute, newAttributeValue);
                }
                if (!notDeleted) continue;
                attributesToUpdate.put(attribute, newAttributeValue);
            }
            catch (Exception e) {
                logger.error(String.format("Could not evaluate the FlowFile '%s' against expression '%s' defined by DynamicProperty '%s' due to '%s'", flowfile, action.getValue(), attribute, e.getLocalizedMessage()));
                throw new ProcessException(String.format("Unable to evaluate new value for attribute '%s': %s.", attribute, e), (Throwable)e);
            }
        }
        String alternateIdentifierAdd = (String)attributesToUpdate.get(CoreAttributes.ALTERNATE_IDENTIFIER.key());
        if (alternateIdentifierAdd != null) {
            try {
                URI uri = new URI(alternateIdentifierAdd);
                String namespace = uri.getScheme();
                if (namespace != null) {
                    String identifier = alternateIdentifierAdd.substring(Math.min(namespace.length() + 1, alternateIdentifierAdd.length() - 1));
                    session.getProvenanceReporter().associate(flowfile, namespace, identifier);
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        FlowFile returnFlowfile = flowfile;
        if (attributesToUpdate.size() > 0) {
            returnFlowfile = session.putAllAttributes(returnFlowfile, attributesToUpdate);
        }
        if (attributesToDelete.size() > 0) {
            returnFlowfile = session.removeAllAttributes(returnFlowfile, attributesToDelete);
        }
        return returnFlowfile;
    }

    private Map<String, Action> getDefaultActions(Map<PropertyDescriptor, String> properties) {
        HashMap<String, Action> defaultActions = new HashMap<String, Action>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            if (entry.getKey() == STORE_STATE || entry.getKey() == STATEFUL_VARIABLES_INIT_VALUE || entry.getKey() == CANONICAL_VALUE_LOOKUP_CACHE_SIZE) continue;
            Action action = new Action();
            action.setAttribute(entry.getKey().getName());
            action.setValue(entry.getValue());
            defaultActions.put(action.getAttribute(), action);
        }
        return defaultActions;
    }

    static {
        REL_SUCCESS = new Relationship.Builder().description("All successful FlowFiles are routed to this relationship").name("success").build();
        REL_FAILED_SET_STATE = new Relationship.Builder().description("A failure to set the state after adding the attributes to the FlowFile will route the FlowFile here.").name("set state fail").build();
        HashSet<Relationship> tempStatelessSet = new HashSet<Relationship>();
        tempStatelessSet.add(REL_SUCCESS);
        statelessRelationshipSet = Collections.unmodifiableSet(tempStatelessSet);
        HashSet<Relationship> tempStatefulSet = new HashSet<Relationship>();
        tempStatefulSet.add(REL_SUCCESS);
        tempStatefulSet.add(REL_FAILED_SET_STATE);
        statefulRelationshipSet = Collections.unmodifiableSet(tempStatefulSet);
        DELETE_PROPERTY_VALIDATOR = new Validator(){
            private final Validator DPV_RE_VALIDATOR = StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true);

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    AttributeExpression.ResultType resultType = context.newExpressionLanguageCompiler().getResultType(input);
                    if (!resultType.equals((Object)AttributeExpression.ResultType.STRING)) {
                        return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Expected property to to return type " + String.valueOf(AttributeExpression.ResultType.STRING) + " but expression returns type " + String.valueOf(resultType)).build();
                    }
                    return new ValidationResult.Builder().subject(subject).input(input).valid(true).explanation("Property returns type " + String.valueOf(AttributeExpression.ResultType.STRING)).build();
                }
                return this.DPV_RE_VALIDATOR.validate(subject, input, context);
            }
        };
        DELETE_ATTRIBUTES = new PropertyDescriptor.Builder().name(DELETE_ATTRIBUTES_EXPRESSION_NAME).displayName(DELETE_ATTRIBUTES_EXPRESSION_NAME).description("Regular expression for attributes to be deleted from FlowFiles.  Existing attributes that match will be deleted regardless of whether they are updated by this processor.").required(false).addValidator(DELETE_PROPERTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        STORE_STATE = new PropertyDescriptor.Builder().name(STORE_STATE_NAME).displayName(STORE_STATE_NAME).description("Select whether or not state will be stored. Selecting 'Stateless' will offer the default functionality of purely updating the attributes on a FlowFile in a stateless manner. Selecting a stateful option will not only store the attributes on the FlowFile but also in the Processors state. See the 'Stateful Usage' topic of the 'Additional Details' section of this processor's documentation for more information").required(true).allowableValues(new String[]{DO_NOT_STORE_STATE, STORE_STATE_LOCALLY}).defaultValue(DO_NOT_STORE_STATE).build();
        STATEFUL_VARIABLES_INIT_VALUE = new PropertyDescriptor.Builder().name(STATEFUL_VARIABLES_INIT_VALUE_NAME).displayName(STATEFUL_VARIABLES_INIT_VALUE_NAME).description("If using state to set/reference variables then this value is used to set the initial value of the stateful variable. This will only be used in the @OnScheduled method when state does not contain a value for the variable. This is required if running statefully but can be empty if needed.").required(false).addValidator(Validator.VALID).build();
        CANONICAL_VALUE_LOOKUP_CACHE_SIZE = new PropertyDescriptor.Builder().name("canonical-value-lookup-cache-size").displayName("Cache Value Lookup Cache Size").description("Specifies how many canonical lookup values should be stored in the cache").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("100").required(true).build();
    }
}

