/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.ContentAccess;
import org.apache.nifi.web.ContentRequestContext;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.ViewableContent;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

public class ContentViewerController
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ContentViewerController.class);
    private static final int BUFFER_LENGTH = 1536;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ViewableContent.DisplayMode displayMode;
        DownloadableContent downloadableContent;
        ContentRequestContext contentRequest;
        response.addHeader("Content-Type", "text/html; charset=UTF-8");
        ServletContext servletContext = request.getServletContext();
        ContentAccess contentAccess = (ContentAccess)servletContext.getAttribute("nifi-content-access");
        try {
            contentRequest = this.getContentRequest(request);
        }
        catch (Exception e) {
            request.setAttribute("title", (Object)"Error");
            request.setAttribute("messages", (Object)"Unable to interpret content request.");
            ServletContext viewerContext = servletContext.getContext("/nifi");
            viewerContext.getRequestDispatcher("/message").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (contentRequest.getDataUri() == null) {
            request.setAttribute("title", (Object)"Error");
            request.setAttribute("messages", (Object)"The data reference must be specified.");
            ServletContext viewerContext = servletContext.getContext("/nifi");
            viewerContext.getRequestDispatcher("/message").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            downloadableContent = contentAccess.getContent(contentRequest);
        }
        catch (ResourceNotFoundException rnfe) {
            request.setAttribute("title", (Object)"Error");
            request.setAttribute("messages", (Object)"Unable to find the specified content");
            ServletContext viewerContext = servletContext.getContext("/nifi");
            viewerContext.getRequestDispatcher("/message").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (AccessDeniedException ade) {
            request.setAttribute("title", (Object)"Acess Denied");
            request.setAttribute("messages", (Object)("Unable to approve access to the specified content: " + ade.getMessage()));
            ServletContext viewerContext = servletContext.getContext("/nifi");
            viewerContext.getRequestDispatcher("/message").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (Exception e) {
            request.setAttribute("title", (Object)"Error");
            request.setAttribute("messages", (Object)("An unexcepted error has occurred: " + e.getMessage()));
            ServletContext viewerContext = servletContext.getContext("/nifi");
            viewerContext.getRequestDispatcher("/message").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = ViewableContent.DisplayMode.Original.name();
        }
        try {
            displayMode = ViewableContent.DisplayMode.valueOf((String)mode);
        }
        catch (IllegalArgumentException iae) {
            request.setAttribute("title", (Object)"Error");
            request.setAttribute("messages", (Object)("Invalid display mode: " + mode));
            ServletContext viewerContext = servletContext.getContext("/nifi");
            viewerContext.getRequestDispatcher("/message").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try (BufferedInputStream bis = new BufferedInputStream(downloadableContent.getContent());){
            String mimeType;
            if (downloadableContent.getType() == null || StringUtils.startsWithIgnoreCase((CharSequence)downloadableContent.getType(), (CharSequence)MediaType.OCTET_STREAM.toString())) {
                DefaultDetector detector = new DefaultDetector();
                TikaInputStream tikaStream = TikaInputStream.get((InputStream)bis);
                Metadata metadata = new Metadata();
                metadata.set("resourceName", downloadableContent.getFilename());
                MediaType mediatype = detector.detect((InputStream)tikaStream, metadata);
                mimeType = mediatype.toString();
            } else {
                mimeType = downloadableContent.getType();
            }
            String normalizedMimeType = mimeType.split(";", 2)[0].toLowerCase();
            request.setAttribute("filename", (Object)downloadableContent.getFilename());
            request.setAttribute("contentType", (Object)mimeType);
            request.getRequestDispatcher("/WEB-INF/jsp/header.jsp").include((ServletRequest)request, (ServletResponse)response);
            request.removeAttribute("filename");
            request.removeAttribute("contentType");
            if (ViewableContent.DisplayMode.Hex.equals((Object)displayMode)) {
                byte[] buffer = new byte[1536];
                int read = StreamUtils.fillBuffer((InputStream)bis, (byte[])buffer, (boolean)false);
                byte[] bytes = buffer;
                if (read != buffer.length) {
                    bytes = new byte[read];
                    System.arraycopy(buffer, 0, bytes, 0, read);
                }
                String base64 = Base64.encodeBase64String((byte[])bytes);
                request.setAttribute("content", (Object)base64);
                request.getRequestDispatcher("/WEB-INF/jsp/hexview.jsp").include((ServletRequest)request, (ServletResponse)response);
            } else {
                String contentViewerUri = servletContext.getInitParameter(normalizedMimeType);
                if (contentViewerUri == null) {
                    request.getRequestDispatcher("/WEB-INF/jsp/no-viewer.jsp").include((ServletRequest)request, (ServletResponse)response);
                } else {
                    request.setAttribute("org.apache.nifi.web.content", (Object)new /* Unavailable Anonymous Inner Class!! */);
                    try {
                        ServletContext viewerContext = servletContext.getContext(contentViewerUri);
                        viewerContext.getRequestDispatcher("/view-content").include((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (Exception e) {
                        String message = e.getMessage() != null ? e.getMessage() : e.toString();
                        message = "Unable to generate view of data: " + message;
                        logger.error(message);
                        if (logger.isDebugEnabled()) {
                            logger.error("", (Throwable)e);
                        }
                        request.setAttribute("title", (Object)"Error");
                        request.setAttribute("messages", (Object)message);
                        ServletContext viewerContext = servletContext.getContext("/nifi");
                        viewerContext.getRequestDispatcher("/message").forward((ServletRequest)request, (ServletResponse)response);
                        if (bis != null) {
                            if (var10_21 != null) {
                                try {
                                    bis.close();
                                }
                                catch (Throwable throwable) {
                                    var10_21.addSuppressed(throwable);
                                }
                            } else {
                                bis.close();
                            }
                        }
                        return;
                    }
                    request.removeAttribute("org.apache.nifi.web.content");
                }
            }
            request.getRequestDispatcher("/WEB-INF/jsp/footer.jsp").include((ServletRequest)request, (ServletResponse)response);
        }
    }

    private ContentRequestContext getContentRequest(HttpServletRequest request) {
        String ref = request.getParameter("ref");
        String clientId = request.getParameter("clientId");
        String proxiedEntitiesChain = request.getHeader("X-ProxiedEntitiesChain");
        URI refUri = URI.create(ref);
        String query = refUri.getQuery();
        String rawClusterNodeId = null;
        if (query != null) {
            String[] queryParameters = query.split("&");
            for (int i = 0; i < queryParameters.length; ++i) {
                if (!queryParameters[0].startsWith("clusterNodeId=")) continue;
                rawClusterNodeId = StringUtils.substringAfterLast((String)queryParameters[0], (String)"clusterNodeId=");
            }
        }
        String clusterNodeId = rawClusterNodeId;
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

