/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.nifi.cluster.context.ClusterContext;
import org.apache.nifi.cluster.context.ClusterContextThreadLocal;
import org.apache.nifi.web.ConfigurationRequest;
import org.apache.nifi.web.ConfigurationResult;
import org.apache.nifi.web.ConfigurationSnapshot;
import org.apache.nifi.web.FlowModification;
import org.apache.nifi.web.InvalidRevisionException;
import org.apache.nifi.web.OptimisticLockingManager;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UpdateRevision;
import org.apache.nifi.web.security.user.NiFiUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardOptimisticLockingManager
implements OptimisticLockingManager {
    private static final Logger logger = LoggerFactory.getLogger(StandardOptimisticLockingManager.class);
    private static final String INVALID_REVISION_ERROR = "Given revision %s does not match current revision %s.";
    private static final String SYNC_ERROR = "This NiFi instance has been updated by '%s'. Please refresh to synchronize the view.";
    private Revision currentRevision = new Revision(Long.valueOf(0L), "");
    private String lastModifier = "unknown";
    private final Lock lock = new ReentrantLock();

    private void lock() {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }

    private void checkRevision(Revision revision) {
        FlowModification lastMod = this.getLastModification();
        boolean approved = lastMod.getRevision().equals((Object)revision);
        if (!approved) {
            logger.debug("Revision check failed because current revision is " + lastMod.getRevision() + " but supplied revision is " + revision);
            if (lastMod.getRevision().getClientId() == null || lastMod.getRevision().getClientId().trim().isEmpty() || lastMod.getRevision().getVersion() == null) {
                throw new InvalidRevisionException(String.format(INVALID_REVISION_ERROR, revision, lastMod.getRevision()));
            }
            throw new InvalidRevisionException(String.format(SYNC_ERROR, lastMod.getLastModifier()));
        }
    }

    private Revision updateRevision(Revision updatedRevision) {
        this.setLastModification(new FlowModification(updatedRevision, NiFiUserUtils.getNiFiUserName()));
        return updatedRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ConfigurationSnapshot<T> configureFlow(Revision revision, ConfigurationRequest<T> configurationRequest) {
        this.lock();
        try {
            this.checkRevision(revision);
            ConfigurationResult<T> result = configurationRequest.execute();
            Revision newRevision = this.updateRevision(this.incrementRevision(revision.getClientId()));
            ConfigurationSnapshot<T> configurationSnapshot = new ConfigurationSnapshot<T>(newRevision.getVersion(), result.getConfiguration(), result.isNew());
            return configurationSnapshot;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void setRevision(UpdateRevision updateRevision) {
        this.lock();
        try {
            Revision updatedRevision = updateRevision.execute(this.getLastModification().getRevision());
            if (updatedRevision != null) {
                this.updateRevision(updatedRevision);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowModification getLastModification() {
        this.lock();
        try {
            ClusterContext ctx = ClusterContextThreadLocal.getContext();
            Revision revision = ctx == null || ctx.getRevision() == null ? this.currentRevision : ctx.getRevision();
            FlowModification flowModification = new FlowModification(revision, this.lastModifier);
            return flowModification;
        }
        finally {
            this.unlock();
        }
    }

    private void setLastModification(FlowModification lastModification) {
        this.lock();
        try {
            this.lastModifier = lastModification.getLastModifier();
            ClusterContext ctx = ClusterContextThreadLocal.getContext();
            if (ctx != null) {
                ctx.setRevision(lastModification.getRevision());
            } else {
                this.currentRevision = lastModification.getRevision();
            }
        }
        finally {
            this.unlock();
        }
    }

    private Revision incrementRevision(String clientId) {
        Revision current = this.getLastModification().getRevision();
        long incrementedVersion = current.getVersion() == null ? 0L : current.getVersion() + 1L;
        return new Revision(Long.valueOf(incrementedVersion), clientId);
    }
}

