/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.naming.Context;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.BaseUrlHelper;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.api.internal.Internal;
import org.apache.openejb.api.jmx.Description;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.api.jmx.ManagedAttribute;
import org.apache.openejb.api.jmx.ManagedOperation;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.rest.ThreadLocalContextManager;
import org.apache.openejb.server.cxf.rs.AutoJAXRSInvoker;
import org.apache.openejb.server.cxf.rs.Logs;
import org.apache.openejb.server.cxf.rs.NoopResourceProvider;
import org.apache.openejb.server.cxf.rs.OpenEJBEJBInvoker;
import org.apache.openejb.server.cxf.rs.OpenEJBPerRequestPojoResourceProvider;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.rest.EJBRestServiceInfo;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.ProxyEJB;
import org.apache.webbeans.config.WebBeansContext;

public class CxfRsHttpListener
implements RsHttpListener {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_RS, CxfRsHttpListener.class);
    private static final java.util.logging.Logger SERVER_IMPL_LOGGER = LogUtils.getL7dLogger(ServerImpl.class);
    public static final String CXF_JAXRS_PREFIX = "cxf.jaxrs.";
    public static final String PROVIDERS_KEY = "cxf.jaxrs.providers";
    public static final String STATIC_RESOURCE_KEY = "cxf.jaxrs.static-resources-list";
    public static final String STATIC_SUB_RESOURCE_RESOLUTION_KEY = "staticSubresourceResolution";
    public static final String RESOURCE_COMPARATOR_KEY = "cxf.jaxrs.resourceComparator";
    private static final String GLOBAL_PROVIDERS = SystemInstance.get().getProperty("cxf.jaxrs.providers");
    private static final Map<String, String> STATIC_CONTENT_TYPES = new HashMap<String, String>();
    private final HTTPTransportFactory transportFactory;
    private final String wildcard;
    private AbstractHTTPDestination destination;
    private Server server;
    private String context = "";
    private Collection<Pattern> staticResourcesList = new CopyOnWriteArrayList<Pattern>();
    private List<ObjectName> jmxNames = new ArrayList<ObjectName>();

    public CxfRsHttpListener(HTTPTransportFactory httpTransportFactory, String star) {
        this.transportFactory = httpTransportFactory;
        this.wildcard = star;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(final HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        String baseURL;
        if (this.matchPath((HttpServletRequest)httpRequest)) {
            this.serveStaticContent((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, httpRequest.getPathInfo());
            return;
        }
        if (httpRequest instanceof HttpRequestImpl) {
            ((HttpRequestImpl)httpRequest).initPathFromContext(this.context);
        }
        if (!(baseURL = BaseUrlHelper.getBaseURL((HttpServletRequest)httpRequest)).endsWith("/")) {
            baseURL = baseURL + "/";
        }
        httpRequest.setAttribute("org.apache.cxf.transport.endpoint.address", (Object)baseURL);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            this.destination.invoke(null, httpRequest.getServletContext(), (HttpServletRequest)new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                public String getRequestURI() {
                    if (httpRequest instanceof HttpRequestImpl) {
                        return CxfRsHttpListener.this.strip(CxfRsHttpListener.this.context, ((HttpRequestImpl)httpRequest).requestRawPath());
                    }
                    return CxfRsHttpListener.this.strip(CxfRsHttpListener.this.context, super.getRequestURI());
                }
            }, (HttpServletResponse)httpResponse);
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    private boolean matchPath(HttpServletRequest request) {
        if (this.staticResourcesList.isEmpty()) {
            return false;
        }
        String path = request.getPathInfo();
        if (path == null) {
            path = "/";
        }
        for (Pattern pattern : this.staticResourcesList) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    protected void serveStaticContent(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        InputStream is = request.getServletContext().getResourceAsStream(pathInfo);
        if (is == null) {
            throw new ServletException("Static resource " + pathInfo + " is not available");
        }
        try {
            String type;
            int ind = pathInfo.lastIndexOf(".");
            if (ind != -1 && ind < pathInfo.length() && (type = STATIC_CONTENT_TYPES.get(pathInfo.substring(ind + 1))) != null) {
                response.setContentType(type);
            }
            ServletOutputStream os = response.getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.flush();
        }
        catch (IOException ex) {
            throw new ServletException("Static resource " + pathInfo + " can not be written to the output stream");
        }
    }

    private String strip(String context, String requestURI) {
        if (requestURI.startsWith(context)) {
            return requestURI.substring(context.length());
        }
        return requestURI;
    }

    public void deploySingleton(String contextRoot, String fullContext, Object o, Application appInstance, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        this.deploy(contextRoot, o.getClass(), fullContext, (ResourceProvider)new SingletonResourceProvider(o), o, appInstance, null, additionalProviders, configuration);
    }

    public void deployPojo(ClassLoader loader, String contextRoot, String fullContext, Class<?> loadedClazz, Application app, Collection<Injection> injections, Context context, WebBeansContext owbCtx, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        this.deploy(contextRoot, loadedClazz, fullContext, new OpenEJBPerRequestPojoResourceProvider(loader, loadedClazz, injections, context, owbCtx), null, app, null, additionalProviders, configuration);
    }

    public void deployEJB(String contextRoot, String fullContext, BeanContext beanContext, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        Object proxy = ProxyEJB.subclassProxy((BeanContext)beanContext);
        this.deploy(contextRoot, beanContext.getBeanClass(), fullContext, new NoopResourceProvider(beanContext.getBeanClass(), proxy), proxy, null, (Invoker)new OpenEJBEJBInvoker(Collections.singleton(beanContext)), additionalProviders, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(String contextRoot, Class<?> clazz, String address, ResourceProvider rp, Object serviceBean, Application app, Invoker invoker, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            JAXRSServerFactoryBean factory = this.newFactory(address);
            this.configureFactory(additionalProviders, configuration, factory);
            factory.setResourceClasses(new Class[]{clazz});
            this.context = contextRoot;
            if (this.context == null) {
                this.context = "";
            }
            if (!this.context.startsWith("/")) {
                this.context = "/" + this.context;
            }
            if (rp != null) {
                factory.setResourceProvider(rp);
            }
            if (app != null) {
                factory.setApplication(app);
            }
            if (invoker != null) {
                factory.setInvoker(invoker);
            }
            if (serviceBean != null) {
                factory.setServiceBean(serviceBean);
            } else {
                factory.setServiceClass(clazz);
            }
            this.server = factory.create();
            this.destination = (AbstractHTTPDestination)this.server.getDestination();
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    private Collection<Object> providers(Collection<ServiceInfo> services, Collection<Object> additionalProviders) {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (Object o : additionalProviders) {
            if (o instanceof Class) {
                Class clazz = (Class)o;
                List instance = ServiceInfos.resolve(services, (String[])new String[]{clazz.getName()}, (ServiceInfos.Factory)ProviderFactory.INSTANCE);
                if (instance != null && !instance.isEmpty()) {
                    instances.add(instance.iterator().next());
                    continue;
                }
                try {
                    instances.add(this.newProvider(clazz));
                }
                catch (Exception e) {
                    LOGGER.error("can't instantiate " + clazz.getName(), (Throwable)e);
                }
                continue;
            }
            instances.add(o);
        }
        return instances;
    }

    private Object newProvider(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        for (ObjectName objectName : this.jmxNames) {
            LocalMBeanServer.unregisterSilently((ObjectName)objectName);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            this.server.stop();
        }
        catch (RuntimeException ise) {
            LOGGER.warning("Can't stop correctly the endpoint " + this.server);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(ise.getMessage(), (Throwable)ise);
            }
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void deployApplication(Application application, String prefix, String webContext, Collection<Object> additionalProviders, Map<String, EJBRestServiceInfo> restEjbs, ClassLoader classLoader, Collection<Injection> injections, Context context, WebBeansContext owbCtx, ServiceConfiguration serviceConfiguration) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            void var15_23;
            JAXRSServerFactoryBean factory = this.newFactory(prefix);
            this.configureFactory(additionalProviders, serviceConfiguration, factory);
            factory.setApplication(application);
            ArrayList classes = new ArrayList();
            for (Class clazz : application.getClasses()) {
                if (additionalProviders.contains(clazz) || clazz.isInterface()) continue;
                classes.add(clazz);
            }
            for (Object e : application.getSingletons()) {
                if (additionalProviders.contains(e)) continue;
                Class<?> clazz = e.getClass();
                classes.add(clazz);
            }
            for (Class clazz : classes) {
                String name = clazz.getName();
                if (restEjbs.containsKey(name)) {
                    BeanContext bc = restEjbs.get((Object)name).context;
                    Object proxy = ProxyEJB.subclassProxy((BeanContext)bc);
                    factory.setResourceProvider(clazz, (ResourceProvider)new NoopResourceProvider(bc.getBeanClass(), proxy));
                    continue;
                }
                factory.setResourceProvider(clazz, (ResourceProvider)new OpenEJBPerRequestPojoResourceProvider(classLoader, clazz, injections, context, owbCtx));
            }
            factory.setResourceClasses(classes);
            factory.setInvoker((Invoker)new AutoJAXRSInvoker(restEjbs));
            Level level = SERVER_IMPL_LOGGER.getLevel();
            SERVER_IMPL_LOGGER.setLevel(Level.OFF);
            try {
                this.server = factory.create();
            }
            finally {
                SERVER_IMPL_LOGGER.setLevel(level);
            }
            this.context = webContext;
            if (!webContext.startsWith("/")) {
                this.context = "/" + webContext;
            }
            this.destination = (AbstractHTTPDestination)this.server.getDestination();
            if (prefix.endsWith("/")) {
                String string = prefix.substring(0, prefix.length() - 1);
            } else if (prefix.endsWith(this.wildcard)) {
                String string = prefix.substring(0, prefix.length() - this.wildcard.length());
            } else {
                String string = prefix;
            }
            this.logEndpoints(application, prefix, restEjbs, factory, (String)var15_23);
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    private void logEndpoints(Application application, String prefix, Map<String, EJBRestServiceInfo> restEjbs, JAXRSServerFactoryBean factory, String base) {
        ArrayList<Logs.LogResourceEndpointInfo> resourcesToLog = new ArrayList<Logs.LogResourceEndpointInfo>();
        int classSize = 0;
        int addressSize = 0;
        JAXRSServiceImpl service = (JAXRSServiceImpl)factory.getServiceFactory().getService();
        List resources = service.getClassResourceInfos();
        for (ClassResourceInfo info : resources) {
            if (info.getResourceClass() == null) continue;
            String address = Logs.singleSlash(base, info.getURITemplate().getValue());
            String clazz = info.getResourceClass().getName();
            String type = restEjbs.containsKey(clazz) ? "EJB" : "Pojo";
            classSize = Math.max(classSize, clazz.length());
            addressSize = Math.max(addressSize, address.length());
            int methodSize = 7;
            int methodStrSize = 0;
            ArrayList<Logs.LogOperationEndpointInfo> toLog = new ArrayList<Logs.LogOperationEndpointInfo>();
            MethodDispatcher md = info.getMethodDispatcher();
            for (OperationResourceInfo ori : md.getOperationResourceInfos()) {
                String httpMethod = ori.getHttpMethod();
                String currentAddress = Logs.singleSlash(address, ori.getURITemplate().getValue());
                String methodToStr = Logs.toSimpleString(ori.getMethodToInvoke());
                toLog.add(new Logs.LogOperationEndpointInfo(httpMethod, currentAddress, methodToStr));
                if (httpMethod != null) {
                    methodSize = Math.max(methodSize, httpMethod.length());
                }
                addressSize = Math.max(addressSize, currentAddress.length());
                methodStrSize = Math.max(methodStrSize, methodToStr.length());
            }
            Collections.sort(toLog);
            resourcesToLog.add(new Logs.LogResourceEndpointInfo(type, address, clazz, toLog, methodSize, methodStrSize));
        }
        LOGGER.info("REST Application: " + Logs.forceLength(prefix, addressSize, true) + " -> " + application.getClass().getName());
        Collections.sort(resourcesToLog);
        for (Logs.LogResourceEndpointInfo resource : resourcesToLog) {
            ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management").set("j2eeType", "JAX-RS").set("J2EEServer", "openejb").set("J2EEApplication", base).set("EndpointType", resource.type).set("name", resource.classname);
            ObjectName jmxObjectName = jmxName.build();
            LocalMBeanServer.registerDynamicWrapperSilently((Object)new RestServiceMBean(resource), (ObjectName)jmxObjectName);
            this.jmxNames.add(jmxObjectName);
            LOGGER.info("     Service URI: " + Logs.forceLength(resource.address, addressSize, true) + " -> " + Logs.forceLength(resource.type, 4, false) + " " + Logs.forceLength(resource.classname, classSize, true));
            for (Logs.LogOperationEndpointInfo log : resource.operations) {
                LOGGER.info("          " + Logs.forceLength(log.http, resource.methodSize, false) + " " + Logs.forceLength(log.address, addressSize, true) + " ->      " + Logs.forceLength(log.method, resource.methodStrSize, true));
            }
            resource.operations.clear();
        }
        resourcesToLog.clear();
    }

    private JAXRSServerFactoryBean newFactory(String prefix) {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setDestinationFactory((DestinationFactory)this.transportFactory);
        factory.setBus(this.transportFactory.getBus());
        factory.setAddress(prefix);
        return factory;
    }

    private void configureFactory(Collection<Object> additionalProviders, ServiceConfiguration serviceConfiguration, JAXRSServerFactoryBean factory) {
        String staticResources;
        String resourceComparator;
        CxfUtil.configureEndpoint((AbstractEndpointFactory)factory, (ServiceConfiguration)serviceConfiguration, (String)CXF_JAXRS_PREFIX);
        Collection services = serviceConfiguration.getAvailableServices();
        String staticSubresourceResolution = serviceConfiguration.getProperties().getProperty("cxf.jaxrs.staticSubresourceResolution");
        if (staticSubresourceResolution != null) {
            factory.setStaticSubresourceResolution("true".equalsIgnoreCase(staticSubresourceResolution));
        }
        if ((resourceComparator = serviceConfiguration.getProperties().getProperty(RESOURCE_COMPARATOR_KEY)) != null) {
            try {
                ResourceComparator instance = (ResourceComparator)ServiceInfos.resolve((Collection)services, (String)resourceComparator);
                if (instance == null) {
                    instance = (ResourceComparator)Thread.currentThread().getContextClassLoader().loadClass(resourceComparator).newInstance();
                }
                factory.setResourceComparator(instance);
            }
            catch (Exception e) {
                LOGGER.error("Can't create the resource comparator " + resourceComparator, (Throwable)e);
            }
        }
        if ((staticResources = serviceConfiguration.getProperties().getProperty(STATIC_RESOURCE_KEY)) != null) {
            String[] resources;
            for (String r : resources = staticResources.split(",")) {
                String trimmed = r.trim();
                if (trimmed.isEmpty()) continue;
                this.staticResourcesList.add(Pattern.compile(trimmed));
            }
        }
        HashSet<String> providersConfig = null;
        String provider = serviceConfiguration.getProperties().getProperty(PROVIDERS_KEY);
        if (provider != null) {
            providersConfig = new HashSet<String>();
            providersConfig.addAll(Arrays.asList(provider.split(",")));
        }
        if (GLOBAL_PROVIDERS != null) {
            if (providersConfig == null) {
                providersConfig = new HashSet();
            }
            providersConfig.addAll(Arrays.asList(GLOBAL_PROVIDERS.split(",")));
        }
        List<Object> providers = null;
        if (providersConfig != null) {
            providers = ServiceInfos.resolve((Collection)services, (String[])providersConfig.toArray(new String[providersConfig.size()]), (ServiceInfos.Factory)ProviderFactory.INSTANCE);
            if (providers != null && additionalProviders != null && !additionalProviders.isEmpty()) {
                providers.addAll(this.providers(services, additionalProviders));
            }
            factory.setProviders(providers);
        }
        if (providers == null) {
            providers = new ArrayList<Object>();
            if (additionalProviders != null && !additionalProviders.isEmpty()) {
                providers.addAll(this.providers(services, additionalProviders));
            } else {
                providers.addAll(CxfRsHttpListener.defaultProviders());
            }
            factory.setProviders(providers);
        } else {
            LOGGER.info("Using providers " + providers);
        }
    }

    private static List<Object> defaultProviders() {
        JAXBElementProvider jaxb = new JAXBElementProvider();
        HashMap<String, Boolean> jaxbProperties = new HashMap<String, Boolean>();
        jaxbProperties.put("jaxb.fragment", true);
        jaxb.setMarshallerProperties(jaxbProperties);
        JSONProvider json = new JSONProvider();
        return Arrays.asList(jaxb, json);
    }

    static {
        STATIC_CONTENT_TYPES.put("html", "text/html");
        STATIC_CONTENT_TYPES.put("xhtml", "text/html");
        STATIC_CONTENT_TYPES.put("txt", "text/plain");
        STATIC_CONTENT_TYPES.put("css", "text/css");
        STATIC_CONTENT_TYPES.put("jpg", "image/jpg");
        STATIC_CONTENT_TYPES.put("png", "image/png");
        STATIC_CONTENT_TYPES.put("ico", "image/ico");
        STATIC_CONTENT_TYPES.put("pdf", "application/pdf");
        STATIC_CONTENT_TYPES.put("xsd", "application/xml");
        if ("true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.cxf-rs.wadl-generator.ignoreMessageWriters", "false"))) {
            for (ProviderInfo rh : org.apache.cxf.jaxrs.provider.ProviderFactory.getSharedInstance().getRequestHandlers()) {
                RequestHandler provider = (RequestHandler)rh.getProvider();
                if (!WadlGenerator.class.isInstance(provider)) continue;
                ((WadlGenerator)WadlGenerator.class.cast(provider)).setIgnoreMessageWriters(false);
            }
        }
    }

    @MBean
    @Internal
    @Description(value="JAX-RS service information")
    public class RestServiceMBean {
        private String type;
        private String address;
        private String classname;
        private TabularData operations;

        public RestServiceMBean(Logs.LogResourceEndpointInfo jmxName) {
            this.type = jmxName.type;
            this.address = jmxName.address;
            this.classname = jmxName.classname;
            String[] names = new String[jmxName.operations.size()];
            Object[] values = new String[jmxName.operations.size()];
            int idx = 0;
            for (Logs.LogOperationEndpointInfo operation : jmxName.operations) {
                names[idx] = operation.http + " " + operation.address;
                values[idx] = operation.method;
                ++idx;
            }
            this.operations = LocalMBeanServer.tabularData((String)"Operations", (String)"Operations for this endpoint", (String[])names, (Object[])values);
        }

        @ManagedAttribute
        @Description(value="The type of the REST service")
        public String getWadlUrl() {
            if (this.address.endsWith("?_wadl")) {
                return this.address;
            }
            return this.address + "?_wadl";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ManagedOperation
        @Description(value="The type of the REST service")
        public String getWadl(String format) {
            if (format != null && format.toLowerCase().contains("json")) {
                InputStream inputStream = null;
                try {
                    URL url = new URL(this.getWadlUrl() + "&_type=json");
                    HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
                    connection.setRequestProperty("Accept", "application/json");
                    connection.setRequestProperty("Content-type", "application/json");
                    inputStream = connection.getInputStream();
                    String string = IO.slurp((InputStream)inputStream);
                    IO.close((Closeable)inputStream);
                    return string;
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    return string;
                }
                finally {
                    IO.close(inputStream);
                }
            }
            try {
                return IO.slurp((URL)new URL(this.getWadlUrl()));
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }

        @ManagedAttribute
        @Description(value="The type of the REST service")
        public String getType() {
            return this.type;
        }

        @ManagedAttribute
        @Description(value="The REST service address")
        public String getAddress() {
            return this.address;
        }

        @ManagedAttribute
        @Description(value="The REST service class name")
        public String getClassname() {
            return this.classname;
        }

        @ManagedAttribute
        @Description(value="All available methods")
        public TabularData getOperations() {
            return this.operations;
        }
    }

    private static class ProviderFactory
    implements ServiceInfos.Factory {
        private static final ServiceInfos.Factory INSTANCE = new ProviderFactory();

        private ProviderFactory() {
        }

        public Object newInstance(Class<?> clazz) throws Exception {
            boolean found = false;
            Object instance = null;
            for (Constructor<?> c : clazz.getConstructors()) {
                int contextAnnotations = 0;
                Annotation[][] arr$ = c.getParameterAnnotations();
                int len$ = arr$.length;
                block1: for (int i$ = 0; i$ < len$; ++i$) {
                    Annotation[] annotations;
                    for (Annotation a : annotations = arr$[i$]) {
                        if (!javax.ws.rs.core.Context.class.equals(a.annotationType())) continue;
                        ++contextAnnotations;
                        continue block1;
                    }
                }
                if (contextAnnotations != c.getParameterTypes().length) continue;
                if (found) {
                    LOGGER.warning("Found multiple matching constructor for " + clazz.getName());
                    return instance;
                }
                Object[] params = new Object[c.getParameterTypes().length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = ThreadLocalContextManager.findThreadLocal(c.getParameterTypes()[i]);
                }
                instance = c.newInstance(params);
                found = true;
            }
            if (instance != null) {
                return instance;
            }
            return clazz.newInstance();
        }
    }
}

