/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.server.cxf.rs.Contexts;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.util.WebBeansUtil;

public class OpenEJBPerRequestPojoResourceProvider
implements ResourceProvider {
    protected final Collection<Injection> injections;
    protected final Context context;
    protected final WebBeansContext webbeansContext;
    protected final Constructor<?> constructor;
    protected final Method postConstructMethod;
    protected final Method preDestroyMethod;
    protected final ClassLoader classLoader;
    private BeanCreator creator;
    private final Collection<Class<?>> contextTypes = new HashSet();

    public OpenEJBPerRequestPojoResourceProvider(ClassLoader loader, Class<?> clazz, Collection<Injection> injectionCollection, Context initialContext, WebBeansContext owbCtx) {
        Bean bean;
        this.injections = injectionCollection;
        this.webbeansContext = owbCtx;
        this.classLoader = loader;
        this.context = (Context)Proxy.newProxyInstance(this.classLoader, new Class[]{Context.class}, (InvocationHandler)new InitialContextWrapper(initialContext));
        this.constructor = ResourceUtils.findResourceConstructor(clazz, (boolean)true);
        if (this.constructor == null) {
            throw new RuntimeException("Resource class " + clazz + " has no valid constructor");
        }
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(clazz);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(clazz);
        BeanManagerImpl bm = this.webbeansContext.getBeanManagerImpl();
        if (bm.isInUse()) {
            try {
                Set beans = bm.getBeans(clazz, new Annotation[0]);
                bean = bm.resolve(beans);
            }
            catch (InjectionException ie) {
                String msg = "Resource class " + this.constructor.getDeclaringClass().getName() + " can not be instantiated";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            if (bean instanceof InjectionTargetBean) {
                InterceptorResolutionService.BeanInterceptorInfo info = ((InjectionTargetImpl)InjectionTargetImpl.class.cast(((InjectionTargetBean)InjectionTargetBean.class.cast(bean)).getInjectionTarget())).getInterceptorInfo();
                for (Interceptor interceptor : info.getCdiInterceptors()) {
                    if (interceptor == null || interceptor.getBeanClass() == null) continue;
                    Contexts.findContextFields(interceptor.getBeanClass(), this.contextTypes);
                }
                for (Interceptor interceptor : info.getEjbInterceptors()) {
                    if (interceptor == null || interceptor.getBeanClass() == null) continue;
                    Contexts.findContextFields(interceptor.getBeanClass(), this.contextTypes);
                }
                for (Decorator decorator : info.getDecorators()) {
                    if (decorator == null || decorator.getBeanClass() == null) continue;
                    Contexts.findContextFields(decorator.getBeanClass(), this.contextTypes);
                }
            }
        } else {
            bean = null;
        }
        Contexts.findContextFields(clazz, this.contextTypes);
        this.creator = bean != null ? new CdiBeanCreator((BeanManager)bm, bean) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInstance(Message m) {
        Contexts.bind(m.getExchange(), this.contextTypes);
        if (this.creator == null) {
            this.creator = new DefaultBeanCreator(m);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Object object = this.creator.create();
            return object;
        }
        catch (NoBeanFoundException nbfe) {
            this.creator = new DefaultBeanCreator(m);
            Object object = this.creator.create();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public void releaseInstance(Message m, Object o) {
        if (this.creator != null) {
            this.creator.release();
        }
    }

    public Class<?> getResourceClass() {
        return this.constructor.getDeclaringClass();
    }

    public boolean isSingleton() {
        return false;
    }

    private static class NoBeanFoundException
    extends RuntimeException {
        public NoBeanFoundException(String name) {
            super(name);
        }
    }

    private class DefaultBeanCreator
    implements BeanCreator {
        private Message m;
        private InjectionProcessor<?> injector;
        private CreationalContext creationalContext;
        private Object instance;

        public DefaultBeanCreator(Message m) {
            this.m = m;
        }

        @Override
        public Object create() {
            Object[] values = ResourceUtils.createConstructorArguments(OpenEJBPerRequestPojoResourceProvider.this.constructor, (Message)this.m);
            try {
                this.instance = OpenEJBPerRequestPojoResourceProvider.this.constructor.newInstance(values);
                this.injector = new InjectionProcessor(this.instance, new ArrayList<Injection>(OpenEJBPerRequestPojoResourceProvider.this.injections), InjectionProcessor.unwrap((Context)OpenEJBPerRequestPojoResourceProvider.this.context));
                this.instance = this.injector.createInstance();
                BeanManagerImpl bm = OpenEJBPerRequestPojoResourceProvider.this.webbeansContext.getBeanManagerImpl();
                this.creationalContext = bm.createCreationalContext(null);
                try {
                    OWBInjector.inject((BeanManager)bm, (Object)this.instance, (CreationalContext)this.creationalContext);
                }
                catch (Exception e) {
                    // empty catch block
                }
                InjectionUtils.invokeLifeCycleMethod((Object)this.instance, (Method)OpenEJBPerRequestPojoResourceProvider.this.postConstructMethod);
                return this.instance;
            }
            catch (InstantiationException ex) {
                String msg = "Resource class " + OpenEJBPerRequestPojoResourceProvider.this.constructor.getDeclaringClass().getName() + " can not be instantiated";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            catch (IllegalAccessException ex) {
                String msg = "Resource class " + OpenEJBPerRequestPojoResourceProvider.this.constructor.getDeclaringClass().getName() + " can not be instantiated" + " due to IllegalAccessException";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            catch (InvocationTargetException ex) {
                String msg = "Resource class " + OpenEJBPerRequestPojoResourceProvider.this.constructor.getDeclaringClass().getName() + " can not be instantiated" + " due to InvocationTargetException";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            catch (OpenEJBException e) {
                String msg = "An error occured injecting in class " + OpenEJBPerRequestPojoResourceProvider.this.constructor.getDeclaringClass().getName();
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            try {
                InjectionUtils.invokeLifeCycleMethod((Object)this.instance, (Method)OpenEJBPerRequestPojoResourceProvider.this.preDestroyMethod);
            }
            finally {
                if (this.injector != null) {
                    this.injector.preDestroy();
                }
                if (this.creationalContext != null) {
                    this.creationalContext.release();
                }
            }
        }
    }

    private class CdiBeanCreator
    implements BeanCreator {
        private final BeanManager bm;
        private final Bean<?> bean;
        private CreationalContext<?> toClean;

        public CdiBeanCreator(BeanManager bm, Bean<?> bean) {
            this.bm = bm;
            this.bean = bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object create() {
            Object object;
            this.toClean = this.bm.createCreationalContext(this.bean);
            try {
                object = this.bm.getReference(this.bean, (Type)this.bean.getBeanClass(), this.toClean);
            }
            catch (Throwable throwable) {
                try {
                    if (!WebBeansUtil.isDependent(this.bean)) {
                        this.toClean = null;
                    }
                    throw throwable;
                }
                catch (InjectionException ie) {
                    String msg = "Resource class " + OpenEJBPerRequestPojoResourceProvider.this.constructor.getDeclaringClass().getName() + " can not be instantiated";
                    throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
                }
            }
            if (!WebBeansUtil.isDependent(this.bean)) {
                this.toClean = null;
            }
            return object;
        }

        @Override
        public void release() {
            if (this.toClean != null) {
                this.toClean.release();
            }
        }
    }

    private static interface BeanCreator {
        public Object create();

        public void release();
    }

    private static class InitialContextWrapper
    implements InvocationHandler {
        private Context ctx;

        public InitialContextWrapper(Context initialContext) {
            this.ctx = initialContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("lookup")) {
                String name = "java:" + (String)String.class.cast(args[0]);
                if (args[0].getClass().equals(String.class)) {
                    if (this.ctx != null) {
                        try {
                            return this.ctx.lookup(name);
                        }
                        catch (Exception ne) {
                            try {
                                return this.ctx.lookup((String)String.class.cast(args[0]));
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                    }
                    InitialContext initialContext = new InitialContext();
                    try {
                        return initialContext.lookup(name);
                    }
                    catch (Exception swallowed) {
                        try {
                            return initialContext.lookup((String)String.class.cast(args[0]));
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                }
            }
            return method.invoke((Object)this.ctx, args);
        }
    }
}

