/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.spi.FailOverService;

public class EndWebBeansListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener,
HttpSessionActivationListener {
    static final ThreadLocal<Boolean> FAKE_REQUEST = new ThreadLocal();
    private final String contextKey;
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_CDI, EndWebBeansListener.class);
    protected FailOverService failoverService;
    protected WebBeansContext webBeansContext;

    public EndWebBeansListener(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        if (webBeansContext != null) {
            this.failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
            this.contextKey = "org.apache.tomee.catalina.WebBeansListener@" + webBeansContext.hashCode();
        } else {
            this.contextKey = "notused";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        if (this.webBeansContext == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying a request : [{0}]", new Object[]{event == null ? "null" : event.getServletRequest().getRemoteAddr()});
        }
        Object oldContext = event != null ? event.getServletRequest().getAttribute(this.contextKey) : null;
        try {
            ELContextStore elStore;
            HttpServletRequest httpRequest;
            HttpSession session;
            ServletRequest request;
            if (event != null && this.failoverService != null && this.failoverService.isSupportFailOver() && (request = event.getServletRequest()) instanceof HttpServletRequest && (session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
                this.failoverService.sessionIsIdle(session);
            }
            if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
                elStore.destroyELContextStore();
            }
            this.webBeansContext.getContextsService().endContext(RequestScoped.class, (Object)event);
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().endContext(RequestScoped.class, (Object)event);
            }
        }
        finally {
            ThreadSingletonServiceImpl.enter((WebBeansContext)((WebBeansContext)oldContext));
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.webBeansContext == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying a session with session id : [{0}]", new Object[]{event.getSession().getId()});
        }
        this.webBeansContext.getContextsService().startContext(SessionScoped.class, (Object)event.getSession());
        this.webBeansContext.getContextsService().endContext(SessionScoped.class, (Object)event.getSession());
        if (WebappWebBeansContext.class.isInstance(this.webBeansContext)) {
            ((WebappWebBeansContext)WebappWebBeansContext.class.cast(this.webBeansContext)).getParent().getContextsService().endContext(SessionScoped.class, (Object)event.getSession());
        }
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        Map cc = conversationManager.getAndRemoveConversationMapWithSessionId(event.getSession().getId());
        for (ConversationContext c : cc.values()) {
            if (c == null) continue;
            c.destroy();
        }
        this.destroyFakedRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyFakedRequest() {
        Boolean faked = FAKE_REQUEST.get();
        try {
            if (faked != null && faked.booleanValue()) {
                this.requestDestroyed(null);
            }
        }
        finally {
            FAKE_REQUEST.remove();
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (this.webBeansContext == null) {
            return;
        }
        if (this.failoverService != null && this.failoverService.isSupportPassivation()) {
            this.failoverService.sessionWillPassivate(event.getSession());
        }
        this.destroyFakedRequest();
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.destroyFakedRequest();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.destroyFakedRequest();
    }
}

