/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.BeginWebBeansListener;
import org.apache.openejb.server.httpd.EndWebBeansListener;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.HttpServerFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;

public class OpenEJBHttpRegistry {
    public static final Logger log = Logger.getInstance((LogCategory)LogCategory.HTTPSERVER, OpenEJBHttpRegistry.class);
    protected final HttpListenerRegistry registry;
    protected final List<URI> baseUris = new ArrayList<URI>();

    public OpenEJBHttpRegistry() {
        try {
            OpenEjbConfiguration configuration = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
            for (ServiceInfo service : configuration.facilities.services) {
                if (!service.className.equals(HttpServerFactory.class.getName())) continue;
                int port = Integer.parseInt(service.properties.getProperty("port"));
                String ip = service.properties.getProperty("bind");
                if ("0.0.0.0".equals(ip)) {
                    InetAddress[] addresses;
                    for (InetAddress address : addresses = InetAddress.getAllByName(ip)) {
                        this.baseUris.add(new URI("http", null, address.getHostAddress(), port, null, null, null));
                    }
                } else {
                    this.baseUris.add(new URI("http", null, ip, port, null, null, null));
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Unable to build base URIs for " + this.getClass().getSimpleName() + " registry", (Throwable)e);
        }
        this.registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
    }

    public HttpListener addWrappedHttpListener(HttpListener httpListener, ClassLoader classLoader, String regex) {
        ClassLoaderHttpListener listener = new ClassLoaderHttpListener(httpListener, classLoader);
        this.registry.addHttpListener(listener, regex);
        return listener;
    }

    public List<String> getResolvedAddresses(String path) {
        String suffix = path;
        if (!path.startsWith("/")) {
            suffix = '/' + suffix;
        }
        ArrayList<String> addresses = new ArrayList<String>();
        for (URI baseUri : this.baseUris) {
            URI address = baseUri.resolve(suffix);
            addresses.add(address.toString());
        }
        return addresses;
    }

    protected static class ClassLoaderHttpListener
    implements HttpListener {
        private final HttpListener delegate;
        private final ClassLoader classLoader;

        protected ClassLoaderHttpListener(HttpListener delegate, ClassLoader classLoader) {
            this.delegate = delegate;
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                if (request instanceof HttpRequestImpl) {
                    ClassLoaderHttpListener.initCdi((HttpRequestImpl)request).init();
                }
                this.delegate.onMessage(request, response);
            }
            finally {
                if (request instanceof HttpRequestImpl) {
                    ((HttpRequestImpl)request).destroy();
                }
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        private static HttpRequestImpl initCdi(HttpRequestImpl request) {
            try {
                WebBeansContext context = WebBeansContext.currentInstance();
                if (context.getBeanManagerImpl().isInUse()) {
                    request.setBeginListener(new BeginWebBeansListener(context));
                    request.setEndListener(new EndWebBeansListener(context));
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return request;
        }

        public HttpListener getDelegate() {
            return this.delegate;
        }
    }
}

