/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.EjbInterceptorBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorComparator;
import org.apache.webbeans.intercept.annotation.Priority;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;

public class InterceptorsManager {
    private final WebBeansContext webBeansContext;
    private final BeanManagerImpl beanManager;
    private List<Class<?>> configuredInterceptorClasses = new CopyOnWriteArrayList();
    private List<Interceptor<?>> cdiInterceptors = new ArrayList();
    private ConcurrentHashMap<Class<?>, Interceptor<?>> ejbInterceptors = new ConcurrentHashMap();
    private List<Class<?>> additionalInterceptorClasses = new ArrayList();
    private Map<Class<? extends Annotation>, Set<Annotation>> additionalInterceptorBindingTypes = new HashMap<Class<? extends Annotation>, Set<Annotation>>();

    public InterceptorsManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanManager = webBeansContext.getBeanManagerImpl();
    }

    public void clear() {
        this.additionalInterceptorBindingTypes.clear();
        this.additionalInterceptorClasses.clear();
        this.configuredInterceptorClasses.clear();
        this.cdiInterceptors.clear();
        this.ejbInterceptors.clear();
    }

    public void addEnabledInterceptorClass(Class<?> interceptorClazz) {
        Asserts.nullCheckForClass(interceptorClazz, "interceptorClazz can not be null");
        if (!this.configuredInterceptorClasses.contains(interceptorClazz)) {
            this.configuredInterceptorClasses.add(interceptorClazz);
        }
    }

    public <T> Interceptor<T> getEjbInterceptorForClass(Class<T> interceptorClass) {
        Object interceptor = this.ejbInterceptors.get(interceptorClass);
        if (interceptor == null) {
            AnnotatedType<T> annotatedType = this.webBeansContext.getBeanManagerImpl().createAnnotatedType(interceptorClass);
            BeanAttributesImpl<T> beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedType).build();
            EjbInterceptorBeanBuilder<T> buildr = new EjbInterceptorBeanBuilder<T>(this.webBeansContext, annotatedType, beanAttributes);
            buildr.defineEjbInterceptorRules();
            Object i = buildr.getBean();
            interceptor = this.ejbInterceptors.putIfAbsent(interceptorClass, (Interceptor<?>)i);
            if (interceptor == null) {
                interceptor = i;
            }
        }
        return interceptor;
    }

    public int compareCdiInterceptors(Class<?> src, Class<?> target) {
        Asserts.assertNotNull(src, "src parameter can not be  null");
        Asserts.assertNotNull(target, "target parameter can not be null");
        int srcIndex = this.configuredInterceptorClasses.indexOf(src);
        if (srcIndex == -1) {
            throw new IllegalArgumentException(src.getName() + " is not an enabled interceptor!");
        }
        int targetIndex = this.configuredInterceptorClasses.indexOf(target);
        if (targetIndex == -1) {
            throw new IllegalArgumentException(target.getName() + " is not an enabled interceptor!");
        }
        Priority p1 = src.getAnnotation(Priority.class);
        Priority p2 = target.getAnnotation(Priority.class);
        if (p1 != null && p2 != null) {
            return p1.value() - p2.value();
        }
        if (p1 == null && p2 != null) {
            return -1;
        }
        if (p1 != null) {
            return 1;
        }
        if (srcIndex == targetIndex) {
            return 0;
        }
        if (srcIndex < targetIndex) {
            return -1;
        }
        return 1;
    }

    public boolean isInterceptorClassEnabled(Class<?> interceptorClazz) {
        Asserts.nullCheckForClass(interceptorClazz, "interceptorClazz can not be null");
        return this.configuredInterceptorClasses.contains(interceptorClazz);
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        ArrayList interceptorList = new ArrayList();
        for (Interceptor<?> interceptor : this.cdiInterceptors) {
            if (!interceptor.intercepts(type) || !this.intercepts(interceptor, interceptorBindings)) continue;
            interceptorList.add(interceptor);
        }
        Collections.sort(interceptorList, new InterceptorComparator(this.webBeansContext));
        return interceptorList;
    }

    private boolean intercepts(Interceptor<?> interceptor, Annotation[] requestedInterceptorBindings) {
        for (Annotation interceptorBinding : interceptor.getInterceptorBindings()) {
            if (this.inBindingArray(interceptorBinding, requestedInterceptorBindings)) continue;
            return false;
        }
        return true;
    }

    private boolean inBindingArray(Annotation interceptorBinding, Annotation[] requestedInterceptorBindings) {
        for (Annotation requestedBinding : requestedInterceptorBindings) {
            if (!AnnotationUtil.isCdiAnnotationEqual(requestedBinding, interceptorBinding)) continue;
            return true;
        }
        return false;
    }

    public void addCdiInterceptor(Interceptor interceptor) {
        OwbBean owbBean;
        this.cdiInterceptors.add(interceptor);
        if (interceptor instanceof PassivationCapable && (owbBean = (OwbBean)interceptor).isPassivationCapable()) {
            this.beanManager.addPassivationInfo((Bean<?>)interceptor);
        }
    }

    public List<Interceptor<?>> getCdiInterceptors() {
        return this.cdiInterceptors;
    }

    public void addCustomInterceptorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        this.additionalInterceptorClasses.add(clazz);
    }

    public boolean containsCustomInterceptorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return this.additionalInterceptorClasses.contains(clazz);
    }

    public void addInterceptorBindingType(Class<? extends Annotation> bindingType, Annotation ... inheritsArray) {
        Set<Annotation> inherits = this.additionalInterceptorBindingTypes.get(bindingType);
        if (inherits == null) {
            inherits = new HashSet<Annotation>();
            this.additionalInterceptorBindingTypes.put(bindingType, inherits);
        }
        for (Annotation ann : inheritsArray) {
            inherits.add(ann);
        }
    }

    public boolean hasInterceptorBindingType(Class<? extends Annotation> bindingType) {
        return this.additionalInterceptorBindingTypes.keySet().contains(bindingType);
    }

    public void validateInterceptorClasses() {
        for (Class<?> interceptorClass : this.configuredInterceptorClasses) {
            AnnotatedType<?> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(interceptorClass);
            if (annotatedType.isAnnotationPresent(javax.interceptor.Interceptor.class) || this.containsCustomInterceptorClass(interceptorClass)) continue;
            throw new WebBeansConfigurationException("Given class : " + interceptorClass + " is not a interceptor class");
        }
    }
}

