/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCMessageStore;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCTopicMessageStore
extends JDBCMessageStore
implements TopicMessageStore {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCTopicMessageStore.class);
    private Map<String, LastRecovered> subscriberLastRecoveredMap = new ConcurrentHashMap<String, LastRecovered>();
    private Set<String> pendingCompletion = new HashSet<String>();
    public static final String PROPERTY_SEQUENCE_ID_CACHE_SIZE = "org.apache.activemq.store.jdbc.SEQUENCE_ID_CACHE_SIZE";
    private static final int SEQUENCE_ID_CACHE_SIZE = Integer.parseInt(System.getProperty("org.apache.activemq.store.jdbc.SEQUENCE_ID_CACHE_SIZE", "1000"), 10);
    private final ReentrantReadWriteLock sequenceIdCacheSizeLock = new ReentrantReadWriteLock();
    private Map<MessageId, long[]> sequenceIdCache = new LinkedHashMap<MessageId, long[]>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<MessageId, long[]> eldest) {
            return this.size() > SEQUENCE_ID_CACHE_SIZE;
        }
    };

    public JDBCTopicMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, ActiveMQTopic topic, ActiveMQMessageAudit audit) throws IOException {
        super(persistenceAdapter, adapter, wireFormat, (ActiveMQDestination)topic, audit);
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
        if (ack != null && ack.isUnmatchedAck()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("ignoring unmatched selector ack for: " + messageId + ", cleanup will get to this message after subsequent acks.");
            }
            return;
        }
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            long[] res = this.getCachedStoreSequenceId(c, this.destination, messageId);
            if (this.isPrioritizedMessages()) {
                this.adapter.doSetLastAckWithPriority(c, this.destination, context != null ? context.getXid() : null, clientId, subscriptionName, res[0], res[1]);
            } else {
                this.adapter.doSetLastAck(c, this.destination, context != null ? context.getXid() : null, clientId, subscriptionName, res[0], res[1]);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(clientId + ":" + subscriptionName + " ack, seq: " + res[0] + ", priority: " + res[1] + " mid:" + messageId);
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to store acknowledgment for: " + clientId + " on message " + messageId + " in container: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getCachedStoreSequenceId(TransactionContext transactionContext, ActiveMQDestination destination, MessageId messageId) throws SQLException, IOException {
        long[] val = null;
        this.sequenceIdCacheSizeLock.readLock().lock();
        try {
            val = this.sequenceIdCache.get(messageId);
        }
        finally {
            this.sequenceIdCacheSizeLock.readLock().unlock();
        }
        if (val == null) {
            val = this.adapter.getStoreSequenceId(transactionContext, destination, messageId);
        }
        return val;
    }

    public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doRecoverSubscription(c, this.destination, clientId, subscriptionName, new JDBCMessageRecoveryListener(){

                @Override
                public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    return listener.recoverMessage(msg);
                }

                @Override
                public boolean recoverMessageReference(String reference) throws Exception {
                    return listener.recoverMessageReference(new MessageId(reference));
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to recover subscription: " + clientId + ". Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recoverNextMessages(String clientId, String subscriptionName, int maxReturned, MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        if (!this.subscriberLastRecoveredMap.containsKey(key)) {
            this.subscriberLastRecoveredMap.put(key, new LastRecovered());
        }
        LastRecovered lastRecovered = this.subscriberLastRecoveredMap.get(key);
        LastRecoveredAwareListener recoveredAwareListener = new LastRecoveredAwareListener(listener, maxReturned);
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)((Object)this) + ", " + key + " existing last recovered: " + lastRecovered);
            }
            if (this.isPrioritizedMessages()) {
                Iterator<LastRecoveredEntry> it = lastRecovered.iterator();
                while (it.hasNext() && !recoveredAwareListener.complete()) {
                    LastRecoveredEntry entry = it.next();
                    recoveredAwareListener.setLastRecovered(entry);
                    this.adapter.doRecoverNextMessagesWithPriority(c, this.destination, clientId, subscriptionName, entry.recovered, entry.priority, maxReturned, recoveredAwareListener);
                    if (!recoveredAwareListener.stalled()) continue;
                    if (!recoveredAwareListener.complete()) {
                        entry.exhausted();
                        continue;
                    }
                    break;
                }
            } else {
                LastRecoveredEntry last = lastRecovered.defaultPriority();
                recoveredAwareListener.setLastRecovered(last);
                this.adapter.doRecoverNextMessages(c, this.destination, clientId, subscriptionName, last.recovered, 0L, maxReturned, recoveredAwareListener);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(key + " last recovered: " + lastRecovered);
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
        }
        finally {
            c.close();
        }
    }

    public void resetBatching(String clientId, String subscriptionName) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        if (!this.pendingCompletion.contains(key)) {
            this.subscriberLastRecoveredMap.remove(key);
        } else {
            LOG.trace((Object)((Object)this) + ", skip resetBatch during pending completion for: " + key);
        }
    }

    public void pendingCompletion(String clientId, String subscriptionName, long sequenceId, byte priority) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        LastRecovered recovered = new LastRecovered();
        recovered.perPriority[this.isPrioritizedMessages() ? priority : 4].recovered = sequenceId;
        this.subscriberLastRecoveredMap.put(key, recovered);
        this.pendingCompletion.add(key);
        LOG.trace((Object)((Object)this) + ", pending completion: " + key + ", last: " + recovered);
    }

    public void complete(String clientId, String subscriptionName) {
        this.pendingCompletion.remove(this.getSubscriptionKey(clientId, subscriptionName));
        LOG.trace((Object)((Object)this) + ", completion for: " + this.getSubscriptionKey(clientId, subscriptionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onAdd(MessageId messageId, long sequenceId, byte priority) {
        for (LastRecovered last : this.subscriberLastRecoveredMap.values()) {
            last.updateStored(sequenceId, priority);
        }
        this.sequenceIdCacheSizeLock.writeLock().lock();
        try {
            this.sequenceIdCache.put(messageId, new long[]{sequenceId, priority});
        }
        finally {
            this.sequenceIdCacheSizeLock.writeLock().unlock();
        }
    }

    public void addSubsciption(SubscriptionInfo subscriptionInfo, boolean retroactive) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            this.adapter.doSetSubscriberEntry(c, subscriptionInfo, retroactive, this.isPrioritizedMessages());
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to lookup subscription for info: " + subscriptionInfo.getClientId() + ". Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            SubscriptionInfo subscriptionInfo = this.adapter.doGetSubscriberEntry(c, this.destination, clientId, subscriptionName);
            return subscriptionInfo;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to lookup subscription for: " + clientId + ". Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doDeleteSubscription(c, this.destination, clientId, subscriptionName);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to remove subscription for: " + clientId + ". Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
            this.resetBatching(clientId, subscriptionName);
        }
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            SubscriptionInfo[] subscriptionInfoArray = this.adapter.doGetAllSubscriptions(c, this.destination);
            return subscriptionInfoArray;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to lookup subscriptions. Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        int result = 0;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            result = this.adapter.doGetDurableSubscriberMessageCount(c, this.destination, clientId, subscriberName, this.isPrioritizedMessages());
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to get Message Count: " + clientId + ". Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(clientId + ":" + subscriberName + ", messageCount: " + result);
        }
        return result;
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        String result = clientId + ":";
        result = result + (subscriberName != null ? subscriberName : "NOT_SET");
        return result;
    }

    class LastRecoveredAwareListener
    implements JDBCMessageRecoveryListener {
        final MessageRecoveryListener delegate;
        final int maxMessages;
        LastRecoveredEntry lastRecovered;
        int recoveredCount;
        int recoveredMarker;

        public LastRecoveredAwareListener(MessageRecoveryListener delegate, int maxMessages) {
            this.delegate = delegate;
            this.maxMessages = maxMessages;
        }

        @Override
        public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
            if (this.delegate.hasSpace() && this.recoveredCount < this.maxMessages) {
                Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                msg.getMessageId().setBrokerSequenceId(sequenceId);
                this.lastRecovered.recovered = sequenceId;
                if (this.delegate.recoverMessage(msg)) {
                    ++this.recoveredCount;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean recoverMessageReference(String reference) throws Exception {
            return this.delegate.recoverMessageReference(new MessageId(reference));
        }

        public void setLastRecovered(LastRecoveredEntry lastRecovered) {
            this.lastRecovered = lastRecovered;
            this.recoveredMarker = this.recoveredCount;
        }

        public boolean complete() {
            return !this.delegate.hasSpace() || this.recoveredCount == this.maxMessages;
        }

        public boolean stalled() {
            return this.recoveredMarker == this.recoveredCount;
        }
    }

    private class LastRecoveredEntry {
        final int priority;
        long recovered = 0L;
        long stored = Integer.MAX_VALUE;

        public LastRecoveredEntry(int priority) {
            this.priority = priority;
        }

        public String toString() {
            return this.priority + "-" + this.stored + ":" + this.recovered;
        }

        public void exhausted() {
            this.stored = this.recovered;
        }

        public boolean hasMessages() {
            return this.stored > this.recovered;
        }
    }

    private class LastRecovered
    implements Iterable<LastRecoveredEntry> {
        LastRecoveredEntry[] perPriority = new LastRecoveredEntry[10];

        LastRecovered() {
            for (int i = 0; i < this.perPriority.length; ++i) {
                this.perPriority[i] = new LastRecoveredEntry(i);
            }
        }

        public void updateStored(long sequence, int priority) {
            this.perPriority[priority].stored = sequence;
        }

        public LastRecoveredEntry defaultPriority() {
            return this.perPriority[4];
        }

        public String toString() {
            return Arrays.deepToString(this.perPriority);
        }

        @Override
        public Iterator<LastRecoveredEntry> iterator() {
            return new PriorityIterator();
        }

        class PriorityIterator
        implements Iterator<LastRecoveredEntry> {
            int current = 9;

            PriorityIterator() {
            }

            @Override
            public boolean hasNext() {
                for (int i = this.current; i >= 0; --i) {
                    if (!LastRecovered.this.perPriority[i].hasMessages()) continue;
                    this.current = i;
                    return true;
                }
                return false;
            }

            @Override
            public LastRecoveredEntry next() {
                return LastRecovered.this.perPriority[this.current];
            }

            @Override
            public void remove() {
                throw new RuntimeException("not implemented");
            }
        }
    }
}

