/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.cdi.UpdatableSessionContextManager;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SingletonContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ConversationService;
import org.apache.webbeans.web.context.ServletRequestContext;
import org.apache.webbeans.web.intercept.RequestScopedBeanInterceptorHandler;

public class CdiAppContextsService
extends AbstractContextsService
implements ContextsService {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB.createChild("cdi"), CdiAppContextsService.class);
    private final ThreadLocal<RequestContext> requestContext = new ThreadLocal();
    private final ThreadLocal<SessionContext> sessionContext = new ThreadLocal();
    private final UpdatableSessionContextManager sessionCtxManager = new UpdatableSessionContextManager();
    private final ThreadLocal<ConversationContext> conversationContext;
    private final DependentContext dependentContext = new DependentContext();
    private final ApplicationContext applicationContext = new ApplicationContext();
    private final SingletonContext singletonContext = new SingletonContext();
    private final WebBeansContext webBeansContext;
    private static final ThreadLocal<Collection<Runnable>> endRequestRunnables = new ThreadLocal<Collection<Runnable>>(){

        @Override
        protected Collection<Runnable> initialValue() {
            return new ArrayList<Runnable>();
        }
    };

    public CdiAppContextsService() {
        this(WebBeansContext.currentInstance(), WebBeansContext.currentInstance().getOpenWebBeansConfiguration().supportsConversation());
    }

    public CdiAppContextsService(WebBeansContext wbc, boolean supportsConversation) {
        this.webBeansContext = wbc != null ? wbc : WebBeansContext.currentInstance();
        this.dependentContext.setActive(true);
        this.conversationContext = supportsConversation ? new ThreadLocal() : null;
        this.applicationContext.setActive(true);
        this.singletonContext.setActive(true);
    }

    private void endRequest() {
        for (Runnable r : endRequestRunnables.get()) {
            try {
                r.run();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        endRequestRunnables.remove();
    }

    public static void pushRequestReleasable(Runnable runnable) {
        endRequestRunnables.get().add(runnable);
    }

    public void init(Object initializeObject) {
        this.startContext(ApplicationScoped.class, initializeObject);
        this.startContext(Singleton.class, initializeObject);
    }

    public void destroy(Object destroyObject) {
        this.endContext(ApplicationScoped.class, destroyObject);
        this.endContext(Singleton.class, destroyObject);
        this.removeThreadLocals();
    }

    public void removeThreadLocals() {
        this.requestContext.set(null);
        this.requestContext.remove();
        this.sessionContext.set(null);
        this.sessionContext.remove();
        if (null != this.conversationContext) {
            this.conversationContext.set(null);
            this.conversationContext.remove();
        }
    }

    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.destroyRequestContext();
            } else if (scopeType.equals(SessionScoped.class)) {
                this.destroySessionContext((HttpSession)endParameters);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.destroyApplicationContext();
            } else if (!scopeType.equals(Dependent.class)) {
                if (scopeType.equals(Singleton.class)) {
                    this.destroySingletonContext();
                } else if (this.supportsConversation() && scopeType.equals(ConversationScoped.class)) {
                    this.destroyConversationContext();
                } else if (logger.isWarningEnabled()) {
                    logger.warning("CDI-OpenWebBeans container in OpenEJB does not support context scope " + scopeType.getSimpleName() + ". Scopes @Dependent, @RequestScoped, @ApplicationScoped and @Singleton are supported scope types");
                }
            }
        }
    }

    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getRequestContext();
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getSessionContext();
        }
        if (scopeType.equals(ApplicationScoped.class)) {
            return this.getApplicationContext();
        }
        if (this.supportsConversation() && scopeType.equals(ConversationScoped.class)) {
            return this.getConversationContext();
        }
        if (scopeType.equals(Dependent.class)) {
            return this.dependentContext;
        }
        if (scopeType.equals(Singleton.class)) {
            return this.getSingletonContext();
        }
        return null;
    }

    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.initRequestContext((ServletRequestEvent)startParameter);
            } else if (scopeType.equals(SessionScoped.class)) {
                this.initSessionContext((HttpSession)startParameter);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.initApplicationContext();
            } else if (scopeType.equals(Dependent.class)) {
                this.initSingletonContext();
            } else if (!scopeType.equals(Singleton.class)) {
                if (this.supportsConversation() && scopeType.equals(ConversationScoped.class)) {
                    this.initConversationContext((ConversationContext)startParameter);
                } else if (logger.isWarningEnabled()) {
                    logger.warning("CDI-OpenWebBeans container in OpenEJB does not support context scope " + scopeType.getSimpleName() + ". Scopes @Dependent, @RequestScoped, @ApplicationScoped and @Singleton are supported scope types");
                }
            }
        }
    }

    private void initSingletonContext() {
        this.singletonContext.setActive(true);
    }

    private void initApplicationContext() {
        this.applicationContext.setActive(true);
    }

    public boolean supportsContext(Class<? extends Annotation> scopeType) {
        return scopeType.equals(RequestScoped.class) || scopeType.equals(SessionScoped.class) || scopeType.equals(ApplicationScoped.class) || scopeType.equals(Dependent.class) || scopeType.equals(Singleton.class) || scopeType.equals(ConversationScoped.class) && this.supportsConversation();
    }

    private void initRequestContext(ServletRequestEvent event) {
        ServletRequestContext rq = new ServletRequestContext();
        rq.setActive(true);
        this.requestContext.set((RequestContext)rq);
        if (event != null) {
            HttpSession session;
            HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
            rq.setServletRequest(request);
            if (request != null && (session = request.getSession(false)) != null) {
                this.initSessionContext(session);
            }
        }
    }

    private void destroyRequestContext() {
        ELContextStore elStore;
        RequestContext context;
        this.endRequest();
        if (this.supportsConversation()) {
            this.cleanupConversation();
        }
        if ((context = this.getRequestContext()) != null) {
            context.destroy();
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        this.removeThreadLocals();
        RequestScopedBeanInterceptorHandler.removeThreadLocals();
    }

    private void cleanupConversation() {
        if (this.webBeansContext.getService(ConversationService.class) == null) {
            return;
        }
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext == null) {
            return;
        }
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        Conversation conversation = conversationManager.getConversationBeanReference();
        if (conversation == null) {
            return;
        }
        if (conversation.isTransient()) {
            this.webBeansContext.getContextsService().endContext(ConversationScoped.class, null);
        } else {
            ConversationImpl conversationImpl = (ConversationImpl)conversation;
            conversationImpl.updateTimeOut();
            conversationImpl.setInUsed(false);
        }
    }

    private void initSessionContext(HttpSession session) {
        if (session == null) {
            return;
        }
        String sessionId = session.getId();
        SessionContext currentSessionContext = this.sessionCtxManager.getSessionContextWithSessionId(sessionId);
        if (currentSessionContext == null) {
            currentSessionContext = this.newSessionContext(session);
            this.sessionCtxManager.addNewSessionContext(sessionId, currentSessionContext);
        }
        currentSessionContext.setActive(true);
        this.sessionContext.set(currentSessionContext);
    }

    private SessionContext newSessionContext(HttpSession session) {
        String classname = SystemInstance.get().getComponent(ThreadSingletonService.class).sessionContextClass();
        if (classname != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
                try {
                    Constructor<?> constr = clazz.getConstructor(HttpSession.class);
                    return (SessionContext)constr.newInstance(session);
                }
                catch (Exception e) {
                    return (SessionContext)clazz.newInstance();
                }
            }
            catch (Exception e) {
                logger.error("Can't instantiate " + classname + ", using default session context", e);
            }
        }
        return new SessionContext();
    }

    private void destroySessionContext(HttpSession session) {
        if (session != null) {
            SessionContext context = this.sessionContext.get();
            if (context != null) {
                context.destroy();
            }
            this.sessionContext.set(null);
            this.sessionContext.remove();
            this.sessionCtxManager.removeSessionContextWithSessionId(session.getId());
        }
    }

    private void destroyApplicationContext() {
        this.applicationContext.destroy();
    }

    private void destroySingletonContext() {
        this.singletonContext.destroy();
    }

    private void initConversationContext(ConversationContext context) {
        if (this.webBeansContext.getService(ConversationService.class) == null) {
            return;
        }
        if (context == null) {
            if (this.conversationContext.get() == null) {
                ConversationContext newContext = new ConversationContext();
                newContext.setActive(true);
                this.conversationContext.set(newContext);
            } else {
                this.conversationContext.get().setActive(true);
            }
        } else {
            context.setActive(true);
            this.conversationContext.set(context);
        }
    }

    private void destroyConversationContext() {
        if (this.webBeansContext.getService(ConversationService.class) == null) {
            return;
        }
        ConversationContext context = this.getConversationContext();
        if (context != null) {
            context.destroy();
        }
        if (null != this.conversationContext) {
            this.conversationContext.set(null);
            this.conversationContext.remove();
        }
    }

    private RequestContext getRequestContext() {
        return this.requestContext.get();
    }

    private Context getSessionContext() {
        SessionContext context = this.sessionContext.get();
        if (context == null || !context.isActive()) {
            this.lazyStartSessionContext();
            context = this.sessionContext.get();
        }
        return context;
    }

    private ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private SingletonContext getSingletonContext() {
        return this.singletonContext;
    }

    private ConversationContext getConversationContext() {
        return this.conversationContext.get();
    }

    private Context lazyStartSessionContext() {
        if (logger.isDebugEnabled()) {
            logger.debug(">lazyStartSessionContext");
        }
        Context webContext = null;
        Context context = this.getCurrentContext(RequestScoped.class);
        if (context instanceof ServletRequestContext) {
            ServletRequestContext requestContext = (ServletRequestContext)context;
            HttpServletRequest servletRequest = requestContext.getServletRequest();
            if (null != servletRequest) {
                try {
                    HttpSession currentSession = servletRequest.getSession();
                    this.initSessionContext(currentSession);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Lazy SESSION context initialization SUCCESS");
                    }
                }
                catch (Exception e) {
                    logger.error("ERROR_0013", e);
                }
            } else {
                logger.warning("Could NOT lazily initialize session context because NO active request context");
            }
        } else {
            logger.warning("Could NOT lazily initialize session context because of " + context + " RequestContext");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<lazyStartSessionContext " + webContext);
        }
        return webContext;
    }

    private boolean supportsConversation() {
        return this.conversationContext != null;
    }

    public void updateSessionIdMapping(String oldId, String newId) {
        this.sessionCtxManager.updateSessionIdMapping(oldId, newId);
    }

    public State saveState() {
        return new State(this.requestContext.get(), this.sessionContext.get(), this.conversationContext.get());
    }

    public State restoreState(State state) {
        State old = this.saveState();
        this.requestContext.set(state.request);
        this.sessionContext.set(state.session);
        this.conversationContext.set(state.conversation);
        return old;
    }

    public static class State {
        private final RequestContext request;
        private final SessionContext session;
        private final ConversationContext conversation;

        public State(RequestContext request, SessionContext session, ConversationContext conversation) {
            this.request = request;
            this.session = session;
            this.conversation = conversation;
        }
    }
}

