/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;

public class OptimizedLoaderService
implements LoaderService {
    private static final Logger log = Logger.getInstance(LogCategory.OPENEJB.createChild("cdi"), OptimizedLoaderService.class);
    public static final ThreadLocal<Collection<String>> ADDITIONAL_EXTENSIONS = new ThreadLocal();
    private final LoaderService loaderService;

    public OptimizedLoaderService() {
        this((LoaderService)new DefaultLoaderService());
    }

    public OptimizedLoaderService(LoaderService loaderService) {
        this.loaderService = loaderService;
    }

    public <T> List<T> load(Class<T> serviceType) {
        return this.load(serviceType, Thread.currentThread().getContextClassLoader());
    }

    public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        Collection<String> additional;
        if (OpenWebBeansPlugin.class.equals(serviceType)) {
            return this.loadWebBeansPlugins(classLoader);
        }
        List list = this.loaderService.load(serviceType, classLoader);
        if (Extension.class.equals(serviceType) && (additional = ADDITIONAL_EXTENSIONS.get()) != null) {
            for (String name : additional) {
                try {
                    list.add(classLoader.loadClass(name).newInstance());
                }
                catch (Exception ignored) {}
            }
        }
        return list;
    }

    private <T> List<T> loadWebBeansPlugins(ClassLoader loader) {
        Class<?> clazz;
        String[] knownPlugins = new String[]{"org.apache.openejb.cdi.CdiPlugin", "org.apache.geronimo.openejb.cdi.GeronimoWebBeansPlugin"};
        String[] loaderAwareKnownPlugins = new String[]{"org.apache.webbeans.jsf.plugin.OpenWebBeansJsfPlugin"};
        ArrayList<Object> list = new ArrayList<Object>();
        for (String name : knownPlugins) {
            try {
                clazz = loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            try {
                list.add(clazz.newInstance());
            }
            catch (Exception e) {
                log.error("Unable to load OpenWebBeansPlugin: " + name);
            }
        }
        for (String name : loaderAwareKnownPlugins) {
            try {
                clazz = loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            try {
                list.add(Proxy.newProxyInstance(loader, new Class[]{OpenWebBeansPlugin.class}, (InvocationHandler)new ClassLoaderAwareHandler(clazz.getSimpleName(), clazz.newInstance(), loader)));
            }
            catch (Exception e) {
                log.error("Unable to load OpenWebBeansPlugin: " + name);
            }
        }
        return list;
    }

    private static class ClassLoaderAwareHandler
    implements InvocationHandler {
        private final Object delegate;
        private final ClassLoader loader;
        private final String toString;

        private ClassLoaderAwareHandler(String toString, Object delegate, ClassLoader loader) {
            this.delegate = delegate;
            this.loader = loader;
            this.toString = toString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.toString;
            }
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.loader);
            try {
                Object object = method.invoke(this.delegate, args);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

