/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.Files;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.xbean.finder.ClassLoaders;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QuickContextXmlParser
extends DefaultHandler {
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    private String virtualClasspath = "";
    private Collection<URL> urls = null;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("Loader".equalsIgnoreCase(localName)) {
            String loaderClass;
            String className = attributes.getValue("className");
            if (className != null && ("org.apache.catalina.loader.VirtualWebappLoader".equals(className) || "org.apache.tomee.catalina.ProvisioningWebappLoader".equals(className))) {
                this.virtualClasspath = attributes.getValue("virtualClasspath");
            }
            if ((loaderClass = attributes.getValue("loaderClass")) != null) {
                try {
                    ClassLoader parent = ParentClassLoaderFinder.Helper.get();
                    Object loader = parent.loadClass("org.apache.catalina.loader.WebappLoader").newInstance();
                    Reflections.set(loader, "loaderClass", loaderClass);
                    Reflections.set(loader, "parentClassLoader", parent);
                    ClassLoader instance = (ClassLoader)ClassLoader.class.cast(Reflections.invokeByReflection(loader, "createClassLoader", new Class[0], null));
                    if (instance != null) {
                        this.urls = ClassLoaders.findUrls((ClassLoader)instance);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public Collection<URL> getAdditionalURLs() {
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (this.virtualClasspath != null) {
            StringTokenizer tkn = new StringTokenizer(this.virtualClasspath, ";");
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken().trim();
                if (token.isEmpty()) continue;
                set.addAll(Files.listJars(token));
            }
        }
        if (this.urls != null) {
            set.addAll(this.urls);
        }
        return set;
    }

    public static QuickContextXmlParser parse(File contextXml) {
        QuickContextXmlParser handler = new QuickContextXmlParser();
        try {
            SAXParser parser = FACTORY.newSAXParser();
            parser.parse(contextXml, (DefaultHandler)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler;
    }

    static {
        FACTORY.setNamespaceAware(true);
        FACTORY.setValidating(false);
    }
}

